/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.de.dfki.lt.freetts.mbrola;

import io.github.elytra.copo.repackage.com.sun.speech.freetts.Item;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.ProcessException;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.Relation;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.Utterance;
import io.github.elytra.copo.repackage.com.sun.speech.freetts.UtteranceProcessor;

public class ParametersToMbrolaConverter
implements UtteranceProcessor {
    public void processUtterance(Utterance utterance) throws ProcessException {
        Relation segmentRelation = utterance.getRelation("Segment");
        Relation targetRelation = utterance.getRelation("Target");
        Item segment = segmentRelation.getHead();
        Item target = null;
        if (targetRelation != null) {
            target = targetRelation.getHead();
        }
        float prevEnd = 0.0f;
        while (segment != null) {
            float end = segment.getFeatures().getFloat("end");
            int dur = (int)((end - prevEnd) * 1000.0f);
            StringBuffer targetStringBuffer = new StringBuffer();
            while (target != null && target.getFeatures().getFloat("pos") <= end) {
                float pos = target.getFeatures().getFloat("pos");
                int percentage = (int)((pos - prevEnd) * 1000.0f) * 100 / dur;
                int f0 = (int)target.getFeatures().getFloat("f0");
                targetStringBuffer.append(" ");
                targetStringBuffer.append(percentage);
                targetStringBuffer.append(" ");
                targetStringBuffer.append(f0);
                target = target.getNext();
            }
            segment.getFeatures().setInt("mbr_dur", dur);
            segment.getFeatures().setString("mbr_targets", targetStringBuffer.toString().trim());
            prevEnd = end;
            segment = segment.getNext();
        }
    }

    public String toString() {
        return "ParametersToMbrolaConverter";
    }
}

