/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.io.github.elytra.concrete;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.UnmodifiableIterator;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.Message;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.NetworkContext$$Lambda$1;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.NetworkContext$$Lambda$4;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.NetworkContext$$Lambda$5;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.NetworkContext$$Lambda$6;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.WireField;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.exception.BadMessageException;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.exception.WrongSideException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkContext {
    static final Logger log;
    private static final String DEFAULT_PACKAGE;
    protected static final Instanciator instanciator;
    protected final BiMap<Class<? extends Message>, Integer> packetIds = HashBiMap.create();
    protected final Map<Class<? extends Message>, List<WireField<?>>> marshallers = Maps.newHashMap();
    protected final Multiset<Class<? extends Message>> booleanCount = HashMultiset.create();
    protected final String channel;
    private int nextPacketId = 0;

    private NetworkContext(String channel) {
        if (NetworkContext.class.getName().startsWith(DEFAULT_PACKAGE)) {
            if (!((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
                throw new RuntimeException("Concrete is designed to be shaded and must not be left in the default package! (Offending mod: " + Loader.instance().activeModContainer().getName() + ")");
            }
            log.warn("Concrete is in the default package. This is not a fatal error, as you are in a development environment, but remember to repackage it!");
        }
        this.channel = channel;
        NetworkRegistry.INSTANCE.newEventDrivenChannel(channel).register((Object)this);
    }

    public NetworkContext register(Class<? extends Message> clazz) {
        if (this.packetIds.containsKey(clazz)) {
            log.warn("{} was registered twice", new Object[]{clazz});
            return this;
        }
        this.packetIds.put(clazz, (Object)this.nextPacketId++);
        ArrayList fields = Lists.newArrayList();
        for (Class<? extends Message> cursor = clazz; cursor != null && cursor != Object.class; cursor = cursor.getSuperclass()) {
            for (Field f : cursor.getDeclaredFields()) {
                if (Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
                if (f.getType() == Boolean.TYPE) {
                    this.booleanCount.add(clazz);
                }
                WireField wf = new WireField(f);
                fields.add(wf);
            }
        }
        this.marshallers.put(clazz, fields);
        return this;
    }

    public String getChannel() {
        return this.channel;
    }

    protected FMLProxyPacket getPacketFrom(Message m) {
        UnmodifiableIterator iter;
        if (!this.packetIds.containsKey(m.getClass())) {
            throw new BadMessageException(m.getClass() + " is not registered");
        }
        PacketBuffer payload = new PacketBuffer(Unpooled.buffer());
        payload.writeByte(((Integer)this.packetIds.get(m.getClass())).intValue());
        int bools = this.booleanCount.count(m.getClass());
        if (bools > 0) {
            iter = Iterators.filter(this.marshallers.get(m.getClass()).iterator(), (Predicate)NetworkContext$$Lambda$1.lambdaFactory$());
            ArrayList li = Lists.newArrayList((Iterator)iter);
            for (int i = 0; i < (bools + 7) / 8; ++i) {
                int by = 0;
                for (int j = i * 8; j < Math.min(li.size(), i + 8); ++j) {
                    WireField wf = (WireField)li.get(j);
                    if (!((Boolean)wf.get(m)).booleanValue()) continue;
                    by |= 1 << j;
                }
                payload.writeByte(by);
            }
        }
        iter = Iterators.filter(this.marshallers.get(m.getClass()).iterator(), (Predicate)NetworkContext$$Lambda$4.lambdaFactory$());
        while (iter.hasNext()) {
            WireField wf = (WireField)iter.next();
            wf.marshal(m, (ByteBuf)payload);
        }
        return new FMLProxyPacket(payload, this.channel);
    }

    @SubscribeEvent
    public void onServerCustomPacket(FMLNetworkEvent.ServerCustomPacketEvent e) {
        ByteBuf payload = e.getPacket().payload();
        Message m = this.readPacket(e.side(), payload);
        m.doHandleServer((EntityPlayer)((NetHandlerPlayServer)e.getHandler()).field_147369_b);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientCustomPacket(FMLNetworkEvent.ClientCustomPacketEvent e) {
        ByteBuf payload = e.getPacket().payload();
        Message m = this.readPacket(e.side(), payload);
        m.doHandleClient();
    }

    private Message readPacket(Side side, ByteBuf payload) {
        UnmodifiableIterator iter;
        Message m;
        short id = payload.readUnsignedByte();
        if (!this.packetIds.containsValue((Object)id)) {
            throw new IllegalArgumentException("Unknown packet id " + id);
        }
        Class clazz = (Class)this.packetIds.inverse().get((Object)id);
        try {
            m = (Message)instanciator.instanciate(clazz, this);
        }
        catch (Throwable t) {
            throw new BadMessageException("Cannot instanciate message class " + clazz, t);
        }
        if (m.getSide() != side) {
            throw new WrongSideException("Cannot receive packet of type " + clazz + " on side " + side);
        }
        int bools = this.booleanCount.count((Object)clazz);
        if (bools > 0) {
            iter = Iterators.filter(this.marshallers.get(m.getClass()).iterator(), (Predicate)NetworkContext$$Lambda$5.lambdaFactory$());
            ArrayList li = Lists.newArrayList((Iterator)iter);
            for (int i = 0; i < (bools + 7) / 8; ++i) {
                short by = payload.readUnsignedByte();
                for (int j = i * 8; j < Math.min(li.size(), i + 8); ++j) {
                    boolean val = (by & 1 << j - i) != 0;
                    ((WireField)li.get(j)).set(m, val);
                }
            }
        }
        iter = Iterators.filter(this.marshallers.get(m.getClass()).iterator(), (Predicate)NetworkContext$$Lambda$6.lambdaFactory$());
        while (iter.hasNext()) {
            WireField wf = (WireField)iter.next();
            wf.unmarshal(m, payload);
        }
        return m;
    }

    public static NetworkContext forChannel(String channel) {
        if (channel.length() > 20) {
            throw new IllegalArgumentException("Channel name too long, must be at most 20 characters");
        }
        return new NetworkContext(channel);
    }

    private static /* synthetic */ boolean lambda$readPacket$3(WireField it) {
        return it.getType() != Boolean.TYPE;
    }

    private static /* synthetic */ boolean lambda$readPacket$2(WireField it) {
        return it.getType() == Boolean.TYPE;
    }

    private static /* synthetic */ boolean lambda$getPacketFrom$1(WireField it) {
        return it.getType() != Boolean.TYPE;
    }

    private static /* synthetic */ boolean lambda$getPacketFrom$0(WireField it) {
        return it.getType() == Boolean.TYPE;
    }

    static {
        boolean hasMethodHandles;
        log = LogManager.getLogger((String)"Concrete");
        char[] c = new char[]{'i', 'o', '.', 'g', 'i', 't', 'h', 'u', 'b', '.', 'e', 'l', 'y', 't', 'r', 'a', '.', 'c', 'o', 'n', 'c', 'r', 'e', 't', 'e'};
        DEFAULT_PACKAGE = new String(c);
        try {
            Class.forName("java.lang.invoke.MethodHandles");
            hasMethodHandles = true;
        }
        catch (Exception e) {
            hasMethodHandles = false;
        }
        instanciator = hasMethodHandles ? new MethodHandlesInstanciator() : new ReflectionInstanciator();
    }

    static /* synthetic */ boolean access$lambda$0(WireField wireField) {
        return NetworkContext.lambda$getPacketFrom$0(wireField);
    }

    static /* synthetic */ boolean access$lambda$1(WireField wireField) {
        return NetworkContext.lambda$getPacketFrom$1(wireField);
    }

    static /* synthetic */ boolean access$lambda$2(WireField wireField) {
        return NetworkContext.lambda$readPacket$2(wireField);
    }

    static /* synthetic */ boolean access$lambda$3(WireField wireField) {
        return NetworkContext.lambda$readPacket$3(wireField);
    }

    public static interface Instanciator {
        public <T> T instanciate(Class<T> var1, NetworkContext var2);
    }

    public static class MethodHandlesInstanciator
    implements Instanciator {
        private Map<Class<?>, MethodHandle> handles = Maps.newHashMap();

        @Override
        public <T> T instanciate(Class<T> clazz, NetworkContext nc) {
            try {
                if (!this.handles.containsKey(clazz)) {
                    Constructor<T> cons = clazz.getConstructor(NetworkContext.class);
                    this.handles.put(clazz, MethodHandles.lookup().unreflectConstructor(cons));
                }
                return (T)this.handles.get(clazz).invoke(nc);
            }
            catch (Throwable e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static class ReflectionInstanciator
    implements Instanciator {
        private Map<Class<?>, Constructor<?>> constructors = Maps.newHashMap();

        @Override
        public <T> T instanciate(Class<T> clazz, NetworkContext nc) {
            try {
                if (!this.constructors.containsKey(clazz)) {
                    Constructor<T> cons = clazz.getConstructor(NetworkContext.class);
                    this.constructors.put(clazz, cons);
                }
                return (T)this.constructors.get(clazz).newInstance(nc);
            }
            catch (Throwable e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

