/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.io.github.elytra.concrete;

import com.google.common.base.Throwables;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.DefaultMarshallers;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.Marshallable;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.MarshallableMarshaller;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.Marshaller;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.NetworkContext;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.accessor.Accessor;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.accessor.Accessors;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.annotation.field.MarshalledAs;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.exception.BadMessageException;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

class WireField<T> {
    private Accessor<T> accessor;
    private Marshaller<T> marshaller;
    private Class<T> type;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WireField(Field f) {
        block12: {
            f.setAccessible(true);
            this.accessor = Accessors.from(f);
            try {
                this.type = f.getType();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            MarshalledAs ma = f.getAnnotation(MarshalledAs.class);
            if (ma != null) {
                this.marshaller = DefaultMarshallers.getByName(ma.value());
                if (this.marshaller == null) {
                    try {
                        Class<?> clazz = Class.forName(ma.value());
                        if (!Marshaller.class.isAssignableFrom(clazz)) break block12;
                        try {
                            Field inst = clazz.getDeclaredField("INSTANCE");
                            inst.setAccessible(true);
                            this.marshaller = (Marshaller)inst.get(null);
                        }
                        catch (Exception e) {
                            NetworkContext.log.warn(clazz.getName() + " does not appear to define an INSTANCE field, but it should", (Throwable)e);
                        }
                        if (this.marshaller != null) break block12;
                        try {
                            Constructor<?> cons = clazz.getConstructor(new Class[0]);
                            this.marshaller = (Marshaller)cons.newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            throw new BadMessageException("Cannot instanciate marshaller class " + clazz.getName());
                        }
                    }
                    catch (Exception e) {
                        throw new BadMessageException("Cannot figure out what marshaller \"" + ma.value() + "\" refers to! (Field " + f.getName() + " in " + f.getDeclaringClass().getName() + ")", e);
                    }
                }
            } else {
                this.marshaller = Marshallable.class.isAssignableFrom(this.type) ? new MarshallableMarshaller<T>(this.type) : DefaultMarshallers.getByType(this.type);
            }
        }
        if (this.marshaller == null && this.type != Boolean.TYPE) {
            throw new BadMessageException("Cannot find an appropriate marshaller for field " + this.type + " " + f.getDeclaringClass().getName() + "." + f.getName());
        }
    }

    public T get(Object owner) {
        return this.accessor.get(owner);
    }

    public void set(Object owner, T value) {
        this.accessor.set(owner, value);
    }

    public void marshal(Object owner, ByteBuf out) {
        this.marshaller.marshal(out, this.accessor.get(owner));
    }

    public void unmarshal(Object owner, ByteBuf in) {
        this.accessor.set(owner, this.marshaller.unmarshal(in));
    }

    public Class<? extends T> getType() {
        return this.type;
    }
}

