/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.io.github.elytra.concrete.accessor;

import com.google.common.base.Throwables;
import io.github.elytra.copo.repackage.io.github.elytra.concrete.accessor.Accessor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;

class MethodHandlesAccessor<T>
implements Accessor<T> {
    private MethodHandle getter;
    private MethodHandle setter;

    public MethodHandlesAccessor(Field f) {
        try {
            f.setAccessible(true);
            this.getter = MethodHandles.lookup().unreflectGetter(f);
            this.setter = MethodHandles.lookup().unreflectSetter(f);
        }
        catch (IllegalAccessException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public T get(Object owner) {
        try {
            return (T)this.getter.invoke(owner);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void set(Object owner, T value) {
        try {
            this.setter.invoke(owner, value);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

