/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.repackage.sonic;

public class Sonic {
    private static final int SONIC_MIN_PITCH = 65;
    private static final int SONIC_MAX_PITCH = 400;
    private static final int SONIC_AMDF_FREQ = 4000;
    private short[] inputBuffer;
    private short[] outputBuffer;
    private short[] pitchBuffer;
    private short[] downSampleBuffer;
    private float speed;
    private float volume;
    private float pitch;
    private float rate;
    private int oldRatePosition;
    private int newRatePosition;
    private boolean useChordPitch;
    private int quality;
    private int numChannels;
    private int inputBufferSize;
    private int pitchBufferSize;
    private int outputBufferSize;
    private int numInputSamples;
    private int numOutputSamples;
    private int numPitchSamples;
    private int minPeriod;
    private int maxPeriod;
    private int maxRequired;
    private int remainingInputToCopy;
    private int sampleRate;
    private int prevPeriod;
    private int prevMinDiff;
    private int minDiff;
    private int maxDiff;

    private short[] resize(short[] oldArray, int newLength) {
        short[] newArray = new short[newLength *= this.numChannels];
        int length = oldArray.length <= newLength ? oldArray.length : newLength;
        System.arraycopy(oldArray, 0, newArray, 0, length);
        return newArray;
    }

    private void move(short[] dest, int destPos, short[] source, int sourcePos, int numSamples) {
        System.arraycopy(source, sourcePos * this.numChannels, dest, destPos * this.numChannels, numSamples * this.numChannels);
    }

    private void scaleSamples(short[] samples, int position, int numSamples, float volume) {
        int fixedPointVolume = (int)(volume * 4096.0f);
        int start = position * this.numChannels;
        int stop = start + numSamples * this.numChannels;
        for (int xSample = start; xSample < stop; ++xSample) {
            int value = samples[xSample] * fixedPointVolume >> 12;
            if (value > Short.MAX_VALUE) {
                value = Short.MAX_VALUE;
            } else if (value < -32767) {
                value = -32767;
            }
            samples[xSample] = (short)value;
        }
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public float getRate() {
        return this.rate;
    }

    public void setRate(float rate) {
        this.rate = rate;
        this.oldRatePosition = 0;
        this.newRatePosition = 0;
    }

    public boolean getChordPitch() {
        return this.useChordPitch;
    }

    public void setChordPitch(boolean useChordPitch) {
        this.useChordPitch = useChordPitch;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    private void allocateStreamBuffers(int sampleRate, int numChannels) {
        this.minPeriod = sampleRate / 400;
        this.maxPeriod = sampleRate / 65;
        this.inputBufferSize = this.maxRequired = 2 * this.maxPeriod;
        this.inputBuffer = new short[this.maxRequired * numChannels];
        this.outputBufferSize = this.maxRequired;
        this.outputBuffer = new short[this.maxRequired * numChannels];
        this.pitchBufferSize = this.maxRequired;
        this.pitchBuffer = new short[this.maxRequired * numChannels];
        this.downSampleBuffer = new short[this.maxRequired];
        this.sampleRate = sampleRate;
        this.numChannels = numChannels;
        this.oldRatePosition = 0;
        this.newRatePosition = 0;
        this.prevPeriod = 0;
    }

    public Sonic(int sampleRate, int numChannels) {
        this.allocateStreamBuffers(sampleRate, numChannels);
        this.speed = 1.0f;
        this.pitch = 1.0f;
        this.volume = 1.0f;
        this.rate = 1.0f;
        this.oldRatePosition = 0;
        this.newRatePosition = 0;
        this.useChordPitch = false;
        this.quality = 0;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.allocateStreamBuffers(sampleRate, this.numChannels);
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public void setNumChannels(int numChannels) {
        this.allocateStreamBuffers(this.sampleRate, numChannels);
    }

    private void enlargeOutputBufferIfNeeded(int numSamples) {
        if (this.numOutputSamples + numSamples > this.outputBufferSize) {
            this.outputBufferSize += (this.outputBufferSize >> 1) + numSamples;
            this.outputBuffer = this.resize(this.outputBuffer, this.outputBufferSize);
        }
    }

    private void enlargeInputBufferIfNeeded(int numSamples) {
        if (this.numInputSamples + numSamples > this.inputBufferSize) {
            this.inputBufferSize += (this.inputBufferSize >> 1) + numSamples;
            this.inputBuffer = this.resize(this.inputBuffer, this.inputBufferSize);
        }
    }

    private void addFloatSamplesToInputBuffer(float[] samples, int numSamples) {
        if (numSamples == 0) {
            return;
        }
        this.enlargeInputBufferIfNeeded(numSamples);
        int xBuffer = this.numInputSamples * this.numChannels;
        for (int xSample = 0; xSample < numSamples * this.numChannels; ++xSample) {
            this.inputBuffer[xBuffer++] = (short)(samples[xSample] * 32767.0f);
        }
        this.numInputSamples += numSamples;
    }

    private void addShortSamplesToInputBuffer(short[] samples, int numSamples) {
        if (numSamples == 0) {
            return;
        }
        this.enlargeInputBufferIfNeeded(numSamples);
        this.move(this.inputBuffer, this.numInputSamples, samples, 0, numSamples);
        this.numInputSamples += numSamples;
    }

    private void addUnsignedByteSamplesToInputBuffer(byte[] samples, int numSamples) {
        this.enlargeInputBufferIfNeeded(numSamples);
        int xBuffer = this.numInputSamples * this.numChannels;
        for (int xSample = 0; xSample < numSamples * this.numChannels; ++xSample) {
            short sample = (short)((samples[xSample] & 0xFF) - 128);
            this.inputBuffer[xBuffer++] = (short)(sample << 8);
        }
        this.numInputSamples += numSamples;
    }

    private void addBytesToInputBuffer(byte[] inBuffer, int numBytes) {
        int numSamples = numBytes / (2 * this.numChannels);
        this.enlargeInputBufferIfNeeded(numSamples);
        int xBuffer = this.numInputSamples * this.numChannels;
        int xByte = 0;
        while (xByte + 1 < numBytes) {
            short sample = (short)(inBuffer[xByte] & 0xFF | inBuffer[xByte + 1] << 8);
            this.inputBuffer[xBuffer++] = sample;
            xByte += 2;
        }
        this.numInputSamples += numSamples;
    }

    private void removeInputSamples(int position) {
        int remainingSamples = this.numInputSamples - position;
        this.move(this.inputBuffer, 0, this.inputBuffer, position, remainingSamples);
        this.numInputSamples = remainingSamples;
    }

    private void copyToOutput(short[] samples, int position, int numSamples) {
        this.enlargeOutputBufferIfNeeded(numSamples);
        this.move(this.outputBuffer, this.numOutputSamples, samples, position, numSamples);
        this.numOutputSamples += numSamples;
    }

    private int copyInputToOutput(int position) {
        int numSamples = this.remainingInputToCopy;
        if (numSamples > this.maxRequired) {
            numSamples = this.maxRequired;
        }
        this.copyToOutput(this.inputBuffer, position, numSamples);
        this.remainingInputToCopy -= numSamples;
        return numSamples;
    }

    public int readFloatFromStream(float[] samples, int maxSamples) {
        int numSamples = this.numOutputSamples;
        int remainingSamples = 0;
        if (numSamples == 0) {
            return 0;
        }
        if (numSamples > maxSamples) {
            remainingSamples = numSamples - maxSamples;
            numSamples = maxSamples;
        }
        for (int xSample = 0; xSample < numSamples * this.numChannels; ++xSample) {
            samples[xSample++] = (float)this.outputBuffer[xSample] / 32767.0f;
        }
        this.move(this.outputBuffer, 0, this.outputBuffer, numSamples, remainingSamples);
        this.numOutputSamples = remainingSamples;
        return numSamples;
    }

    public int readShortFromStream(short[] samples, int maxSamples) {
        int numSamples = this.numOutputSamples;
        int remainingSamples = 0;
        if (numSamples == 0) {
            return 0;
        }
        if (numSamples > maxSamples) {
            remainingSamples = numSamples - maxSamples;
            numSamples = maxSamples;
        }
        this.move(samples, 0, this.outputBuffer, 0, numSamples);
        this.move(this.outputBuffer, 0, this.outputBuffer, numSamples, remainingSamples);
        this.numOutputSamples = remainingSamples;
        return numSamples;
    }

    public int readUnsignedByteFromStream(byte[] samples, int maxSamples) {
        int numSamples = this.numOutputSamples;
        int remainingSamples = 0;
        if (numSamples == 0) {
            return 0;
        }
        if (numSamples > maxSamples) {
            remainingSamples = numSamples - maxSamples;
            numSamples = maxSamples;
        }
        for (int xSample = 0; xSample < numSamples * this.numChannels; ++xSample) {
            samples[xSample] = (byte)((this.outputBuffer[xSample] >> 8) + 128);
        }
        this.move(this.outputBuffer, 0, this.outputBuffer, numSamples, remainingSamples);
        this.numOutputSamples = remainingSamples;
        return numSamples;
    }

    public int readBytesFromStream(byte[] outBuffer, int maxBytes) {
        int maxSamples = maxBytes / (2 * this.numChannels);
        int numSamples = this.numOutputSamples;
        int remainingSamples = 0;
        if (numSamples == 0 || maxSamples == 0) {
            return 0;
        }
        if (numSamples > maxSamples) {
            remainingSamples = numSamples - maxSamples;
            numSamples = maxSamples;
        }
        for (int xSample = 0; xSample < numSamples * this.numChannels; ++xSample) {
            short sample = this.outputBuffer[xSample];
            outBuffer[xSample << 1] = (byte)(sample & 0xFF);
            outBuffer[(xSample << 1) + 1] = (byte)(sample >> 8);
        }
        this.move(this.outputBuffer, 0, this.outputBuffer, numSamples, remainingSamples);
        this.numOutputSamples = remainingSamples;
        return 2 * numSamples * this.numChannels;
    }

    public void flushStream() {
        int remainingSamples = this.numInputSamples;
        float s = this.speed / this.pitch;
        float r = this.rate * this.pitch;
        int expectedOutputSamples = this.numOutputSamples + (int)(((float)remainingSamples / s + (float)this.numPitchSamples) / r + 0.5f);
        this.enlargeInputBufferIfNeeded(remainingSamples + 2 * this.maxRequired);
        for (int xSample = 0; xSample < 2 * this.maxRequired * this.numChannels; ++xSample) {
            this.inputBuffer[remainingSamples * this.numChannels + xSample] = 0;
        }
        this.numInputSamples += 2 * this.maxRequired;
        this.writeShortToStream(null, 0);
        if (this.numOutputSamples > expectedOutputSamples) {
            this.numOutputSamples = expectedOutputSamples;
        }
        this.numInputSamples = 0;
        this.remainingInputToCopy = 0;
        this.numPitchSamples = 0;
    }

    public int samplesAvailable() {
        return this.numOutputSamples;
    }

    private void downSampleInput(short[] samples, int position, int skip) {
        int numSamples = this.maxRequired / skip;
        int samplesPerValue = this.numChannels * skip;
        position *= this.numChannels;
        for (int i = 0; i < numSamples; ++i) {
            int value = 0;
            for (int j = 0; j < samplesPerValue; ++j) {
                value += samples[position + i * samplesPerValue + j];
            }
            this.downSampleBuffer[i] = (short)(value /= samplesPerValue);
        }
    }

    private int findPitchPeriodInRange(short[] samples, int position, int minPeriod, int maxPeriod) {
        int bestPeriod = 0;
        int worstPeriod = 255;
        int minDiff = 1;
        int maxDiff = 0;
        position *= this.numChannels;
        for (int period = minPeriod; period <= maxPeriod; ++period) {
            int diff = 0;
            for (int i = 0; i < period; ++i) {
                short sVal = samples[position + i];
                short pVal = samples[position + period + i];
                diff += sVal >= pVal ? sVal - pVal : pVal - sVal;
            }
            if (diff * bestPeriod < minDiff * period) {
                minDiff = diff;
                bestPeriod = period;
            }
            if (diff * worstPeriod <= maxDiff * period) continue;
            maxDiff = diff;
            worstPeriod = period;
        }
        this.minDiff = minDiff / bestPeriod;
        this.maxDiff = maxDiff / worstPeriod;
        return bestPeriod;
    }

    private boolean prevPeriodBetter(int period, int minDiff, int maxDiff, boolean preferNewPeriod) {
        if (minDiff == 0 || this.prevPeriod == 0) {
            return false;
        }
        if (preferNewPeriod) {
            if (maxDiff > minDiff * 3) {
                return false;
            }
            if (minDiff * 2 <= this.prevMinDiff * 3) {
                return false;
            }
        } else if (minDiff <= this.prevMinDiff) {
            return false;
        }
        return true;
    }

    private int findPitchPeriod(short[] samples, int position, boolean preferNewPeriod) {
        int period;
        int skip = 1;
        if (this.sampleRate > 4000 && this.quality == 0) {
            skip = this.sampleRate / 4000;
        }
        if (this.numChannels == 1 && skip == 1) {
            period = this.findPitchPeriodInRange(samples, position, this.minPeriod, this.maxPeriod);
        } else {
            this.downSampleInput(samples, position, skip);
            period = this.findPitchPeriodInRange(this.downSampleBuffer, 0, this.minPeriod / skip, this.maxPeriod / skip);
            if (skip != 1) {
                int minP = (period *= skip) - (skip << 2);
                int maxP = period + (skip << 2);
                if (minP < this.minPeriod) {
                    minP = this.minPeriod;
                }
                if (maxP > this.maxPeriod) {
                    maxP = this.maxPeriod;
                }
                if (this.numChannels == 1) {
                    period = this.findPitchPeriodInRange(samples, position, minP, maxP);
                } else {
                    this.downSampleInput(samples, position, 1);
                    period = this.findPitchPeriodInRange(this.downSampleBuffer, 0, minP, maxP);
                }
            }
        }
        int retPeriod = this.prevPeriodBetter(period, this.minDiff, this.maxDiff, preferNewPeriod) ? this.prevPeriod : period;
        this.prevMinDiff = this.minDiff;
        this.prevPeriod = period;
        return retPeriod;
    }

    private void overlapAdd(int numSamples, int numChannels, short[] out, int outPos, short[] rampDown, int rampDownPos, short[] rampUp, int rampUpPos) {
        for (int i = 0; i < numChannels; ++i) {
            int o = outPos * numChannels + i;
            int u = rampUpPos * numChannels + i;
            int d = rampDownPos * numChannels + i;
            for (int t = 0; t < numSamples; ++t) {
                out[o] = (short)((rampDown[d] * (numSamples - t) + rampUp[u] * t) / numSamples);
                o += numChannels;
                d += numChannels;
                u += numChannels;
            }
        }
    }

    private void overlapAddWithSeparation(int numSamples, int numChannels, int separation, short[] out, int outPos, short[] rampDown, int rampDownPos, short[] rampUp, int rampUpPos) {
        for (int i = 0; i < numChannels; ++i) {
            int o = outPos * numChannels + i;
            int u = rampUpPos * numChannels + i;
            int d = rampDownPos * numChannels + i;
            for (int t = 0; t < numSamples + separation; ++t) {
                if (t < separation) {
                    out[o] = (short)(rampDown[d] * (numSamples - t) / numSamples);
                    d += numChannels;
                } else if (t < numSamples) {
                    out[o] = (short)((rampDown[d] * (numSamples - t) + rampUp[u] * (t - separation)) / numSamples);
                    d += numChannels;
                    u += numChannels;
                } else {
                    out[o] = (short)(rampUp[u] * (t - separation) / numSamples);
                    u += numChannels;
                }
                o += numChannels;
            }
        }
    }

    private void moveNewSamplesToPitchBuffer(int originalNumOutputSamples) {
        int numSamples = this.numOutputSamples - originalNumOutputSamples;
        if (this.numPitchSamples + numSamples > this.pitchBufferSize) {
            this.pitchBufferSize += (this.pitchBufferSize >> 1) + numSamples;
            this.pitchBuffer = this.resize(this.pitchBuffer, this.pitchBufferSize);
        }
        this.move(this.pitchBuffer, this.numPitchSamples, this.outputBuffer, originalNumOutputSamples, numSamples);
        this.numOutputSamples = originalNumOutputSamples;
        this.numPitchSamples += numSamples;
    }

    private void removePitchSamples(int numSamples) {
        if (numSamples == 0) {
            return;
        }
        this.move(this.pitchBuffer, 0, this.pitchBuffer, numSamples, this.numPitchSamples - numSamples);
        this.numPitchSamples -= numSamples;
    }

    private void adjustPitch(int originalNumOutputSamples) {
        int position = 0;
        if (this.numOutputSamples == originalNumOutputSamples) {
            return;
        }
        this.moveNewSamplesToPitchBuffer(originalNumOutputSamples);
        while (this.numPitchSamples - position >= this.maxRequired) {
            int period = this.findPitchPeriod(this.pitchBuffer, position, false);
            int newPeriod = (int)((float)period / this.pitch);
            this.enlargeOutputBufferIfNeeded(newPeriod);
            if (this.pitch >= 1.0f) {
                this.overlapAdd(newPeriod, this.numChannels, this.outputBuffer, this.numOutputSamples, this.pitchBuffer, position, this.pitchBuffer, position + period - newPeriod);
            } else {
                int separation = newPeriod - period;
                this.overlapAddWithSeparation(period, this.numChannels, separation, this.outputBuffer, this.numOutputSamples, this.pitchBuffer, position, this.pitchBuffer, position);
            }
            this.numOutputSamples += newPeriod;
            position += period;
        }
        this.removePitchSamples(position);
    }

    private short interpolate(short[] in, int inPos, int oldSampleRate, int newSampleRate) {
        short left = in[inPos * this.numChannels];
        short right = in[inPos * this.numChannels + this.numChannels];
        int position = this.newRatePosition * oldSampleRate;
        int leftPosition = this.oldRatePosition * newSampleRate;
        int rightPosition = (this.oldRatePosition + 1) * newSampleRate;
        int ratio = rightPosition - position;
        int width = rightPosition - leftPosition;
        return (short)((ratio * left + (width - ratio) * right) / width);
    }

    private void adjustRate(float rate, int originalNumOutputSamples) {
        int position;
        int oldSampleRate;
        int newSampleRate = (int)((float)this.sampleRate / rate);
        for (oldSampleRate = this.sampleRate; newSampleRate > 16384 || oldSampleRate > 16384; newSampleRate >>= 1, oldSampleRate >>= 1) {
        }
        if (this.numOutputSamples == originalNumOutputSamples) {
            return;
        }
        this.moveNewSamplesToPitchBuffer(originalNumOutputSamples);
        for (position = 0; position < this.numPitchSamples - 1; ++position) {
            while ((this.oldRatePosition + 1) * newSampleRate > this.newRatePosition * oldSampleRate) {
                this.enlargeOutputBufferIfNeeded(1);
                for (int i = 0; i < this.numChannels; ++i) {
                    this.outputBuffer[this.numOutputSamples * this.numChannels + i] = this.interpolate(this.pitchBuffer, position + i, oldSampleRate, newSampleRate);
                }
                ++this.newRatePosition;
                ++this.numOutputSamples;
            }
            ++this.oldRatePosition;
            if (this.oldRatePosition != oldSampleRate) continue;
            this.oldRatePosition = 0;
            if (this.newRatePosition != newSampleRate) {
                System.out.printf("Assertion failed: newRatePosition != newSampleRate\n", new Object[0]);
                assert (false);
            }
            this.newRatePosition = 0;
        }
        this.removePitchSamples(position);
    }

    private int skipPitchPeriod(short[] samples, int position, float speed, int period) {
        int newSamples;
        if (speed >= 2.0f) {
            newSamples = (int)((float)period / (speed - 1.0f));
        } else {
            newSamples = period;
            this.remainingInputToCopy = (int)((float)period * (2.0f - speed) / (speed - 1.0f));
        }
        this.enlargeOutputBufferIfNeeded(newSamples);
        this.overlapAdd(newSamples, this.numChannels, this.outputBuffer, this.numOutputSamples, samples, position, samples, position + period);
        this.numOutputSamples += newSamples;
        return newSamples;
    }

    private int insertPitchPeriod(short[] samples, int position, float speed, int period) {
        int newSamples;
        if (speed < 0.5f) {
            newSamples = (int)((float)period * speed / (1.0f - speed));
        } else {
            newSamples = period;
            this.remainingInputToCopy = (int)((float)period * (2.0f * speed - 1.0f) / (1.0f - speed));
        }
        this.enlargeOutputBufferIfNeeded(period + newSamples);
        this.move(this.outputBuffer, this.numOutputSamples, samples, position, period);
        this.overlapAdd(newSamples, this.numChannels, this.outputBuffer, this.numOutputSamples + period, samples, position + period, samples, position);
        this.numOutputSamples += period + newSamples;
        return newSamples;
    }

    private void changeSpeed(float speed) {
        int numSamples = this.numInputSamples;
        int position = 0;
        if (this.numInputSamples < this.maxRequired) {
            return;
        }
        do {
            int newSamples;
            if (this.remainingInputToCopy > 0) {
                newSamples = this.copyInputToOutput(position);
                position += newSamples;
                continue;
            }
            int period = this.findPitchPeriod(this.inputBuffer, position, true);
            if ((double)speed > 1.0) {
                newSamples = this.skipPitchPeriod(this.inputBuffer, position, speed, period);
                position += period + newSamples;
                continue;
            }
            newSamples = this.insertPitchPeriod(this.inputBuffer, position, speed, period);
            position += newSamples;
        } while (position + this.maxRequired <= numSamples);
        this.removeInputSamples(position);
    }

    private void processStreamInput() {
        int originalNumOutputSamples = this.numOutputSamples;
        float s = this.speed / this.pitch;
        float r = this.rate;
        if (!this.useChordPitch) {
            r *= this.pitch;
        }
        if ((double)s > 1.00001 || (double)s < 0.99999) {
            this.changeSpeed(s);
        } else {
            this.copyToOutput(this.inputBuffer, 0, this.numInputSamples);
            this.numInputSamples = 0;
        }
        if (this.useChordPitch) {
            if (this.pitch != 1.0f) {
                this.adjustPitch(originalNumOutputSamples);
            }
        } else if (r != 1.0f) {
            this.adjustRate(r, originalNumOutputSamples);
        }
        if (this.volume != 1.0f) {
            this.scaleSamples(this.outputBuffer, originalNumOutputSamples, this.numOutputSamples - originalNumOutputSamples, this.volume);
        }
    }

    public void writeFloatToStream(float[] samples, int numSamples) {
        this.addFloatSamplesToInputBuffer(samples, numSamples);
        this.processStreamInput();
    }

    public void writeShortToStream(short[] samples, int numSamples) {
        this.addShortSamplesToInputBuffer(samples, numSamples);
        this.processStreamInput();
    }

    public void writeUnsignedByteToStream(byte[] samples, int numSamples) {
        this.addUnsignedByteSamplesToInputBuffer(samples, numSamples);
        this.processStreamInput();
    }

    public void writeBytesToStream(byte[] inBuffer, int numBytes) {
        this.addBytesToInputBuffer(inBuffer, numBytes);
        this.processStreamInput();
    }

    public static int changeFloatSpeed(float[] samples, int numSamples, float speed, float pitch, float rate, float volume, boolean useChordPitch, int sampleRate, int numChannels) {
        Sonic stream = new Sonic(sampleRate, numChannels);
        stream.setSpeed(speed);
        stream.setPitch(pitch);
        stream.setRate(rate);
        stream.setVolume(volume);
        stream.setChordPitch(useChordPitch);
        stream.writeFloatToStream(samples, numSamples);
        stream.flushStream();
        numSamples = stream.samplesAvailable();
        stream.readFloatFromStream(samples, numSamples);
        return numSamples;
    }

    public int sonicChangeShortSpeed(short[] samples, int numSamples, float speed, float pitch, float rate, float volume, boolean useChordPitch, int sampleRate, int numChannels) {
        Sonic stream = new Sonic(sampleRate, numChannels);
        stream.setSpeed(speed);
        stream.setPitch(pitch);
        stream.setRate(rate);
        stream.setVolume(volume);
        stream.setChordPitch(useChordPitch);
        stream.writeShortToStream(samples, numSamples);
        stream.flushStream();
        numSamples = stream.samplesAvailable();
        stream.readShortFromStream(samples, numSamples);
        return numSamples;
    }
}

