/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.storage;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import io.github.elytra.copo.inventory.ContainerTerminal;
import io.github.elytra.copo.storage.IDigitalStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;

public interface ITerminal {
    public UserPreferences getPreferences(EntityPlayer var1);

    public IDigitalStorage getStorage();

    public boolean hasStorage();

    public boolean supportsDumpSlot();

    public IInventory getDumpSlotInventory();

    public boolean canContinueInteracting(EntityPlayer var1);

    public void markUnderlyingStorageDirty();

    public static class UserPreferences {
        public ContainerTerminal.SortMode sortMode = ContainerTerminal.SortMode.QUANTITY;
        public boolean sortAscending = false;
        public String lastSearchQuery = "";
        public ContainerTerminal.CraftingTarget craftingTarget = ContainerTerminal.CraftingTarget.INVENTORY;

        public void writeToNBT(NBTTagCompound data) {
            data.func_74778_a("SortMode", this.sortMode.name());
            data.func_74757_a("SortAscending", this.sortAscending);
            data.func_74778_a("LastSearchQuery", Strings.nullToEmpty((String)this.lastSearchQuery));
            data.func_74778_a("CraftingTarget", this.craftingTarget.name());
        }

        public void readFromNBT(NBTTagCompound data) {
            this.sortMode = (ContainerTerminal.SortMode)((Object)Enums.getIfPresent(ContainerTerminal.SortMode.class, (String)data.func_74779_i("SortMode")).or((Object)ContainerTerminal.SortMode.QUANTITY));
            this.sortAscending = data.func_74767_n("SortAscending");
            this.lastSearchQuery = data.func_74779_i("LastSearchQuery");
            this.craftingTarget = (ContainerTerminal.CraftingTarget)((Object)Enums.getIfPresent(ContainerTerminal.CraftingTarget.class, (String)data.func_74779_i("CraftingTarget")).or((Object)ContainerTerminal.CraftingTarget.INVENTORY));
        }
    }
}

