/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.storage;

import io.github.elytra.copo.CoPoWorldData;
import io.github.elytra.copo.item.ItemWirelessTerminal;
import io.github.elytra.copo.storage.IDigitalStorage;
import io.github.elytra.copo.storage.ITerminal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class WirelessTerminal
implements ITerminal {
    private World world;
    private EntityPlayer player;
    private ItemWirelessTerminal iwt;
    private ItemStack stack;
    private ITerminal.UserPreferences prefs = new ITerminal.UserPreferences();

    public WirelessTerminal(World world, EntityPlayer player, ItemWirelessTerminal iwt, ItemStack stack) {
        this.world = world;
        this.player = player;
        this.iwt = iwt;
        this.stack = stack;
        this.prefs.readFromNBT(stack.func_179543_a("Preferences", true));
    }

    @Override
    public ITerminal.UserPreferences getPreferences(EntityPlayer player) {
        return this.prefs;
    }

    @Override
    public IDigitalStorage getStorage() {
        return this.iwt.getTransmitterController(this.stack, this.world, this.player);
    }

    @Override
    public boolean hasStorage() {
        return this.iwt.getTransmitterController(this.stack, this.world, this.player) != null;
    }

    @Override
    public boolean supportsDumpSlot() {
        return false;
    }

    @Override
    public IInventory getDumpSlotInventory() {
        return null;
    }

    @Override
    public boolean canContinueInteracting(EntityPlayer player) {
        CoPoWorldData.Transmitter t = this.iwt.getTransmitter(this.stack, this.world, player, false);
        return t.position.func_177954_c(player.field_70165_t, player.field_70163_u, player.field_70161_v) <= t.range * t.range;
    }

    @Override
    public void markUnderlyingStorageDirty() {
        this.prefs.writeToNBT(this.stack.func_179543_a("Preferences", true));
    }
}

