/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.tile;

import cofh.api.energy.IEnergyReceiver;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import gnu.trove.set.hash.TCustomHashSet;
import gnu.trove.strategy.HashingStrategy;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.block.BlockController;
import io.github.elytra.copo.helper.DriveComparator;
import io.github.elytra.copo.item.ItemDrive;
import io.github.elytra.copo.item.ItemMemory;
import io.github.elytra.copo.storage.IDigitalStorage;
import io.github.elytra.copo.tile.TileEntityDriveBay;
import io.github.elytra.copo.tile.TileEntityInterface;
import io.github.elytra.copo.tile.TileEntityMemoryBay;
import io.github.elytra.copo.tile.TileEntityNetworkMember;
import io.github.elytra.copo.tile.TileEntityWirelessReceiver;
import io.github.elytra.copo.tile.TileEntityWirelessTransmitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="cofh.api.energy.IEnergyReceiver", modid="CoFHAPI|energy")
public class TileEntityController
extends TileEntityNetworkMember
implements IEnergyReceiver,
ITickable,
IDigitalStorage,
IEnergyStorage {
    public static final long POWER_CAP = 640L;
    public static final long ENERGY_CAPACITY = 64000L;
    public boolean error = false;
    public boolean booting = true;
    public String errorReason;
    private long consumedPerTick = 32L;
    public int bootTicks = 0;
    private int networkMembers = 0;
    private transient Set<BlockPos> networkMemberLocations = Sets.newHashSet();
    private transient List<TileEntityInterface> interfaces = Lists.newArrayList();
    private transient List<TileEntityWirelessReceiver> receivers = Lists.newArrayList();
    private transient List<TileEntityDriveBay> driveBays = Lists.newArrayList();
    private transient List<TileEntityMemoryBay> memoryBays = Lists.newArrayList();
    private transient List<ItemStack> drives = Lists.newArrayList();
    private transient Set<ItemStack> prototypes;
    private transient Multiset<Class<? extends TileEntityNetworkMember>> memberTypes = HashMultiset.create((int)7);
    public int changeId = 0;
    private boolean checkingInfiniteLoop = false;
    private long maxMemory = 0L;
    private long energy;
    private Object teslaConsumer;

    public TileEntityController() {
        this.prototypes = new TCustomHashSet((HashingStrategy)new HashingStrategy<ItemStack>(){
            private static final long serialVersionUID = 7782704091709458883L;

            public int computeHashCode(ItemStack is) {
                if (is == null) {
                    return 0;
                }
                int res = 1;
                res = is.func_77942_o() ? 31 * res + is.func_77978_p().hashCode() : (res *= 31);
                res = 31 * res + is.func_77973_b().hashCode();
                res = 31 * res + is.func_77960_j();
                return res;
            }

            public boolean equals(ItemStack o1, ItemStack o2) {
                if (o1 == o2) {
                    return true;
                }
                if (o1 == null || o2 == null) {
                    return false;
                }
                if (o1.func_77942_o() != o2.func_77942_o()) {
                    return false;
                }
                if (o1.func_77973_b() != o2.func_77973_b()) {
                    return false;
                }
                if (o1.func_77960_j() != o2.func_77960_j()) {
                    return false;
                }
                if (!Objects.equal((Object)o1.func_77978_p(), (Object)o2.func_77978_p())) {
                    return false;
                }
                return o1.areCapsCompatible(o2);
            }
        });
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.energy = compound.func_74763_f("Energy");
        if (this.energy > 64000L) {
            this.energy = 64000L;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74772_a("Energy", this.energy);
        return compound;
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public void func_73660_a() {
        if (!this.func_145830_o() || this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.bootTicks > 100 && this.booting) {
            this.booting = false;
            this.scanNetwork();
        }
        if (this.isPowered()) {
            this.modifyEnergyStored(-this.getEnergyConsumedPerTick());
            ++this.bootTicks;
        } else {
            this.energy = 0L;
        }
        if (this.getTotalUsedMemory() > this.maxMemory) {
            this.error = true;
            this.errorReason = "out_of_memory";
        } else if ("out_of_memory".equals(this.errorReason)) {
            this.error = false;
            this.errorReason = null;
            this.bootTicks = 0;
            this.booting = true;
        }
        this.updateState();
    }

    @Override
    public long getEnergyConsumedPerTick() {
        return this.consumedPerTick;
    }

    @Override
    public boolean hasStorage() {
        return true;
    }

    @Override
    public TileEntityController getStorage() {
        return this;
    }

    @Override
    public void setController(TileEntityController controller) {
    }

    public void scanNetwork() {
        TileEntity te2;
        if (!this.func_145830_o()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.booting) {
            return;
        }
        HashSet seen = Sets.newHashSet();
        ArrayList members = Lists.newArrayList();
        ArrayList queue = Lists.newArrayList((Object[])new BlockPos[]{this.func_174877_v()});
        boolean foundOtherController = false;
        this.consumedPerTick = CoPo.inst.controllerRfUsage;
        for (BlockPos pos : this.networkMemberLocations) {
            te2 = this.field_145850_b.func_175625_s(pos);
            if (!(te2 instanceof TileEntityNetworkMember)) continue;
            ((TileEntityNetworkMember)te2).setController(null);
        }
        this.networkMembers = 0;
        this.networkMemberLocations.clear();
        this.driveBays.clear();
        this.memoryBays.clear();
        this.receivers.clear();
        this.interfaces.clear();
        this.prototypes.clear();
        int itr = 0;
        while (!queue.isEmpty()) {
            BlockPos pos;
            if (itr > 100) {
                this.error = true;
                this.errorReason = "network_too_big";
                this.consumedPerTick = 640L;
                return;
            }
            pos = (BlockPos)queue.remove(0);
            seen.add(pos);
            te2 = this.func_145831_w().func_175625_s(pos);
            if (te2 instanceof TileEntityNetworkMember) {
                for (EnumFacing ef : EnumFacing.field_82609_l) {
                    BlockPos p = pos.func_177972_a(ef);
                    if (seen.contains(p)) continue;
                    if (this.field_145850_b.func_175625_s(p) == null) {
                        seen.add(p);
                        continue;
                    }
                    queue.add(p);
                }
                if (te2 != this) {
                    if (te2 instanceof TileEntityController) {
                        this.error = true;
                        ((TileEntityController)te2).error = true;
                        CoPo.log.debug("Found other controller");
                        foundOtherController = true;
                    }
                    if (!members.contains(te2)) {
                        members.add((TileEntityNetworkMember)te2);
                        if (te2 instanceof TileEntityDriveBay) {
                            this.driveBays.add((TileEntityDriveBay)te2);
                        } else if (te2 instanceof TileEntityInterface) {
                            this.interfaces.add((TileEntityInterface)te2);
                        } else if (te2 instanceof TileEntityWirelessReceiver) {
                            this.receivers.add((TileEntityWirelessReceiver)te2);
                        } else if (te2 instanceof TileEntityMemoryBay) {
                            this.memoryBays.add((TileEntityMemoryBay)te2);
                        }
                        TileEntityNetworkMember tenm = (TileEntityNetworkMember)te2;
                        this.networkMemberLocations.add(pos);
                        this.memberTypes.add(((Object)((Object)tenm)).getClass());
                        this.consumedPerTick += tenm.getEnergyConsumedPerTick();
                    }
                }
            }
            ++itr;
        }
        if (foundOtherController) {
            this.error = true;
            this.errorReason = "multiple_controllers";
            this.consumedPerTick = 4L;
        } else {
            this.error = false;
            this.errorReason = null;
        }
        this.checkInfiniteLoop();
        for (TileEntity te2 : members) {
            te2.setController(this);
        }
        this.networkMembers = itr;
        if (this.consumedPerTick > 640L) {
            this.error = true;
            this.errorReason = "too_much_power";
        }
        this.updateDrivesCache();
        this.updateMemoryCache();
        this.booting = false;
        CoPo.log.debug("Found " + members.size() + " network members");
    }

    public void checkInfiniteLoop() {
        this.checkingInfiniteLoop = true;
        for (TileEntityWirelessReceiver r : this.receivers) {
            TileEntityController cont = r.getTransmitterController();
            if (cont == null || !cont.isLinkedTo(this, 0)) continue;
            this.error = true;
            this.errorReason = "infinite_loop";
            this.receivers.clear();
            this.checkingInfiniteLoop = false;
            return;
        }
        if (this.error && "infinite_loop".equals(this.errorReason)) {
            this.error = false;
            this.errorReason = null;
        }
        this.checkingInfiniteLoop = false;
    }

    public boolean isCheckingInfiniteLoop() {
        return this.checkingInfiniteLoop;
    }

    public boolean isLinkedTo(TileEntityController tec, int depth) {
        if (depth > 50) {
            return true;
        }
        if (tec.equals(this)) {
            return true;
        }
        for (TileEntityWirelessReceiver r : this.receivers) {
            TileEntityController cont = r.getTransmitterController();
            if (cont == null || !cont.isLinkedTo(tec, depth + 1)) continue;
            return true;
        }
        return false;
    }

    private void updateState() {
        BlockController.State nw;
        if (!this.func_145830_o()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockController.State old = (BlockController.State)((Object)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(BlockController.state));
        if (this.isPowered()) {
            if (old == BlockController.State.OFF) {
                this.booting = true;
                this.bootTicks = -200;
            }
            nw = this.booting ? BlockController.State.BOOTING : (this.error ? BlockController.State.ERROR : BlockController.State.POWERED);
        } else {
            nw = BlockController.State.OFF;
        }
        if (old != nw) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177226_a(BlockController.state, (Comparable)((Object)nw)));
        }
    }

    @Override
    public boolean isPowered() {
        return this.energy >= this.getEnergyConsumedPerTick();
    }

    public void updateDrivesCache() {
        if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
            return;
        }
        this.drives.clear();
        this.prototypes.clear();
        for (TileEntityDriveBay tedb : this.driveBays) {
            if (tedb.func_145837_r()) continue;
            for (ItemStack is : tedb) {
                this.drives.add(is);
                ItemDrive id = (ItemDrive)is.func_77973_b();
                this.prototypes.addAll(id.getPrototypes(is));
            }
        }
        Collections.sort(this.drives, new DriveComparator());
    }

    public void updateMemoryCache() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        this.maxMemory = 0L;
        for (TileEntityMemoryBay temb : this.memoryBays) {
            if (temb.func_145837_r()) continue;
            for (int i = 0; i < 12; ++i) {
                ItemStack stack;
                if (!temb.hasMemoryInSlot(i) || !((stack = temb.getMemoryInSlot(i)).func_77973_b() instanceof ItemMemory)) continue;
                this.maxMemory += (long)((ItemMemory)stack.func_77973_b()).getMaxBits(stack);
            }
        }
        this.bootTicks = 0;
        this.booting = true;
    }

    public void updateConsumptionRate(long change) {
        this.consumedPerTick += change;
        if (this.consumedPerTick > 640L) {
            this.error = true;
            this.errorReason = "too_much_power";
        } else if (this.error && "too_much_power".equals(this.errorReason)) {
            this.error = false;
            this.errorReason = null;
        }
    }

    @Override
    public ItemStack addItemToNetwork(ItemStack stack) {
        if (this.error) {
            return stack;
        }
        if (stack == null) {
            return null;
        }
        if (!this.prototypes.contains(stack) && this.getTotalUsedMemory() + this.getMemoryUsage(stack) > this.getMaxMemory()) {
            return stack;
        }
        for (ItemStack drive : this.drives) {
            if (drive == null || !(drive.func_77973_b() instanceof ItemDrive)) continue;
            int oldSize = stack.field_77994_a;
            ItemDrive itemDrive = (ItemDrive)drive.func_77973_b();
            itemDrive.addItem(drive, stack);
            if (stack.field_77994_a < oldSize && !this.prototypes.contains(stack)) {
                this.prototypes.add(stack.func_77946_l());
            }
            if (stack.field_77994_a > 0) continue;
            break;
        }
        for (TileEntityWirelessReceiver r : this.receivers) {
            TileEntityController cont = r.getTransmitterController();
            if (cont != null) {
                cont.addItemToNetwork(stack);
            }
            if (stack.field_77994_a > 0) continue;
            break;
        }
        ++this.changeId;
        return stack.field_77994_a <= 0 ? null : stack;
    }

    @Override
    public ItemStack removeItemsFromNetwork(ItemStack prototype, int amount, boolean checkInterfaces) {
        int amountWanted;
        if (this.error) {
            return null;
        }
        if (prototype == null) {
            return null;
        }
        ItemStack stack = prototype.func_77946_l();
        stack.field_77994_a = 0;
        if (checkInterfaces) {
            block0: for (TileEntityInterface in : this.interfaces) {
                for (int i = 9; i <= 17; ++i) {
                    ItemStack is = in.func_70301_a(i);
                    if (is == null || !ItemStack.func_179545_c((ItemStack)is, (ItemStack)prototype) || !ItemStack.func_77970_a((ItemStack)is, (ItemStack)prototype)) continue;
                    amountWanted = amount - stack.field_77994_a;
                    int amountTaken = Math.min(is.field_77994_a, amountWanted);
                    is.field_77994_a -= amountTaken;
                    stack.field_77994_a += amountTaken;
                    if (is.field_77994_a <= 0) {
                        in.func_70299_a(i, null);
                    }
                    if (stack.field_77994_a >= amount) continue block0;
                }
            }
        }
        boolean anyDriveStillHasItem = false;
        for (ItemStack drive : this.drives) {
            if (drive == null || !(drive.func_77973_b() instanceof ItemDrive)) continue;
            ItemDrive itemDrive = (ItemDrive)drive.func_77973_b();
            amountWanted = amount - stack.field_77994_a;
            itemDrive.removeItems(drive, stack, amountWanted);
            if (!anyDriveStillHasItem && itemDrive.getAmountStored(drive, stack) > 0) {
                anyDriveStillHasItem = true;
            }
            if (stack.field_77994_a < amount) continue;
            break;
        }
        for (TileEntityWirelessReceiver r : this.receivers) {
            ItemStack remote;
            TileEntityController cont = r.getTransmitterController();
            if (cont != null && (remote = cont.removeItemsFromNetwork(prototype, amount - stack.field_77994_a, checkInterfaces)) != null) {
                stack.field_77994_a += remote.field_77994_a;
            }
            if (stack.field_77994_a < amount) continue;
            break;
        }
        if (!anyDriveStillHasItem) {
            this.prototypes.remove(prototype);
        }
        ++this.changeId;
        return stack.field_77994_a <= 0 ? null : stack;
    }

    @Override
    public int getKilobitsStorageFree() {
        int accum = 0;
        for (ItemStack drive : this.drives) {
            if (drive == null || !(drive.func_77973_b() instanceof ItemDrive)) continue;
            accum += ((ItemDrive)drive.func_77973_b()).getKilobitsFree(drive);
        }
        return accum;
    }

    private long getMemoryUsage(ItemStack is) {
        return 8L + (long)ItemDrive.getNBTComplexity((NBTBase)is.func_77978_p());
    }

    public long getUsedTypeMemory() {
        long count = 0L;
        for (ItemStack is : this.prototypes) {
            count += this.getMemoryUsage(is);
        }
        return count;
    }

    public long getUsedNetworkMemory() {
        return (long)this.networkMembers * 6L;
    }

    public long getUsedWirelessMemory() {
        return (long)this.memberTypes.count(TileEntityWirelessReceiver.class) * 16L + (long)this.memberTypes.count(TileEntityWirelessTransmitter.class) * 32L;
    }

    public long getTotalUsedMemory() {
        return this.getUsedTypeMemory() + this.getUsedNetworkMemory() + this.getUsedWirelessMemory();
    }

    public long getBitsMemoryFree() {
        return this.getMaxMemory() - this.getTotalUsedMemory();
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    @Override
    public List<ItemStack> getTypes() {
        ArrayList li = Lists.newArrayList();
        for (ItemStack drive : this.drives) {
            if (drive == null || !(drive.func_77973_b() instanceof ItemDrive)) continue;
            li.addAll(((ItemDrive)drive.func_77973_b()).getTypes(drive));
        }
        for (TileEntityInterface in : this.interfaces) {
            for (int i = 9; i <= 17; ++i) {
                ItemStack ifaceStack = in.func_70301_a(i);
                if (ifaceStack == null) continue;
                boolean added = false;
                for (ItemStack cur : li) {
                    if (!ItemStack.func_179545_c((ItemStack)ifaceStack, (ItemStack)cur) || !ItemStack.func_77970_a((ItemStack)ifaceStack, (ItemStack)cur)) continue;
                    cur.field_77994_a += ifaceStack.field_77994_a;
                    added = true;
                    break;
                }
                if (added) continue;
                li.add(ifaceStack.func_77946_l());
            }
        }
        for (TileEntityWirelessReceiver r : this.receivers) {
            TileEntityController cont = r.getTransmitterController();
            if (cont == null) continue;
            li.addAll(cont.getTypes());
        }
        return li;
    }

    public void onNetworkPatched(TileEntityNetworkMember tenm) {
        if (this.networkMembers == 0) {
            return;
        }
        if (tenm instanceof TileEntityDriveBay) {
            if (!this.driveBays.contains((Object)tenm)) {
                this.driveBays.add((TileEntityDriveBay)tenm);
                this.updateDrivesCache();
                ++this.changeId;
            }
        } else if (tenm instanceof TileEntityInterface) {
            if (!this.interfaces.contains((Object)tenm)) {
                this.interfaces.add((TileEntityInterface)tenm);
                ++this.changeId;
            }
        } else if (tenm instanceof TileEntityWirelessReceiver) {
            if (!this.receivers.contains((Object)tenm)) {
                this.receivers.add((TileEntityWirelessReceiver)tenm);
                this.checkInfiniteLoop();
                ++this.changeId;
            }
        } else if (tenm instanceof TileEntityMemoryBay && !this.memoryBays.contains((Object)tenm)) {
            this.memoryBays.add((TileEntityMemoryBay)tenm);
            this.updateMemoryCache();
            ++this.changeId;
        }
        if (this.networkMemberLocations.add(tenm.func_174877_v())) {
            ++this.networkMembers;
            if (this.networkMembers > 100) {
                this.error = true;
                this.errorReason = "network_too_big";
                this.consumedPerTick = 640L;
            }
        }
    }

    public boolean knowsOfMemberAt(BlockPos pos) {
        return this.networkMemberLocations.contains(pos);
    }

    @Override
    public int getChangeId() {
        return this.changeId;
    }

    public void modifyEnergyStored(long energy) {
        this.energy += energy;
        if (this.energy > 64000L) {
            this.energy = 64000L;
        } else if (this.energy < 0L) {
            this.energy = 0L;
        }
    }

    public long receiveEnergy(long maxReceive, boolean simulate) {
        long energyReceived = Math.min(64000L - this.energy, Math.min(641L, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int getEnergyStored(EnumFacing from) {
        return Ints.saturatedCast((long)this.energy);
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return Ints.saturatedCast((long)64000L);
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return Ints.saturatedCast((long)this.receiveEnergy(maxReceive, simulate));
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return Ints.saturatedCast((long)this.receiveEnergy((long)maxReceive, simulate));
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return Ints.saturatedCast((long)this.energy);
    }

    public int getMaxEnergyStored() {
        return Ints.saturatedCast((long)64000L);
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == null) {
            return null;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        if (capability == CoPo.TESLA_CONSUMER) {
            if (this.teslaConsumer == null) {
                this.teslaConsumer = new TeslaConsumer();
            }
            return (T)this.teslaConsumer;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == null) {
            return false;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        if (capability == CoPo.TESLA_CONSUMER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public class TeslaConsumer
    implements ITeslaConsumer {
        public long givePower(long power, boolean simulated) {
            return TileEntityController.this.receiveEnergy(power, simulated);
        }
    }
}

