/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.tile;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.block.BlockDriveBay;
import io.github.elytra.copo.helper.ItemStacks;
import io.github.elytra.copo.item.ItemDrive;
import io.github.elytra.copo.tile.TileEntityDriveBay$$Lambda$1;
import io.github.elytra.copo.tile.TileEntityNetworkMember;
import java.util.Iterator;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import scala.actors.threadpool.Arrays;

public class TileEntityDriveBay
extends TileEntityNetworkMember
implements ITickable,
Iterable<ItemStack> {
    private ItemStack[] drives = new ItemStack[8];
    private long consumedPerTick;

    public TileEntityDriveBay() {
        this.consumedPerTick = CoPo.inst.driveBayRfUsage;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        for (int i = 0; i < this.drives.length; ++i) {
            NBTTagCompound drive = new NBTTagCompound();
            if (this.drives[i] != null) {
                this.drives[i].func_77955_b(drive);
            }
            compound.func_74782_a("Drive" + i, (NBTBase)drive);
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (int i = 0; i < this.drives.length; ++i) {
            if (!compound.func_74764_b("Drive" + i)) continue;
            NBTTagCompound drive = compound.func_74775_l("Drive" + i);
            if (drive.func_82582_d()) {
                this.drives[i] = null;
                continue;
            }
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)drive);
            if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
                ItemStacks.ensureHasTag(is);
                is.func_77982_d(is.func_77978_p().func_74737_b());
                is.func_77978_p().func_74757_a("Dirty", true);
            }
            this.drives[i] = is;
        }
        this.onDriveChange();
    }

    @Override
    public long getEnergyConsumedPerTick() {
        return this.consumedPerTick;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", this.func_174877_v().func_177958_n());
        nbt.func_74768_a("y", this.func_174877_v().func_177956_o());
        nbt.func_74768_a("z", this.func_174877_v().func_177952_p());
        for (int i = 0; i < this.drives.length; ++i) {
            ItemStack drive = this.drives[i];
            if (drive == null || !(drive.func_77973_b() instanceof ItemDrive)) continue;
            ItemDrive id = (ItemDrive)drive.func_77973_b();
            ItemStack prototype = drive.func_77946_l();
            ItemStacks.ensureHasTag(prototype).func_77978_p().func_74768_a("UsedBits", id.getKilobitsUsed(drive));
            ItemStacks.ensureHasTag(prototype).func_77978_p().func_82580_o("Data");
            nbt.func_74782_a("Drive" + i, (NBTBase)prototype.serializeNBT());
        }
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt.func_148857_g().func_74767_n("UpdateUsedBits")) {
            int slot = pkt.func_148857_g().func_74762_e("Slot");
            ItemStack stack = this.drives[slot];
            if (stack != null) {
                ItemStacks.ensureHasTag(stack).func_77978_p().func_74757_a("Dirty", true);
                ItemStacks.ensureHasTag(stack).func_77978_p().func_74768_a("UsedBits", pkt.func_148857_g().func_74762_e("UsedBits"));
            }
        } else {
            for (int i = 0; i < this.drives.length; ++i) {
                if (!pkt.func_148857_g().func_74764_b("Drive" + i)) continue;
                NBTTagCompound tag = pkt.func_148857_g().func_74775_l("Drive" + i);
                this.drives[i] = tag.func_82582_d() ? null : ItemStack.func_77949_a((NBTTagCompound)tag);
            }
        }
    }

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            boolean lit;
            for (int i = 0; i < 8; ++i) {
                ItemStack is = this.drives[i];
                if (is == null || !((Boolean)ItemStacks.getBoolean(is, "Dirty").or((Object)false)).booleanValue()) continue;
                is.func_77978_p().func_82580_o("Dirty");
                this.func_70296_d();
                this.blinkDriveInSlot(i);
            }
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (state.func_177230_c() == CoPo.drive_bay && (lit = this.hasStorage() && this.getStorage().isPowered()) != (Boolean)state.func_177229_b((IProperty)BlockDriveBay.LIT)) {
                this.func_145831_w().func_175656_a(this.func_174877_v(), state.func_177226_a((IProperty)BlockDriveBay.LIT, (Comparable)Boolean.valueOf(lit)));
            }
        }
    }

    public void blinkDriveInSlot(int slot) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("UpdateUsedBits", true);
        ItemStack drive = this.drives[slot];
        if (drive == null || !(drive.func_77973_b() instanceof ItemDrive)) {
            return;
        }
        ItemDrive id = (ItemDrive)drive.func_77973_b();
        nbt.func_74768_a("Slot", slot);
        nbt.func_74768_a("UsedBits", id.getKilobitsUsed(drive));
        this.sendUpdatePacket(nbt);
    }

    public void setDriveInSlot(int slot, ItemStack drive) {
        this.drives[slot] = drive;
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.field_145850_b instanceof WorldServer) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (drive != null && drive.func_77973_b() instanceof ItemDrive) {
                ItemStack prototype = drive.func_77946_l();
                ItemStacks.ensureHasTag(prototype).func_77978_p().func_74768_a("UsedBits", ((ItemDrive)drive.func_77973_b()).getKilobitsUsed(drive));
                ItemStacks.ensureHasTag(prototype).func_77978_p().func_82580_o("Data");
                nbt.func_74782_a("Drive" + slot, (NBTBase)prototype.serializeNBT());
            } else {
                nbt.func_74782_a("Drive" + slot, (NBTBase)new NBTTagCompound());
            }
            this.sendUpdatePacket(nbt);
            this.onDriveChange();
        }
    }

    private void sendUpdatePacket(NBTTagCompound nbt) {
        WorldServer ws = (WorldServer)this.field_145850_b;
        Chunk c = this.field_145850_b.func_175726_f(this.func_174877_v());
        SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), nbt);
        for (EntityPlayerMP player : this.field_145850_b.func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue())) {
            if (!ws.func_184164_w().func_72694_a(player, c.field_76635_g, c.field_76647_h)) continue;
            player.field_71135_a.func_147359_a((Packet)packet);
        }
    }

    private void onDriveChange() {
        long old = this.consumedPerTick;
        this.consumedPerTick = CoPo.inst.driveBayRfUsage;
        for (ItemStack is : this.drives) {
            if (is == null || !(is.func_77973_b() instanceof ItemDrive)) continue;
            this.consumedPerTick += (long)((ItemDrive)is.func_77973_b()).getRFConsumptionRate(is);
        }
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.hasStorage()) {
            this.getStorage().updateConsumptionRate(this.consumedPerTick - old);
            this.getStorage().updateDrivesCache();
        }
    }

    public ItemStack getDriveInSlot(int slot) {
        return this.drives[slot];
    }

    public boolean hasDriveInSlot(int slot) {
        return this.drives[slot] != null;
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return Iterators.filter((Iterator)Iterators.forArray((Object[])this.drives), (Predicate)TileEntityDriveBay$$Lambda$1.lambdaFactory$());
    }

    public void clear() {
        Arrays.fill((Object[])this.drives, null);
        NBTTagCompound nbt = new NBTTagCompound();
        for (int i = 0; i < this.drives.length; ++i) {
            nbt.func_74782_a("Drive" + i, (NBTBase)new NBTTagCompound());
        }
        this.sendUpdatePacket(nbt);
        this.onDriveChange();
    }

    private static /* synthetic */ boolean lambda$iterator$0(ItemStack is) {
        return is != null && is.func_77973_b() instanceof ItemDrive;
    }

    static /* synthetic */ boolean access$lambda$0(ItemStack itemStack) {
        return TileEntityDriveBay.lambda$iterator$0(itemStack);
    }
}

