/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.tile;

import com.google.common.collect.Lists;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.inventory.ContainerTerminal;
import io.github.elytra.copo.storage.IDigitalStorage;
import io.github.elytra.copo.storage.ITerminal;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityImporterChest
extends TileEntity
implements IInventory,
ISidedInventory,
IDigitalStorage,
ITickable,
ITerminal {
    private List<ItemStack> storage = Lists.newArrayList();
    private int changeId;
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    private int ticksSinceSync;

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public String func_70005_c_() {
        return "importer_chest";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.storage.size();
    }

    public ItemStack func_70301_a(int index) {
        return this.storage.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack is = this.storage.get(index);
        ItemStack split = is.func_77979_a(count);
        if (is.field_77994_a <= 0) {
            this.storage.remove(index);
        }
        ++this.changeId;
        return split;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack is = this.storage.remove(index);
        ++this.changeId;
        return is;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index == this.storage.size()) {
            this.storage.add(stack);
        } else {
            this.storage.set(index, stack);
        }
        ++this.changeId;
    }

    public int func_70297_j_() {
        return Integer.MAX_VALUE;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.storage.clear();
    }

    @Override
    public int getChangeId() {
        return this.changeId;
    }

    @Override
    public List<ItemStack> getTypes() {
        return this.storage;
    }

    @Override
    public ItemStack addItemToNetwork(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (ItemStack is : this.storage) {
            if (!this.areCompatible(is, stack)) continue;
            is.field_77994_a += stack.field_77994_a;
            stack.field_77994_a = 0;
            return null;
        }
        this.storage.add(stack.func_77946_l());
        ++this.changeId;
        return null;
    }

    @Override
    public ItemStack removeItemsFromNetwork(ItemStack prototype, int amount, boolean checkInterfaces) {
        if (prototype == null) {
            return null;
        }
        ItemStack res = prototype.func_77946_l();
        res.field_77994_a = 0;
        Iterator<ItemStack> iter = this.storage.iterator();
        while (iter.hasNext()) {
            ItemStack is = iter.next();
            if (!this.areCompatible(is, res)) continue;
            int toTake = Math.min(amount, is.field_77994_a);
            amount -= toTake;
            res.field_77994_a += toTake;
            is.field_77994_a -= toTake;
            if (is.field_77994_a <= 0) {
                iter.remove();
            }
            if (amount > 0) continue;
            break;
        }
        ++this.changeId;
        return res.field_77994_a <= 0 ? null : res;
    }

    @Override
    public boolean isPowered() {
        return true;
    }

    @Override
    public int getKilobitsStorageFree() {
        return 0;
    }

    private boolean areCompatible(ItemStack a, ItemStack b) {
        return a != null && a.func_77973_b() == b.func_77973_b() && (!a.func_77981_g() || a.func_77960_j() == b.func_77960_j()) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b) && a.areCapsCompatible(b) && a.func_77985_e();
    }

    public void func_73660_a() {
        if (++this.ticksSinceSync % 20 * 4 == 0) {
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)CoPo.importer_chest, 1, this.numPlayersUsing);
        }
        this.prevLidAngle = this.lidAngle;
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double d0 = (double)i + 0.5;
            double d1 = (double)k + 0.5;
            this.field_145850_b.func_184148_a((EntityPlayer)null, d0, (double)j + 0.5, d1, SoundEvents.field_187520_aJ, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && f2 >= 0.5f) {
                double d3 = (double)i + 0.5;
                double d2 = (double)k + 0.5;
                this.field_145850_b.func_184148_a((EntityPlayer)null, d3, (double)j + 0.5, d2, SoundEvents.field_187519_aI, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_145843_s() {
        this.func_145836_u();
        super.func_145843_s();
    }

    public void openChest() {
        ++this.numPlayersUsing;
        this.field_145850_b.func_175641_c(this.func_174877_v(), (Block)CoPo.importer_chest, 1, this.numPlayersUsing);
    }

    public void closeChest() {
        --this.numPlayersUsing;
        this.field_145850_b.func_175641_c(this.func_174877_v(), (Block)CoPo.importer_chest, 1, this.numPlayersUsing);
    }

    @Override
    public ITerminal.UserPreferences getPreferences(EntityPlayer player) {
        ITerminal.UserPreferences prefs = new ITerminal.UserPreferences();
        prefs.sortMode = ContainerTerminal.SortMode.NAME;
        prefs.sortAscending = true;
        return prefs;
    }

    @Override
    public IDigitalStorage getStorage() {
        return this;
    }

    @Override
    public boolean hasStorage() {
        return true;
    }

    @Override
    public boolean supportsDumpSlot() {
        return false;
    }

    @Override
    public IInventory getDumpSlotInventory() {
        return null;
    }

    @Override
    public boolean canContinueInteracting(EntityPlayer player) {
        return true;
    }

    @Override
    public void markUnderlyingStorageDirty() {
        this.func_70296_d();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

