/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.tile;

import com.google.common.base.Predicates;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.block.BlockMemoryBay;
import io.github.elytra.copo.helper.ItemStacks;
import io.github.elytra.copo.tile.TileEntityNetworkMember;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class TileEntityMemoryBay
extends TileEntityNetworkMember
implements ITickable {
    private ItemStack[] memory = new ItemStack[12];

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        for (int i = 0; i < this.memory.length; ++i) {
            NBTTagCompound drive = new NBTTagCompound();
            if (this.memory[i] != null) {
                this.memory[i].func_77955_b(drive);
            }
            compound.func_74782_a("Memory" + i, (NBTBase)drive);
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (int i = 0; i < this.memory.length; ++i) {
            if (!compound.func_74764_b("Memory" + i)) continue;
            NBTTagCompound drive = compound.func_74775_l("Memory" + i);
            if (drive.func_82582_d()) {
                this.memory[i] = null;
                continue;
            }
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)drive);
            if (this.func_145830_o() && this.field_145850_b.field_72995_K) {
                ItemStacks.ensureHasTag(is);
                is.func_77982_d(is.func_77978_p().func_74737_b());
                is.func_77978_p().func_74757_a("Dirty", true);
            }
            this.memory[i] = is;
        }
        this.onMemoryChange();
    }

    @Override
    public long getEnergyConsumedPerTick() {
        return CoPo.inst.memoryBayRfUsage;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", this.func_174877_v().func_177958_n());
        nbt.func_74768_a("y", this.func_174877_v().func_177956_o());
        nbt.func_74768_a("z", this.func_174877_v().func_177952_p());
        for (int i = 0; i < this.memory.length; ++i) {
            ItemStack stack = this.memory[i];
            if (stack == null) continue;
            nbt.func_74782_a("Memory" + i, (NBTBase)stack.serializeNBT());
        }
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        for (int i = 0; i < this.memory.length; ++i) {
            if (!pkt.func_148857_g().func_74764_b("Memory" + i)) continue;
            NBTTagCompound tag = pkt.func_148857_g().func_74775_l("Memory" + i);
            this.memory[i] = tag.func_82582_d() ? null : ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            boolean lit;
            for (int i = 0; i < 12; ++i) {
                ItemStack is = this.memory[i];
                if (is != null) continue;
            }
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (state.func_177230_c() == CoPo.memory_bay && (lit = this.hasStorage() && this.getStorage().isPowered()) != (Boolean)state.func_177229_b((IProperty)BlockMemoryBay.lit)) {
                this.func_145831_w().func_175656_a(this.func_174877_v(), state.func_177226_a((IProperty)BlockMemoryBay.lit, (Comparable)Boolean.valueOf(lit)));
            }
        }
    }

    public void setMemoryInSlot(int slot, ItemStack mem) {
        this.memory[slot] = mem;
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.field_145850_b instanceof WorldServer) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (mem != null) {
                nbt.func_74782_a("Memory" + slot, (NBTBase)mem.serializeNBT());
            } else {
                nbt.func_74782_a("Memory" + slot, (NBTBase)new NBTTagCompound());
            }
            this.sendUpdatePacket(nbt);
            this.onMemoryChange();
        }
    }

    private void sendUpdatePacket(NBTTagCompound nbt) {
        WorldServer ws = (WorldServer)this.field_145850_b;
        Chunk c = this.field_145850_b.func_175726_f(this.func_174877_v());
        SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), nbt);
        for (EntityPlayerMP player : this.field_145850_b.func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue())) {
            if (!ws.func_184164_w().func_72694_a(player, c.field_76635_g, c.field_76647_h)) continue;
            player.field_71135_a.func_147359_a((Packet)packet);
        }
    }

    private void onMemoryChange() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K && this.hasStorage()) {
            this.getStorage().updateMemoryCache();
        }
    }

    public ItemStack getMemoryInSlot(int slot) {
        return this.memory[slot];
    }

    public boolean hasMemoryInSlot(int slot) {
        return this.memory[slot] != null;
    }
}

