/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.tile;

import com.google.common.collect.EnumMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.block.BlockDriveBay;
import io.github.elytra.copo.block.BlockImporterChest;
import io.github.elytra.copo.block.BlockTerminal;
import io.github.elytra.copo.tile.TileEntityController;
import io.github.elytra.copo.tile.TileEntityDriveBay;
import io.github.elytra.copo.tile.TileEntityImporter;
import io.github.elytra.copo.tile.TileEntityImporterChest;
import io.github.elytra.copo.tile.TileEntityInterface;
import io.github.elytra.copo.tile.TileEntityMemoryBay;
import io.github.elytra.copo.tile.TileEntityNetworkMember;
import io.github.elytra.copo.tile.TileEntityTerminal;
import io.github.elytra.copo.tile.TileEntityWirelessReceiver;
import io.github.elytra.copo.tile.TileEntityWirelessTransmitter;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileEntityNetworkImporter
extends TileEntityImporter {
    public TileEntityNetworkImporter() {
        super(2);
    }

    @Override
    protected void doImport() {
        boolean justDelete;
        if (!CoPo.inst.importNetworks) {
            CoPo.log.warn("Skipping import of old network at {}, {}, {}, this may cause glitches!", new Object[]{this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()});
            this.substitute(new TileEntityController(), true);
            return;
        }
        boolean bl = justDelete = !CoPo.inst.refundBlocks && !CoPo.inst.refundContent && !CoPo.inst.refundDriveComponents;
        if (justDelete) {
            CoPo.log.info("DELETING OLD NETWORK AT {}, {}, {}, as requested in config!", new Object[]{this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()});
        } else {
            CoPo.log.info("Scanning old network at {}, {}, {}...", new Object[]{this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()});
        }
        HashSet seen = Sets.newHashSet();
        ArrayList queue = Lists.newArrayList((Object[])new BlockPos[]{this.func_174877_v()});
        HashSet delete = Sets.newHashSet();
        ArrayList blockRefunds = Lists.newArrayList();
        ArrayList contentRefunds = Lists.newArrayList();
        EnumMultiset directions = EnumMultiset.create(EnumFacing.class);
        blockRefunds.add(new ItemStack((Block)CoPo.controller));
        int refundIron = 0;
        int refundCeramicPlatters = 0;
        int refundMetallicPlatters = 0;
        int refundPearls = 0;
        int refundDiamonds = 0;
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.remove(0);
            seen.add(pos);
            TileEntity te = this.func_145831_w().func_175625_s(pos);
            if (!(te instanceof TileEntityNetworkMember) && te != this) continue;
            for (EnumFacing ef : EnumFacing.field_82609_l) {
                BlockPos p = pos.func_177972_a(ef);
                if (seen.contains(p)) continue;
                if (this.field_145850_b.func_175625_s(p) == null) {
                    seen.add(p);
                    continue;
                }
                queue.add(p);
            }
            if (te == this) continue;
            if (te instanceof TileEntityDriveBay) {
                if (CoPo.inst.refundContent) {
                    for (ItemStack is : (TileEntityDriveBay)te) {
                        if (is.func_77960_j() != 4) {
                            contentRefunds.add(this.toCore(is));
                            switch (is.func_77952_i()) {
                                case 0: {
                                    refundIron += 7;
                                    ++refundCeramicPlatters;
                                    break;
                                }
                                case 1: {
                                    refundIron += 5;
                                    refundCeramicPlatters += 3;
                                    break;
                                }
                                case 2: {
                                    refundIron += 5;
                                    refundDiamonds += 2;
                                    ++refundMetallicPlatters;
                                    break;
                                }
                                case 3: {
                                    refundDiamonds += 3;
                                    ++refundPearls;
                                    refundMetallicPlatters += 4;
                                }
                            }
                            continue;
                        }
                        contentRefunds.add(is);
                    }
                }
                blockRefunds.add(new ItemStack((Block)CoPo.drive_bay));
                directions.add((Object)this.field_145850_b.func_180495_p(pos).func_177229_b((IProperty)BlockDriveBay.FACING));
                delete.add(pos);
                continue;
            }
            if (te instanceof TileEntityTerminal) {
                blockRefunds.add(new ItemStack((Block)CoPo.terminal));
                directions.add((Object)this.field_145850_b.func_180495_p(pos).func_177229_b((IProperty)BlockTerminal.FACING));
                delete.add(pos);
                continue;
            }
            if (te instanceof TileEntityWirelessReceiver) {
                blockRefunds.add(new ItemStack((Block)CoPo.wireless_endpoint, 1, 0));
                delete.add(pos);
                continue;
            }
            if (te instanceof TileEntityWirelessTransmitter) {
                blockRefunds.add(new ItemStack((Block)CoPo.wireless_endpoint, 1, 1));
                delete.add(pos);
                continue;
            }
            if (te instanceof TileEntityInterface) {
                TileEntityInterface tei = (TileEntityInterface)te;
                for (int i = 0; i > tei.func_70302_i_(); ++i) {
                    ItemStack is = tei.func_70301_a(i);
                    if (is == null) continue;
                    contentRefunds.add(is);
                }
                blockRefunds.add(new ItemStack((Block)CoPo.iface));
                delete.add(pos);
                continue;
            }
            if (te instanceof TileEntityController || te instanceof TileEntityNetworkImporter) {
                blockRefunds.add(new ItemStack((Block)CoPo.controller));
                delete.add(pos);
                continue;
            }
            if (!(te instanceof TileEntityMemoryBay)) continue;
            CoPo.log.info("Aborting import. Found a memory bay, which is indicative of a new network");
            this.substitute(new TileEntityController(), true);
            return;
        }
        for (BlockPos d : delete) {
            this.field_145850_b.func_175713_t(d);
            this.field_145850_b.func_175698_g(d);
        }
        if (justDelete) {
            CoPo.log.info("Sucessfully deleted old network at {}, {}, {}", new Object[]{this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()});
            this.substitute(Blocks.field_150350_a.func_176223_P(), null, false);
            return;
        }
        TileEntityImporterChest chest = new TileEntityImporterChest();
        EnumFacing facing = EnumFacing.NORTH;
        int weight = 0;
        for (Multiset.Entry en : directions.entrySet()) {
            if (en.getCount() <= weight) continue;
            facing = (EnumFacing)en.getElement();
            weight = en.getCount();
        }
        if (CoPo.inst.refundDriveComponents) {
            if (refundIron > 0) {
                chest.addItemToNetwork(new ItemStack(Items.field_151042_j, refundIron));
            }
            if (refundCeramicPlatters > 0) {
                chest.addItemToNetwork(new ItemStack((Item)CoPo.misc, refundCeramicPlatters, 1));
            }
            if (refundMetallicPlatters > 0) {
                chest.addItemToNetwork(new ItemStack((Item)CoPo.misc, refundMetallicPlatters, 2));
            }
            if (refundPearls > 0) {
                chest.addItemToNetwork(new ItemStack((Item)CoPo.misc, refundPearls, 3));
            }
            if (refundDiamonds > 0) {
                chest.addItemToNetwork(new ItemStack(Items.field_151045_i, refundDiamonds));
            }
        }
        if (CoPo.inst.refundBlocks) {
            for (ItemStack is : blockRefunds) {
                chest.addItemToNetwork(is);
            }
        }
        if (CoPo.inst.refundContent) {
            for (ItemStack is : contentRefunds) {
                chest.addItemToNetwork(is);
            }
        }
        int sum = 0;
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            ItemStack is = chest.func_70301_a(i);
            if (is == null) continue;
            sum += is.field_77994_a;
        }
        CoPo.log.info("Sucessfully imported old network at {}, {}, {}, refunding {} items", new Object[]{this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), sum});
        this.substitute(CoPo.importer_chest.func_176223_P().func_177226_a((IProperty)BlockImporterChest.FACING, (Comparable)facing), chest, false);
    }

    private ItemStack toCore(ItemStack is) {
        ItemStack core = new ItemStack((Item)CoPo.misc, 1, 8);
        if (is.func_77942_o()) {
            core.func_77982_d(is.func_77978_p().func_74737_b());
        } else {
            core.func_77982_d(new NBTTagCompound());
        }
        return core;
    }
}

