/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.tile;

import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.tile.TileEntityController;
import io.github.elytra.copo.tile.TileEntityNetworkImporter;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class TileEntityNetworkMember
extends TileEntity {
    private TileEntityController controller;
    private Vec3i controllerPos;

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.controllerPos != null) {
            compound.func_74768_a("ControllerOffsetX", this.controllerPos.func_177958_n());
            compound.func_74768_a("ControllerOffsetY", this.controllerPos.func_177956_o());
            compound.func_74768_a("ControllerOffsetZ", this.controllerPos.func_177952_p());
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("ControllerOffsetX")) {
            this.controllerPos = new Vec3i(compound.func_74762_e("ControllerOffsetX"), compound.func_74762_e("ControllerOffsetY"), compound.func_74762_e("ControllerOffsetZ"));
        }
    }

    public boolean hasStorage() {
        return this.getStorage() != null;
    }

    public TileEntityController getStorage() {
        if (!this.func_145830_o()) {
            return null;
        }
        if (this.controller != null && this.controller.func_145837_r()) {
            this.controller = null;
        }
        if (this.controller == null && this.controllerPos != null) {
            BlockPos pos = this.func_174877_v().func_177971_a(this.controllerPos);
            TileEntity te = this.func_145831_w().func_175625_s(pos);
            if (te instanceof TileEntityController) {
                this.controller = (TileEntityController)te;
            } else {
                this.controllerPos = null;
                if (!(te instanceof TileEntityNetworkImporter)) {
                    CoPo.log.warn("The network member at {}, {}, {} failed to find its controller", new Object[]{this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()});
                }
            }
        }
        return this.controller;
    }

    public void setController(TileEntityController controller) {
        if (!this.func_145830_o()) {
            return;
        }
        this.controllerPos = controller == null ? null : controller.func_174877_v().func_177973_b((Vec3i)this.func_174877_v());
        this.controller = controller;
        if (controller != null) {
            for (EnumFacing ef : EnumFacing.field_82609_l) {
                TileEntityNetworkMember tenm;
                TileEntity neighbor = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(ef));
                if (!(neighbor instanceof TileEntityNetworkMember) || (tenm = (TileEntityNetworkMember)neighbor).hasStorage() || !this.hasStorage()) continue;
                tenm.setController(controller);
                controller.updateConsumptionRate(tenm.getEnergyConsumedPerTick());
                controller.onNetworkPatched(tenm);
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public abstract long getEnergyConsumedPerTick();

    public void handleNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity te = world.func_175625_s(neighbor);
        if (te instanceof TileEntityNetworkMember) {
            TileEntityNetworkMember tenm = (TileEntityNetworkMember)te;
            if (!tenm.hasStorage() && this.hasStorage()) {
                tenm.setController(this.getStorage());
                this.getStorage().updateConsumptionRate(tenm.getEnergyConsumedPerTick());
                this.getStorage().onNetworkPatched(tenm);
            }
        } else if (this.hasStorage() && this.getStorage().knowsOfMemberAt(neighbor)) {
            this.getStorage().scanNetwork();
        }
    }
}

