/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.tile;

import com.google.common.collect.Maps;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.block.BlockTerminal;
import io.github.elytra.copo.item.ItemDrive;
import io.github.elytra.copo.storage.IDigitalStorage;
import io.github.elytra.copo.storage.ITerminal;
import io.github.elytra.copo.tile.TileEntityController;
import io.github.elytra.copo.tile.TileEntityNetworkMember;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;

public class TileEntityTerminal
extends TileEntityNetworkMember
implements ITickable,
IInventory,
ITerminal,
ISidedInventory {
    private Map<UUID, ITerminal.UserPreferences> preferences = Maps.newHashMap();
    private InventoryBasic inv = new InventoryBasic("gui.correlatedpotentialistics.terminal", false, 2);

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            IDigitalStorage controller;
            boolean floppy;
            boolean lit;
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (state.func_177230_c() == CoPo.terminal && (lit = this.hasStorage() && ((TileEntityController)this.getStorage()).isPowered()) != (Boolean)state.func_177229_b((IProperty)BlockTerminal.LIT)) {
                state = state.func_177226_a((IProperty)BlockTerminal.LIT, (Comparable)Boolean.valueOf(lit));
                this.func_145831_w().func_175656_a(this.func_174877_v(), state);
            }
            boolean bl = floppy = this.func_70301_a(1) != null;
            if (floppy != (Boolean)state.func_177229_b((IProperty)BlockTerminal.FLOPPY)) {
                this.func_145831_w().func_175656_a(this.func_174877_v(), state.func_177226_a((IProperty)BlockTerminal.FLOPPY, (Comparable)Boolean.valueOf(floppy)));
            }
            if (this.hasStorage() && ((TileEntityController)(controller = this.getStorage())).isPowered() && !((TileEntityController)controller).error && !((TileEntityController)controller).booting && this.getDumpDrive() != null && this.getDumpDrive().func_77973_b() instanceof ItemDrive) {
                ItemDrive id = (ItemDrive)this.getDumpDrive().func_77973_b();
                List<ItemStack> prototypes = id.getPrototypes(this.getDumpDrive());
                int moved = 0;
                while (moved < 100 && !prototypes.isEmpty()) {
                    ItemStack prototype = prototypes.get(0);
                    ItemStack split = id.removeItems(this.getDumpDrive(), prototype, prototype.func_77976_d());
                    if (split.field_77994_a == 0) {
                        prototypes.remove(0);
                        continue;
                    }
                    ((TileEntityController)controller).addItemToNetwork(split);
                    moved += split.field_77994_a;
                    if (split.field_77994_a <= 0) continue;
                    prototypes.remove(0);
                    moved -= split.field_77994_a;
                    id.addItem(this.getDumpDrive(), split);
                }
            }
        }
    }

    @Override
    public long getEnergyConsumedPerTick() {
        return CoPo.inst.terminalRfUsage;
    }

    public ITerminal.UserPreferences getPreferences(UUID uuid) {
        if (!this.preferences.containsKey(uuid)) {
            this.preferences.put(uuid, new ITerminal.UserPreferences());
        }
        return this.preferences.get(uuid);
    }

    @Override
    public ITerminal.UserPreferences getPreferences(EntityPlayer player) {
        return this.getPreferences(player.func_146103_bH().getId());
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList prefs = new NBTTagList();
        for (Map.Entry<UUID, ITerminal.UserPreferences> en : this.preferences.entrySet()) {
            ITerminal.UserPreferences pref = en.getValue();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("UUIDMost", en.getKey().getMostSignificantBits());
            data.func_74772_a("UUIDLeast", en.getKey().getLeastSignificantBits());
            pref.writeToNBT(data);
            prefs.func_74742_a((NBTBase)data);
        }
        compound.func_74782_a("Preferences", (NBTBase)prefs);
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack is = this.func_70301_a(i);
            if (is == null) continue;
            NBTTagCompound tag = is.func_77955_b(new NBTTagCompound());
            tag.func_74768_a("Slot", i);
            invList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("Inventory", (NBTBase)invList);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList prefs = compound.func_150295_c("Preferences", 10);
        for (int i = 0; i < prefs.func_74745_c(); ++i) {
            ITerminal.UserPreferences pref = new ITerminal.UserPreferences();
            NBTTagCompound data = prefs.func_150305_b(i);
            pref.readFromNBT(data);
            this.preferences.put(new UUID(data.func_74763_f("UUIDMost"), data.func_74763_f("UUIDLeast")), pref);
        }
        this.inv.func_174888_l();
        NBTTagList invList = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < invList.func_74745_c(); ++i) {
            NBTTagCompound tag = invList.func_150305_b(i);
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag);
            int slot = tag.func_74762_e("Slot");
            this.func_70299_a(slot, is);
        }
    }

    public ItemStack getDumpDrive() {
        return this.func_70301_a(0);
    }

    public void addInventoryChangeListener(IInventoryChangedListener listener) {
        this.inv.func_110134_a(listener);
    }

    public void removeInventoryChangeListener(IInventoryChangedListener listener) {
        this.inv.func_110132_b(listener);
    }

    public ItemStack func_70301_a(int index) {
        return this.inv.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inv.func_70298_a(index, count);
    }

    public ItemStack addItem(ItemStack stack) {
        return this.inv.func_174894_a(stack);
    }

    public ItemStack func_70304_b(int index) {
        return this.inv.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inv.func_70299_a(index, stack);
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public String func_70005_c_() {
        return this.inv.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inv.func_145818_k_();
    }

    public void setCustomName(String inventoryTitleIn) {
        this.inv.func_110133_a(inventoryTitleIn);
    }

    public ITextComponent func_145748_c_() {
        return this.inv.func_145748_c_();
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public void func_70296_d() {
        this.inv.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inv.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inv.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inv.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inv.func_94041_b(index, stack);
    }

    public int func_174887_a_(int id) {
        return this.inv.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inv.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inv.func_174890_g();
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public boolean supportsDumpSlot() {
        return true;
    }

    @Override
    public IInventory getDumpSlotInventory() {
        return this;
    }

    @Override
    public boolean canContinueInteracting(EntityPlayer player) {
        return true;
    }

    @Override
    public void markUnderlyingStorageDirty() {
        this.func_70296_d();
    }
}

