/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.world;

import com.google.common.collect.Lists;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.math.Vec2f;
import io.github.elytra.copo.world.DungeonPlayer;
import io.github.elytra.hallways.DungeonTile;
import io.github.elytra.hallways.HallwayGenerator;
import io.github.elytra.hallways.VectorField;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class Dungeon
implements INBTSerializable<NBTTagCompound> {
    public static final int NODE_SIZE = 8;
    public static final int DUNGEON_SIZE = 64;
    public static final int MIN_COMPLEXITY = 30;
    public static final int IDEAL_COMPLEXITY = 40;
    public static final int MAX_COMPLEXITY = 50;
    protected int x;
    protected int z;
    private boolean conquered = false;
    private final List<DungeonPlayer> players = Lists.newArrayList();
    private final List<DungeonPlayer> playersView = Collections.unmodifiableList(this.players);
    private final Map<UUID, DungeonPlayer> playerLookup = new WeakHashMap<UUID, DungeonPlayer>();
    private VectorField<DungeonTile> plan = new VectorField(0, 0);
    private long seed;

    public void generateNewPlan() {
        DungeonTile hall = new DungeonTile(DungeonTile.TileType.HALLWAY);
        DungeonTile room = new DungeonTile(DungeonTile.TileType.ROOM);
        DungeonTile entrance = new DungeonTile(DungeonTile.TileType.ENTRANCE);
        DungeonTile exit = new DungeonTile(DungeonTile.TileType.EXIT);
        VectorField<DungeonTile> selected = null;
        int complexityDelta = 0;
        int selectedComplexity = 0;
        int trials = 0;
        for (int i = 0; i < 40; ++i) {
            VectorField<DungeonTile> field = new VectorField<DungeonTile>(64, 64);
            int complexity = HallwayGenerator.generateInto(field, hall, room, entrance, exit);
            ++trials;
            if (complexity > 50 || complexity < 30) {
                --i;
                continue;
            }
            if (selected != null && complexity >= complexityDelta) continue;
            selected = field;
            complexityDelta = Math.abs(complexity - 40);
            selectedComplexity = complexity;
        }
        CoPo.log.info("Generated a dungeon with complexity {} (target {}), after {} trials", new Object[]{selectedComplexity, 40, trials});
        this.plan = selected;
    }

    public boolean noPlayersOnline() {
        for (DungeonPlayer dp : this.players) {
            if (FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(dp.getProfile().getId()) == null) continue;
            return false;
        }
        return true;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("Conquered", this.conquered);
        NBTTagList li = new NBTTagList();
        for (DungeonPlayer p : this.players) {
            li.func_74742_a((NBTBase)p.serializeNBT());
        }
        tag.func_74782_a("Players", (NBTBase)li);
        NBTTagCompound planTag = new NBTTagCompound();
        NBTTagList cells = new NBTTagList();
        for (int x = 0; x < this.plan.getWidth(); ++x) {
            for (int y = 0; y < this.plan.getHeight(); ++y) {
                DungeonTile tile = this.plan.get(x, y);
                if (tile == null) continue;
                NBTTagCompound entry = new NBTTagCompound();
                entry.func_74768_a("X", x);
                entry.func_74768_a("Y", y);
                entry.func_74782_a("Content", (NBTBase)tile.serializeNBT());
                cells.func_74742_a((NBTBase)entry);
            }
        }
        planTag.func_74782_a("Cells", (NBTBase)cells);
        if (this.plan.hasTag()) {
            planTag.func_74782_a("Tag", (NBTBase)this.plan.getTag());
        }
        planTag.func_74768_a("Width", this.plan.getWidth());
        planTag.func_74768_a("Height", this.plan.getHeight());
        tag.func_74782_a("Plan", (NBTBase)planTag);
        tag.func_74772_a("Seed", this.seed);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.conquered = nbt.func_74767_n("Conquered");
        NBTTagList li = nbt.func_150295_c("Players", 10);
        this.players.clear();
        this.playerLookup.clear();
        for (int i = 0; i < li.func_74745_c(); ++i) {
            DungeonPlayer p = new DungeonPlayer();
            p.deserializeNBT(li.func_150305_b(i));
            this.addPlayer(p);
        }
        NBTTagCompound planTag = nbt.func_74775_l("Plan");
        this.plan = new VectorField(planTag.func_74762_e("Width"), planTag.func_74762_e("Height"));
        this.plan.setTag(planTag.func_74775_l("Tag"));
        NBTTagList cells = new NBTTagList();
        for (int i = 0; i < cells.func_74745_c(); ++i) {
            NBTTagCompound entry = cells.func_150305_b(i);
            DungeonTile tile = new DungeonTile(DungeonTile.TileType.HALLWAY);
            tile.deserializeNBT(entry.func_74775_l("Content"));
            this.plan.put(entry.func_74762_e("X"), entry.func_74762_e("Y"), tile);
        }
        this.seed = nbt.func_74763_f("Seed");
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public VectorField<DungeonTile> getPlan() {
        return this.plan;
    }

    public List<DungeonPlayer> getPlayers() {
        return this.playersView;
    }

    public DungeonPlayer getPlayer(EntityPlayer entity) {
        if (entity == null) {
            return null;
        }
        return this.getPlayer(entity.func_146103_bH().getId());
    }

    public DungeonPlayer getPlayer(UUID id) {
        if (id == null) {
            return null;
        }
        return this.playerLookup.get(id);
    }

    public void addPlayer(DungeonPlayer player) {
        this.players.add(player);
        this.playerLookup.put(player.getProfile().getId(), player);
    }

    public void removePlayer(DungeonPlayer player) {
        this.players.remove(player);
        this.playerLookup.remove(player.getProfile().getId());
    }

    public boolean isConquered() {
        return this.conquered;
    }

    public void setConquered(boolean conquered) {
        this.conquered = conquered;
    }

    public boolean canBeFreed() {
        return this.isConquered() && this.players.isEmpty();
    }

    public Vec2f findEntranceTile() {
        float xAcc = 0.0f;
        float zAcc = 0.0f;
        int found = 0;
        for (int x = 0; x < this.plan.getWidth(); ++x) {
            for (int y = 0; y < this.plan.getHeight(); ++y) {
                DungeonTile t = this.plan.get(x, y);
                if (t == null || t.type != DungeonTile.TileType.ENTRANCE) continue;
                xAcc += (float)x;
                zAcc += (float)y;
                ++found;
            }
        }
        if (found <= 0) {
            return null;
        }
        return new Vec2f(xAcc / (float)found, zAcc / (float)found);
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }
}

