/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.world;

import com.google.common.collect.Maps;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.math.Vec2i;
import io.github.elytra.copo.world.Dungeon;
import io.github.elytra.hallways.Cardinal;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.util.INBTSerializable;

public class DungeonGrid
implements INBTSerializable<NBTTagCompound> {
    private Map<Vec2i, Dungeon> dungeons = Maps.newHashMap();
    private TLongObjectMap<Dungeon> dungeonsBySeed = new TLongObjectHashMap();

    public Dungeon get(Vec2i vec) {
        Dungeon d = this.dungeons.get(vec);
        if (d != null) {
            d.x = vec.x;
            d.z = vec.y;
        }
        return d;
    }

    public Dungeon get(int x, int z) {
        return this.get(new Vec2i(x, z));
    }

    public Dungeon getFromBlock(BlockPos pos) {
        return this.getFromBlock(pos.func_177958_n(), pos.func_177952_p());
    }

    public Dungeon getFromBlock(int x, int z) {
        return this.get(x / 8 / 64, z / 8 / 64);
    }

    public Dungeon getFromChunk(ChunkPos pos) {
        return this.getFromChunk(pos.field_77276_a, pos.field_77275_b);
    }

    public Dungeon getFromChunk(int x, int z) {
        return this.getFromBlock(x * 16, z * 16);
    }

    public void set(int x, int z, Dungeon d) {
        this.dungeons.put(new Vec2i(x, z), d);
        if (this.dungeonsBySeed.containsKey(d.getSeed()) && d != this.dungeonsBySeed.get(d.getSeed())) {
            CoPo.log.warn("Adding second dungeon with the same seed (orig: {}, new: {})", new Object[]{this.dungeonsBySeed.get(d.getSeed()), d});
        }
        this.dungeonsBySeed.put(d.getSeed(), (Object)d);
        d.x = x;
        d.z = z;
    }

    public void set(Vec2i vec, Dungeon d) {
        this.set(vec.x, vec.y, d);
        d.x = vec.x;
        d.z = vec.y;
    }

    public Vec2i findFreeSpot() {
        int x = 0;
        int z = 0;
        Cardinal dir = Cardinal.WEST;
        int legLength = 0;
        int i = 0;
        int j = 0;
        Dungeon cur;
        while ((cur = this.get(x, z)) != null && !cur.canBeFreed()) {
            if (i >= legLength) {
                dir = dir.ccw();
                i = 0;
                if (++j % 2 == 0) {
                    ++legLength;
                }
            }
            x += dir.xOfs();
            z += dir.yOfs();
            ++i;
        }
        return new Vec2i(x, z);
    }

    public Dungeon getBySeed(long seed) {
        return (Dungeon)this.dungeonsBySeed.get(seed);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList li = new NBTTagList();
        for (Map.Entry<Vec2i, Dungeon> en : this.dungeons.entrySet()) {
            NBTTagCompound entry = en.getValue().serializeNBT();
            entry.func_74768_a("X", en.getKey().x);
            entry.func_74768_a("Z", en.getKey().y);
            li.func_74742_a((NBTBase)entry);
        }
        tag.func_74782_a("Dungeons", (NBTBase)li);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.dungeons.clear();
        NBTTagList li = nbt.func_150295_c("Dungeons", 10);
        for (int i = 0; i < li.func_74745_c(); ++i) {
            NBTTagCompound entry = li.func_150305_b(i);
            Dungeon d = new Dungeon();
            d.deserializeNBT(entry);
            this.dungeons.put(new Vec2i(entry.func_74762_e("X"), entry.func_74762_e("Z")), d);
            this.dungeonsBySeed.put(d.getSeed(), (Object)d);
        }
    }
}

