/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.world;

import io.github.elytra.copo.math.Vec2i;
import io.github.elytra.copo.world.Dungeon;
import io.github.elytra.hallways.DungeonTile;
import io.github.elytra.hallways.VectorField;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public class DungeonScribe {
    private World world;

    public DungeonScribe(World world) {
        this.world = world;
    }

    public void erase(Vec2i d) {
        int startX = d.x * 8 * 64;
        int startZ = d.y * 8 * 64;
        int endX = (d.x + 1) * 8 * 64;
        int endZ = (d.y + 1) * 8 * 64;
        if (startX % 16 == 0 && startZ % 16 == 0 && endX % 16 == 0 && endZ % 16 == 0) {
            startZ /= 16;
            endX /= 16;
            endZ /= 16;
            for (int x = startX /= 16; x < endX; ++x) {
                for (int z = startZ; z < endZ; ++z) {
                    Chunk c = this.world.func_72964_e(x, z);
                    if (c.func_76625_h() == 0) continue;
                    Arrays.fill(c.func_76587_i(), Chunk.field_186036_a);
                    Arrays.fill(c.func_76605_m(), (byte)Biome.func_185362_a((Biome)Biomes.field_185440_P));
                    for (TileEntity te : c.func_177434_r().values()) {
                        if (te == null) continue;
                        te.func_145843_s();
                    }
                    c.func_177434_r().clear();
                    for (ClassInheritanceMultiMap m : c.func_177429_s()) {
                        for (Entity e : m) {
                            e.func_70106_y();
                        }
                    }
                    c.func_76603_b();
                    c.func_150809_p();
                    c.func_177415_c(0L);
                    c.func_76630_e();
                    c.func_76613_n();
                }
            }
        } else {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = startX; x < endX; ++x) {
                for (int z = startZ; z < endZ; ++z) {
                    pos.func_181079_c(x, 0, z);
                    for (int y = 0; y < this.world.func_72800_K(); ++y) {
                        pos.func_185336_p(y);
                        this.world.func_175698_g((BlockPos)pos);
                        this.world.func_175713_t((BlockPos)pos);
                    }
                    for (ClassInheritanceMultiMap m : this.world.func_175726_f((BlockPos)pos).func_177429_s()) {
                        for (Entity e : m) {
                            if (!(e.field_70165_t >= (double)startX) || !(e.field_70165_t < (double)endX) || !(e.field_70161_v >= (double)startZ) || !(e.field_70161_v < (double)endZ)) continue;
                            e.func_70106_y();
                        }
                    }
                }
            }
        }
    }

    public void write(Dungeon d) {
        VectorField<DungeonTile> plan = d.getPlan();
        int startX = d.x * 8 * 64;
        int startZ = d.z * 8 * 64;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 64; ++x) {
            for (int z = 0; z < 64; ++z) {
                DungeonTile tile = plan.get(x, z);
                if (tile == null) continue;
                int bX = startX + x * 8;
                int bZ = startZ + z * 8;
                for (int cX = bX; cX < bX + 8; ++cX) {
                    for (int cZ = bZ; cZ < bZ + 8; ++cZ) {
                        pos.func_181079_c(cX, 50, cZ);
                        this.world.func_175656_a((BlockPos)pos, Blocks.field_150348_b.func_176223_P());
                        if (cX != bX && cZ != bZ && cX != bX + 7 && cZ != bZ + 7) continue;
                        this.world.func_175656_a((BlockPos)pos, Blocks.field_150348_b.func_176223_P());
                        pos.func_185336_p(51);
                    }
                }
            }
        }
    }
}

