/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.world;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.math.Vec2i;
import io.github.elytra.copo.network.SetGlitchingStateMessage;
import io.github.elytra.copo.world.Dungeon;
import io.github.elytra.copo.world.DungeonGrid;
import io.github.elytra.copo.world.DungeonPlayer;
import io.github.elytra.copo.world.DungeonScribe;
import io.github.elytra.copo.world.LimboChunkGenerator;
import io.github.elytra.copo.world.LimboProvider$$Lambda$1;
import io.github.elytra.copo.world.LimboTeleporter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LimboProvider
extends WorldProvider {
    private static final DamageSource constraint_violation = new DamageSource("correlatedpotentialistics.constraint_violation").func_76359_i().func_76348_h().func_151518_m();
    private DungeonGrid grid;
    private DungeonScribe scribe;
    private final Map<EntityPlayerMP, Vec2i> constraints = new WeakHashMap<EntityPlayerMP, Vec2i>();
    private final Map<UUID, DungeonPlayer> entering = Maps.newHashMap();
    private final Set<UUID> leaving = Sets.newHashSet();
    private LimboTeleporter teleporter;

    public DimensionType func_186058_p() {
        return CoPo.limbo;
    }

    public void func_76572_b() {
        this.field_76578_c = new BiomeProviderSingle(Biomes.field_185440_P);
        this.field_76576_e = true;
        this.grid = new DungeonGrid();
        this.grid.deserializeNBT(this.field_76579_a.func_72912_H().func_186347_a(this.func_186058_p()));
        this.scribe = new DungeonScribe(this.field_76579_a);
        if (this.field_76579_a instanceof WorldServer) {
            this.teleporter = new LimboTeleporter((WorldServer)this.field_76579_a, this.scribe, this.grid);
        }
    }

    public IChunkGenerator func_186060_c() {
        return new LimboChunkGenerator(this.field_76579_a, this.field_76579_a.func_72912_H().func_76089_r(), this.field_76579_a.func_72905_C(), this.grid);
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        return new Vec3d(0.4, 0.4, 0.4);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    public boolean func_76567_e() {
        return false;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return this.leaving.remove(player.func_146103_bH().getId()) ? 0 : CoPo.limboDimId;
    }

    public LimboTeleporter getTeleporter() {
        return this.teleporter;
    }

    public boolean func_76569_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return 8.0f;
    }

    public boolean func_76566_a(int x, int z) {
        return this.field_76579_a.func_184141_c(new BlockPos(x, 0, z)).func_185904_a().func_76230_c();
    }

    public BlockPos func_177496_h() {
        return new BlockPos(0, 64, 0);
    }

    public int func_76557_i() {
        return 50;
    }

    public String getWelcomeMessage() {
        return "Entering \u00a7kAhasFDDS d fHFDS h";
    }

    public String getDepartMessage() {
        return "Leaving \u00a7kAhasFDDS d fHFDS h";
    }

    public boolean func_186056_c(int x, int z) {
        Dungeon d = this.grid.getFromChunk(x, z);
        return d == null || d.noPlayersOnline();
    }

    public void func_186061_a(EntityPlayerMP player) {
        int x = (int)Math.floor(player.field_70165_t / 8.0 / 64.0);
        int z = (int)Math.floor(player.field_70161_v / 8.0 / 64.0);
        this.constraints.put(player, new Vec2i(x, z));
        CoPo.log.info("Constraining {} to dungeon {}", new Object[]{player.func_70005_c_(), this.constraints.get(player)});
    }

    public void func_186062_b(EntityPlayerMP player) {
    }

    public void func_186057_q() {
        this.field_76579_a.func_72912_H().func_186345_a(this.func_186058_p(), this.grid.serializeNBT());
    }

    public void func_186059_r() {
        Iterator<Map.Entry<EntityPlayerMP, Vec2i>> iter = this.constraints.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<EntityPlayerMP, Vec2i> en = iter.next();
            EntityPlayerMP player = en.getKey();
            if (player.field_70128_L) {
                DungeonPlayer p;
                Dungeon d;
                CoPo.log.info("Removing constraints on {}", new Object[]{player.func_70005_c_()});
                if (this.leaving.contains(player.func_146103_bH().getId()) && (d = this.grid.getFromBlock((int)player.field_70165_t, (int)player.field_70161_v)) != null && (p = d.getPlayer((EntityPlayer)player)) != null) {
                    d.removePlayer(p);
                    player.func_70106_y();
                    MinecraftServer srv = player.field_71133_b;
                    player.func_71121_q().func_152344_a(LimboProvider$$Lambda$1.lambdaFactory$(srv, p));
                }
                iter.remove();
                continue;
            }
            player.func_71033_a(GameType.ADVENTURE);
            int dX = (int)Math.floor(player.field_70165_t / 8.0 / 64.0);
            int dZ = (int)Math.floor(player.field_70161_v / 8.0 / 64.0);
            if (dX == en.getValue().x && dZ == en.getValue().y) continue;
            new SetGlitchingStateMessage(SetGlitchingStateMessage.GlitchState.CORRUPTING).sendTo((EntityPlayer)player);
            en.getKey().func_70097_a(constraint_violation, 75000.0f);
            en.getKey().func_70106_y();
        }
    }

    public void addLeavingPlayer(UUID id) {
        this.leaving.add(id);
    }

    public void addEnteringPlayer(DungeonPlayer player) {
        this.entering.put(player.getProfile().getId(), player);
    }

    public boolean isEntering(UUID id) {
        return this.entering.containsKey(id);
    }

    public DungeonPlayer popEntering(UUID id) {
        return this.entering.remove(id);
    }

    private static /* synthetic */ void lambda$onWorldUpdateEntities$0(MinecraftServer srv, DungeonPlayer p) {
        EntityPlayerMP nw = srv.func_184103_al().func_177451_a(p.getProfile().getId());
        nw.func_70020_e(p.getOldPlayer());
    }

    static /* synthetic */ void access$lambda$0(MinecraftServer minecraftServer, DungeonPlayer dungeonPlayer) {
        LimboProvider.lambda$onWorldUpdateEntities$0(minecraftServer, dungeonPlayer);
    }
}

