/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.copo.world;

import com.google.common.base.Stopwatch;
import io.github.elytra.copo.CoPo;
import io.github.elytra.copo.CoPoWorldData;
import io.github.elytra.copo.math.Vec2f;
import io.github.elytra.copo.math.Vec2i;
import io.github.elytra.copo.world.Dungeon;
import io.github.elytra.copo.world.DungeonGrid;
import io.github.elytra.copo.world.DungeonPlayer;
import io.github.elytra.copo.world.DungeonScribe;
import io.github.elytra.copo.world.LimboProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class LimboTeleporter
extends Teleporter {
    private final WorldServer world;
    private final DungeonGrid grid;
    private final DungeonScribe scribe;

    public LimboTeleporter(WorldServer world, DungeonScribe scribe, DungeonGrid grid) {
        super(world);
        this.world = world;
        this.scribe = scribe;
        this.grid = grid;
    }

    public boolean func_85188_a(Entity entityIn) {
        return false;
    }

    public boolean func_180620_b(Entity entityIn, float rotationYaw) {
        this.func_180266_a(entityIn, rotationYaw);
        return true;
    }

    public void func_180266_a(Entity entityIn, float rotationYaw) {
        LimboProvider provider = (LimboProvider)this.world.field_73011_w;
        EntityPlayerMP player = (EntityPlayerMP)entityIn;
        DungeonPlayer dp = provider.popEntering(player.func_146103_bH().getId());
        CoPoWorldData data = CoPo.getDataFor((World)this.world.func_73046_m().func_71218_a(0));
        data.getPlayerRespawnData().put(dp.getProfile().getId(), dp.getOldPlayer());
        data.func_76185_a();
        Dungeon d = this.grid.getBySeed(dp.getSeed());
        if (d == null) {
            Vec2i freeSpot = this.grid.findFreeSpot();
            Stopwatch sw = Stopwatch.createUnstarted();
            sw.start();
            this.scribe.erase(freeSpot);
            sw.stop();
            CoPo.log.info("Freed space at {} in {}", new Object[]{freeSpot, sw});
            sw.reset();
            sw.start();
            d = new Dungeon();
            d.generateNewPlan();
            this.grid.set(freeSpot, d);
            sw.stop();
            CoPo.log.info("Generated new dungeon at {} in {}", new Object[]{freeSpot, sw});
            sw.reset();
            sw.start();
            this.scribe.write(d);
            sw.stop();
            CoPo.log.info("Scribed new dungeon at {} in {}", new Object[]{freeSpot, sw});
        } else {
            CoPo.log.info("Reusing existing dungeon at {}, {}", new Object[]{d.x, d.z});
        }
        Vec2f entrance = d.findEntranceTile();
        int x = d.x * 8 * 64;
        int z = d.z * 8 * 64;
        x = (int)((float)x + entrance.x * 8.0f);
        z = (int)((float)z + entrance.y * 8.0f);
        int y = 51;
        BlockPos pos = new BlockPos(x += 4, y - 1, z += 4);
        if (this.world.func_175623_d(pos)) {
            this.world.func_175656_a(pos, Blocks.field_150348_b.func_176223_P());
        }
        ((EntityPlayerMP)entityIn).field_71135_a.func_147364_a((double)x + 0.5, (double)y, (double)z + 0.5, rotationYaw, entityIn.field_70125_A);
    }
}

