/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.hallways;

import io.github.elytra.copo.math.Vec2i;

public enum Cardinal {
    NORTH(0, -1),
    EAST(1, 0),
    SOUTH(0, 1),
    WEST(-1, 0);

    private int x;
    private int y;

    private Cardinal(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int xOfs() {
        return this.x;
    }

    public int yOfs() {
        return this.y;
    }

    public Cardinal cw() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case EAST: {
                return SOUTH;
            }
            case SOUTH: {
                return WEST;
            }
        }
        return NORTH;
    }

    public Cardinal ccw() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case EAST: {
                return NORTH;
            }
            case SOUTH: {
                return EAST;
            }
        }
        return SOUTH;
    }

    public static Cardinal fromTo(Vec2i from, Vec2i to) {
        boolean ns;
        boolean we = from.x == to.x;
        boolean bl = ns = from.y == to.y;
        if (ns && we || !ns && !we) {
            return NORTH;
        }
        if (to.x > from.x) {
            return EAST;
        }
        if (to.x < from.x) {
            return WEST;
        }
        if (to.y < from.y) {
            return NORTH;
        }
        if (to.y > from.y) {
            return SOUTH;
        }
        return NORTH;
    }
}

