/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.hallways;

import io.github.elytra.hallways.Cardinal;
import java.util.EnumSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class DungeonTile
implements INBTSerializable<NBTTagCompound>,
Cloneable {
    public TileType type;
    public EnumSet<Cardinal> exits;

    public DungeonTile(TileType type) {
        this.type = type;
        this.exits = EnumSet.noneOf(Cardinal.class);
    }

    public DungeonTile clone() {
        DungeonTile result = new DungeonTile(this.type);
        result.exits = EnumSet.copyOf(this.exits);
        return result;
    }

    public EnumSet<Cardinal> exits() {
        return this.exits;
    }

    public void clearExits() {
        this.exits.clear();
    }

    public void setExits(Cardinal ... cardinals) {
        this.exits.clear();
        for (Cardinal cardinal : cardinals) {
            this.exits.add(cardinal);
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        int i = 0;
        for (Cardinal c : this.exits) {
            i |= 1 << c.ordinal();
        }
        tag.func_74774_a("Exits", (byte)i);
        tag.func_74774_a("Type", (byte)this.type.ordinal());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.exits.clear();
        int exitsSet = nbt.func_74771_c("Exits") & 0xFF;
        for (Cardinal c : Cardinal.values()) {
            if ((exitsSet & 1 << c.ordinal()) == 0) continue;
            this.exits.add(c);
        }
        this.type = TileType.values()[nbt.func_74762_e("Type")];
    }

    public static enum TileType {
        HALLWAY(65280),
        ROOM(255),
        ENTRANCE(0xFFFF88),
        EXIT(0xFF00FF);

        public final int color;

        private TileType(int color) {
            this.color = color;
        }
    }
}

