/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.hallways;

import io.github.elytra.copo.math.Vec2i;
import io.github.elytra.hallways.Cardinal;
import io.github.elytra.hallways.DungeonTile;
import io.github.elytra.hallways.HallwayGenerator$$Lambda$1;
import io.github.elytra.hallways.HallwayGenerator$$Lambda$2;
import io.github.elytra.hallways.HallwayGenerator$$Lambda$3;
import io.github.elytra.hallways.HallwayGenerator$$Lambda$4;
import io.github.elytra.hallways.VectorField;
import io.github.elytra.hallways.VectorPanel;
import java.util.Random;
import javax.swing.JFrame;

public class HallwayGenerator {
    private static Random defaultRandom = new Random();

    public static void main(String ... args) {
        DungeonTile reserved = new DungeonTile(DungeonTile.TileType.HALLWAY);
        DungeonTile roomz = new DungeonTile(DungeonTile.TileType.ROOM);
        DungeonTile startRoom = new DungeonTile(DungeonTile.TileType.ENTRANCE);
        DungeonTile goal = new DungeonTile(DungeonTile.TileType.EXIT);
        int COMPLEXITY_IDEAL = 40;
        VectorField<DungeonTile> selected = null;
        int highestComplexity = 0;
        int evaluated = 0;
        for (int i = 0; i < 40; ++i) {
            ++evaluated;
            VectorField<DungeonTile> field = new VectorField<DungeonTile>(64, 64);
            int complexity = HallwayGenerator.generateInto(field, reserved, roomz, startRoom, goal);
            if (selected == null || highestComplexity < complexity) {
                selected = field;
                highestComplexity = complexity;
            }
            field.getTag().func_74768_a("complexity", complexity);
            if (complexity <= 40) continue;
        }
        System.out.println("" + evaluated + " plans evaluated, yielding a final complexity of " + highestComplexity);
        JFrame main = new JFrame("Hallway Simulator 20XX");
        main.add(new VectorPanel(selected, 16));
        main.setDefaultCloseOperation(3);
        main.pack();
        main.setVisible(true);
    }

    public static int generateInto(VectorField<DungeonTile> field, DungeonTile hallTemplate, DungeonTile roomTemplate, DungeonTile startRoom, DungeonTile goal) {
        return HallwayGenerator.generateInto(defaultRandom, field, hallTemplate, roomTemplate, startRoom, goal);
    }

    public static int generateInto(long seed, VectorField<DungeonTile> field, DungeonTile hallTemplate, DungeonTile roomTemplate, DungeonTile startRoom, DungeonTile goal) {
        return HallwayGenerator.generateInto(new Random(seed), field, hallTemplate, roomTemplate, startRoom, goal);
    }

    public static int generateInto(Random rand, VectorField<DungeonTile> field, DungeonTile hallTemplate, DungeonTile roomTemplate, DungeonTile startRoom, DungeonTile goal) {
        int complexity = 1;
        Vec2i curNode = new Vec2i(10, 10);
        Cardinal curDirection = Cardinal.NORTH;
        Vec2i initialRoom = HallwayGenerator.genRoom(rand, field, curNode.x, curNode.y, 2, 5, startRoom, 5);
        if (initialRoom != null) {
            curDirection = Cardinal.fromTo(curNode, initialRoom).cw().cw();
            curNode = initialRoom;
        }
        for (int i = 0; i < 120; ++i) {
            Vec2i next;
            Vec2i deadEnd;
            if (rand.nextInt(8) == 0 && (deadEnd = HallwayGenerator.genHall(rand, field, curNode.x, curNode.y, 2, 8, hallTemplate, roomTemplate, 5)) != null) {
                complexity += 2;
                HallwayGenerator.genHall(rand, field, deadEnd.x, deadEnd.y, 2, 8, hallTemplate, roomTemplate, 5);
            }
            if ((next = HallwayGenerator.genHall(rand, field, curNode.x, curNode.y, 2, 6, hallTemplate, roomTemplate, 5)) == null) continue;
            Cardinal newDirection = Cardinal.fromTo(curNode, next);
            if (newDirection != curDirection) {
                ++complexity;
            }
            curDirection = newDirection;
            curNode = next;
            field.put(curNode.x, curNode.y, null);
            next = HallwayGenerator.genRoom(rand, field, curNode.x, curNode.y, 2, 5, roomTemplate, 5);
            if (next != null) {
                curDirection = Cardinal.fromTo(curNode, next).cw().cw();
                curNode = next;
                ++complexity;
                continue;
            }
            field.put(curNode.x, curNode.y, roomTemplate);
        }
        if (!field.isInBounds(curNode.x, curNode.y)) {
            return 0;
        }
        field.put(curNode.x, curNode.y, goal);
        HallwayGenerator.genRoom(rand, field, curNode.x, curNode.y, 2, 5, goal, 5);
        return complexity;
    }

    public static Vec2i spitball(Random rand, VectorField<DungeonTile> dungeon, int x, int y, int minLength, int maxLength, DungeonTile hall, DungeonTile node) {
        int x1 = x;
        int y1 = y;
        int x2 = x;
        int y2 = y;
        int deltaLength = maxLength - minLength;
        int dir = rand.nextInt(4);
        Cardinal flow = Cardinal.NORTH;
        int len = rand.nextInt(deltaLength) + minLength;
        switch (dir) {
            case 0: {
                x2 = ++x1 + len;
                flow = Cardinal.EAST;
                break;
            }
            case 1: {
                y2 = ++y1 + len;
                flow = Cardinal.SOUTH;
                break;
            }
            case 2: {
                x2 = --x1 - len;
                flow = Cardinal.WEST;
                break;
            }
            default: {
                y2 = --y1 - len;
                flow = Cardinal.NORTH;
            }
        }
        if (!dungeon.isInBounds(x2, y2)) {
            return null;
        }
        MutableCollisionResult collision = new MutableCollisionResult();
        dungeon.visitLine(x1, y1, x2, y2, HallwayGenerator$$Lambda$1.lambdaFactory$(collision));
        if (dungeon.get(x2, y2) != null) {
            collision.result = true;
        }
        if (collision.result) {
            return null;
        }
        DungeonTile hallModified = hall.clone();
        hallModified.setExits(flow.cw(), flow.ccw());
        dungeon.visitLine(x1, y1, x2, y2, HallwayGenerator$$Lambda$2.lambdaFactory$(hallModified));
        dungeon.put(x2, y2, node);
        return new Vec2i(x2, y2);
    }

    public static Vec2i spitballRoom(Random rand, VectorField<DungeonTile> dungeon, int x, int y, int minSize, int maxSize, DungeonTile material) {
        int sizeDelta = maxSize - minSize;
        int x1 = x;
        int y1 = y;
        int x2 = x;
        int y2 = y;
        int len = rand.nextInt(sizeDelta) + minSize;
        int breadth = len - len / 4;
        if (breadth < minSize) {
            breadth = minSize;
        }
        if (rand.nextBoolean()) {
            int tmp = len;
            len = breadth;
            breadth = tmp;
        }
        int halfBreadth = breadth / 2;
        int dir = rand.nextInt(4);
        switch (dir) {
            case 0: {
                x2 = x1 + len;
                y1 -= halfBreadth;
                y2 += halfBreadth;
                break;
            }
            case 1: {
                y2 = y1 + len;
                x1 -= halfBreadth;
                x2 += halfBreadth;
                break;
            }
            case 2: {
                x2 = x1 - len;
                y1 -= halfBreadth;
                y2 += halfBreadth;
                break;
            }
            default: {
                y2 = y1 - len;
                x1 -= halfBreadth;
                x2 += halfBreadth;
            }
        }
        if (!dungeon.isInBounds(x1, y1) || !dungeon.isInBounds(x2, y2)) {
            return null;
        }
        int width = Math.abs(x2 - x1) + 1;
        int height = Math.abs(y2 - y1) + 1;
        MutableCollisionResult collision = new MutableCollisionResult();
        dungeon.visitRect(x1, y1, width, height, HallwayGenerator$$Lambda$3.lambdaFactory$(collision));
        if (collision.result) {
            return null;
        }
        dungeon.visitRect(x1, y1, width, height, HallwayGenerator$$Lambda$4.lambdaFactory$(material));
        Vec2i result = new Vec2i(x, y);
        int dir2 = rand.nextInt(3);
        if (dir2 >= dir) {
            ++dir2;
        }
        switch (dir2) {
            case 0: {
                result.x = x1;
                result.y = y1 + height / 2 + 1;
                break;
            }
            case 1: {
                result.y = y1;
                result.x = x1 + width / 2 + 1;
                break;
            }
            case 2: {
                result.x = x2;
                result.y = y1 + height / 2 + 1;
                break;
            }
            default: {
                result.y = y2;
                result.x = x1 + width / 2 + 1;
            }
        }
        return result;
    }

    public static Vec2i genRoom(Random rand, VectorField<DungeonTile> dungeon, int x, int y, int minSize, int maxSize, DungeonTile material, int tries) {
        for (int i = 0; i < tries; ++i) {
            Vec2i result = HallwayGenerator.spitballRoom(rand, dungeon, x, y, minSize, maxSize, material);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Vec2i genHall(Random rand, VectorField<DungeonTile> dungeon, int x, int y, int minLength, int maxLength, DungeonTile hall, DungeonTile node, int tries) {
        for (int i = 0; i < tries; ++i) {
            Vec2i result = HallwayGenerator.spitball(rand, dungeon, x, y, minLength, maxLength, hall, node);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static /* synthetic */ void lambda$spitballRoom$2(MutableCollisionResult collision, VectorField field, int xi, int yi) {
        if (field.get(xi, yi) != null) {
            collision.result = true;
        }
    }

    private static /* synthetic */ void lambda$spitball$0(MutableCollisionResult collision, VectorField field, int xi, int yi) {
        if (field.get(xi, yi) != null) {
            collision.result = true;
        }
    }

    static /* synthetic */ void access$lambda$0(MutableCollisionResult mutableCollisionResult, VectorField vectorField, int n, int n2) {
        HallwayGenerator.lambda$spitball$0(mutableCollisionResult, vectorField, n, n2);
    }

    static /* synthetic */ void access$lambda$1(DungeonTile dungeonTile, VectorField vectorField, int n, int n2) {
        vectorField.put(n, n2, dungeonTile);
    }

    static /* synthetic */ void access$lambda$2(MutableCollisionResult mutableCollisionResult, VectorField vectorField, int n, int n2) {
        HallwayGenerator.lambda$spitballRoom$2(mutableCollisionResult, vectorField, n, n2);
    }

    static /* synthetic */ void access$lambda$3(DungeonTile dungeonTile, VectorField vectorField, int n, int n2) {
        vectorField.put(n, n2, dungeonTile);
    }

    private static class MutableCollisionResult {
        public boolean result = false;

        private MutableCollisionResult() {
        }
    }
}

