/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.hallways;

import io.github.elytra.hallways.CellCallable;
import net.minecraft.nbt.NBTTagCompound;

public class VectorField<T> {
    private int width = 1;
    private int height = 1;
    private T[] cells;
    private NBTTagCompound tag = null;

    public VectorField(int width, int height) {
        this.width = width;
        this.height = height;
        if (this.width < 1) {
            this.width = 1;
        }
        if (this.height < 1) {
            this.height = 1;
        }
        if (this.width > 65534) {
            this.width = 65534;
        }
        if (this.height > 65534) {
            this.height = 65534;
        }
        this.cells = new Object[width * height];
    }

    public void clear() {
        this.cells = new Object[this.width * this.height];
    }

    public void visitLine(int x1, int y1, int x2, int y2, CellCallable<T> function) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float scale = Math.max(Math.abs(dx), Math.abs(dy));
        float xstep = dx / scale;
        float ystep = dy / scale;
        int numSteps = (int)scale;
        float curX = (float)x1 + 0.5f;
        float curY = (float)y1 + 0.5f;
        for (int i = 0; i < numSteps; ++i) {
            function.call(this, (int)curX, (int)curY);
            curX += xstep;
            curY += ystep;
        }
    }

    public void visitRect(int x1, int y1, int width, int height, CellCallable<T> function) {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                function.call(this, x1 + x, y1 + y);
            }
        }
    }

    public T get(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return null;
        }
        return this.cells[y * this.width + x];
    }

    public T put(int x, int y, T t) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return null;
        }
        int index = y * this.width + x;
        T result = this.cells[index];
        this.cells[index] = t;
        return result;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isInBounds(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public NBTTagCompound getTag() {
        if (!this.hasTag()) {
            this.setTag(new NBTTagCompound());
        }
        return this.tag;
    }

    public void setTag(NBTTagCompound tag) {
        this.tag = tag;
    }
}

