/*
 * Decompiled with CFR 0.152.
 */
package io.github.elytra.hallways;

import io.github.elytra.hallways.Cardinal;
import io.github.elytra.hallways.DungeonTile;
import io.github.elytra.hallways.VectorField;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class VectorPanel
extends JPanel {
    private static final Color OOB = new Color(0.4f, 0.4f, 0.4f);
    private final VectorField<DungeonTile> dungeon;
    private int zoom;

    public VectorPanel(VectorField<DungeonTile> dungeon, int zoom) {
        this.dungeon = dungeon;
        this.zoom = zoom;
        Dimension actualSize = new Dimension(dungeon.getWidth() * zoom, dungeon.getHeight() * zoom);
        this.setMinimumSize(actualSize);
        this.setPreferredSize(actualSize);
        this.setMaximumSize(actualSize);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(OOB);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int y = 0; y < this.dungeon.getHeight(); ++y) {
            for (int x = 0; x < this.dungeon.getWidth(); ++x) {
                DungeonTile tile = this.dungeon.get(x, y);
                if (tile == null) continue;
                g.setColor(new Color(tile.type.color));
                g.fillRect(x * this.zoom, y * this.zoom, this.zoom, this.zoom);
                g.setColor(new Color(tile.type.color).darker());
                if (tile.exits().contains((Object)Cardinal.WEST)) {
                    g.fillRect(x * this.zoom, y * this.zoom, 2, this.zoom);
                }
                if (tile.exits().contains((Object)Cardinal.EAST)) {
                    g.fillRect(x * this.zoom + this.zoom - 2, y * this.zoom, 2, this.zoom);
                }
                if (tile.exits().contains((Object)Cardinal.NORTH)) {
                    g.fillRect(x * this.zoom, y * this.zoom, this.zoom, 2);
                }
                if (!tile.exits().contains((Object)Cardinal.SOUTH)) continue;
                g.fillRect(x * this.zoom, y * this.zoom + this.zoom - 2, this.zoom, 2);
            }
        }
    }
}

