/*
 * Decompiled with CFR 0.152.
 */
package mods.belgabor.bitdrawers.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigManager {
    private static final String LANG_PREFIX = "bitDrawers.config.";
    public Configuration config;
    public boolean debugTrace = false;
    public int bitdrawerStorage = 16;
    public boolean allowBagMultiInsertion = true;
    public boolean allowChiseledBlockMultiInsertion = false;
    public boolean chatty = true;
    public boolean enableBitController = true;

    public ConfigManager(File config) {
        this.config = new Configuration(config);
        this.sync();
    }

    public void sync() {
        this.debugTrace = this.config.get("general", "enableDebugLogging", this.debugTrace, "Writes additional log messages while using the mod.  Mainly for debug purposes.  Should be kept disabled unless instructed otherwise.").setLanguageKey("bitDrawers.config.prop.enableDebugLogging").getBoolean();
        this.bitdrawerStorage = this.config.get("general", "bitdrawerBaseStorage", this.bitdrawerStorage, "Base storage of a bit drawer (stacks).").setRequiresWorldRestart(true).setLanguageKey("bitDrawers.config.prop.bitdrawerBaseStorage").getInt();
        this.allowBagMultiInsertion = this.config.get("general", "allowBagMultiInsertion", this.allowBagMultiInsertion, "If set the contents of all bags in a players inventory will try to be inserted on a double right-click on the bit drawer controller.").setLanguageKey("bitDrawers.config.prop.allowBagMultiInsertion").getBoolean();
        this.allowChiseledBlockMultiInsertion = this.config.get("general", "allowChiseledBlockMultiInsertion", this.allowChiseledBlockMultiInsertion, "If set all Chisels & Bits blocks in a players inventory will try to be inserted on a double right-click on the bit drawer controller.").setLanguageKey("bitDrawers.config.prop.allowChiseledBlockMultiInsertion").getBoolean();
        this.chatty = this.config.get("general", "chatty", this.chatty, "If set the player will be informed in chat if something didn't work (if possible).").setLanguageKey("bitDrawers.config.prop.chatty").getBoolean();
        this.enableBitController = this.config.get("general", "enableBitController", this.enableBitController, "Enable the bit drawer controller.").setLanguageKey("bitDrawers.config.prop.enableBitController").getBoolean();
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }
}

