/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.api.capability;

import java.util.List;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class KitchenItemProvider
implements IKitchenItemProvider {
    private IItemHandler itemHandler;
    private int[] usedStackSize;

    public KitchenItemProvider() {
    }

    public KitchenItemProvider(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
        this.usedStackSize = new int[itemHandler.getSlots()];
    }

    public void setItemHandler(IItemHandler itemHandler) {
        this.itemHandler = itemHandler;
        this.usedStackSize = new int[itemHandler.getSlots()];
    }

    @Override
    public void resetSimulation() {
        for (int i = 0; i < this.usedStackSize.length; ++i) {
            this.usedStackSize[i] = 0;
        }
    }

    @Override
    public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        ItemStack itemStack = this.itemHandler.getStackInSlot(slot);
        if (itemStack.field_77994_a - (simulate ? this.usedStackSize[slot] : 0) >= amount) {
            ItemStack result = this.itemHandler.extractItem(slot, amount, simulate);
            if (simulate && result != null) {
                int n = slot;
                this.usedStackSize[n] = this.usedStackSize[n] + result.field_77994_a;
            }
            return result;
        }
        return null;
    }

    @Override
    public ItemStack returnItemStack(ItemStack itemStack) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)itemStack, (boolean)false);
    }

    @Override
    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }
}

