/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.api.ToastErrorHandler;
import net.blay09.mods.cookingforblockheads.api.ToastHandler;
import net.blay09.mods.cookingforblockheads.api.ToastOutputHandler;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.TileToaster;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockToaster
extends BlockKitchen {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.275, 0.0, 0.275, 0.725, 0.4, 0.725);

    public BlockToaster() {
        super(Material.field_151573_f);
        this.setRegistryName("cookingforblockheads", "toaster");
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(2.5f);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileToaster) {
            TileToaster tileToaster = (TileToaster)tileEntity;
            if (heldItem == null || tileToaster.getItemHandler().getStackInSlot(0) != null && tileToaster.getItemHandler().getStackInSlot(1) != null) {
                if (!(tileToaster.isActive() || tileToaster.getItemHandler().getStackInSlot(0) == null && tileToaster.getItemHandler().getStackInSlot(1) == null)) {
                    tileToaster.setActive(!tileToaster.isActive());
                }
            } else {
                ToastHandler toastHandler = CookingRegistry.getToastHandler(heldItem);
                if (toastHandler != null) {
                    ItemStack output;
                    ItemStack itemStack = output = toastHandler instanceof ToastOutputHandler ? ((ToastOutputHandler)toastHandler).getToasterOutput(heldItem) : null;
                    if (output != null) {
                        for (int i = 0; i < tileToaster.getItemHandler().getSlots(); ++i) {
                            if (tileToaster.getItemHandler().getStackInSlot(i) != null) continue;
                            tileToaster.getItemHandler().setStackInSlot(i, heldItem.func_77979_a(1));
                            return true;
                        }
                        return true;
                    }
                    if (!world.field_72995_K && toastHandler instanceof ToastErrorHandler) {
                        player.func_146105_b(((ToastErrorHandler)toastHandler).getToasterHint(player, heldItem));
                    }
                }
            }
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileToaster();
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        for (String s : I18n.func_135052_a((String)("tooltip." + this.getRegistryName() + ".description"), (Object[])new Object[0]).split("\\\\n")) {
            tooltip.add(TextFormatting.GRAY + s);
        }
    }
}

