/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.cookingforblockheads.api.CookingForBlockheadsAPI;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SimpleAddon {
    private final String modId;
    private final List<String> additionalRecipes = Lists.newArrayList();

    public SimpleAddon(String modId) {
        this.modId = modId;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onFoodRegistryInit(FoodRegistryInitEvent event) {
        for (String s : this.additionalRecipes) {
            ItemStack itemStack = this.getModItemStack(s);
            if (itemStack == null) continue;
            event.registerNonFoodRecipe(itemStack);
        }
    }

    public void addNonFoodRecipe(String ... names) {
        Collections.addAll(this.additionalRecipes, names);
    }

    public void addTool(String ... names) {
        for (String name : names) {
            ItemStack toolItem = this.getModItemStack(name);
            if (toolItem == null) continue;
            CookingForBlockheadsAPI.addToolItem(toolItem);
        }
    }

    public ItemStack getModItemStack(String name) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.modId, name));
        return item != null ? new ItemStack(item) : null;
    }
}

