/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import xreliquary.Reliquary;
import xreliquary.blocks.BlockBase;
import xreliquary.blocks.tile.TileEntityPedestalPassive;
import xreliquary.init.ModBlocks;
import xreliquary.util.InventoryHelper;

public class BlockPedestalPassive
extends BlockBase {
    static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final AxisAlignedBB PEDESTAL_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.6875, 0.875);

    public BlockPedestalPassive() {
        super(Material.field_151576_e, "pedestal_passive");
        this.func_149647_a(Reliquary.CREATIVE_TAB);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 16; ++i) {
            list.add(new ItemStack((Block)ModBlocks.pedestalPassive, 1, i));
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumDyeColor color = EnumDyeColor.RED;
        if (worldIn.func_175625_s(pos) instanceof TileEntityPedestalPassive) {
            TileEntityPedestalPassive pedestal = (TileEntityPedestalPassive)worldIn.func_175625_s(pos);
            color = pedestal.getClothColor();
        }
        return state.func_177226_a(COLOR, (Comparable)color);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int meta = 0;
        if (world.func_175625_s(pos) instanceof TileEntityPedestalPassive) {
            TileEntityPedestalPassive pedestal = (TileEntityPedestalPassive)world.func_175625_s(pos);
            meta = pedestal.getClothColor().func_176765_a();
        }
        return new ItemStack(Item.func_150898_a((Block)this), 1, meta);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Item item = this.func_180660_a(state, ((World)world).field_73012_v, fortune);
        int meta = 0;
        if (world.func_175625_s(pos) instanceof TileEntityPedestalPassive) {
            TileEntityPedestalPassive pedestal = (TileEntityPedestalPassive)world.func_175625_s(pos);
            meta = pedestal.getClothColor().func_176765_a();
        }
        list.add(new ItemStack(item, 1, meta));
        return list;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta & 3));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, COLOR});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.func_175625_s(pos) instanceof TileEntityPedestalPassive) {
            TileEntityPedestalPassive pedestal = (TileEntityPedestalPassive)worldIn.func_175625_s(pos);
            pedestal.setColor((EnumDyeColor)state.func_177229_b(COLOR));
        }
    }

    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return player.func_184586_b(hand) != null || player.func_70093_af();
        }
        if (!(world.func_175625_s(pos) instanceof TileEntityPedestalPassive)) {
            return false;
        }
        TileEntityPedestalPassive pedestal = (TileEntityPedestalPassive)world.func_175625_s(pos);
        if (heldItem == null) {
            if (player.func_70093_af()) {
                pedestal.removeLastPedestalStack();
                return true;
            }
            return false;
        }
        return InventoryHelper.tryAddingPlayerCurrentItem(player, pedestal, EnumHand.MAIN_HAND);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityPedestalPassive pedestal = (TileEntityPedestalPassive)world.func_175625_s(pos);
        if (pedestal != null) {
            pedestal.dropPedestalInventory();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityPedestalPassive();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PEDESTAL_AABB;
    }
}

