/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.blocks.tile.TileEntityMortar;
import xreliquary.blocks.tile.TileEntityPedestal;
import xreliquary.blocks.tile.TileEntityPedestalPassive;
import xreliquary.client.init.ItemBlockModels;
import xreliquary.client.init.ItemModels;
import xreliquary.client.init.ModBlockColors;
import xreliquary.client.init.ModItemColors;
import xreliquary.client.registry.PedestalClientRegistry;
import xreliquary.client.render.MobCharmBeltLayerRenderer;
import xreliquary.client.render.RenderApothecaryMortar;
import xreliquary.client.render.RenderPedestalFishHook;
import xreliquary.client.render.RenderShot;
import xreliquary.client.render.RenderThrownKrakenSlime;
import xreliquary.client.render.RenderThrownXRPotion;
import xreliquary.client.render.RenderXRTippedArrow;
import xreliquary.client.render.TileEntityPedestalPassiveRenderer;
import xreliquary.client.render.TileEntityPedestalRenderer;
import xreliquary.common.CommonProxy;
import xreliquary.compat.jei.descriptions.JEIDescriptionRegistry;
import xreliquary.entities.EntityEnderStaffProjectile;
import xreliquary.entities.EntityGlowingWater;
import xreliquary.entities.EntityHolyHandGrenade;
import xreliquary.entities.EntityKrakenSlime;
import xreliquary.entities.EntitySpecialSnowball;
import xreliquary.entities.EntityXRTippedArrow;
import xreliquary.entities.potion.EntityAttractionPotion;
import xreliquary.entities.potion.EntityFertilePotion;
import xreliquary.entities.potion.EntityThrownXRPotion;
import xreliquary.entities.shot.EntityBlazeShot;
import xreliquary.entities.shot.EntityBusterShot;
import xreliquary.entities.shot.EntityConcussiveShot;
import xreliquary.entities.shot.EntityEnderShot;
import xreliquary.entities.shot.EntityExorcismShot;
import xreliquary.entities.shot.EntityNeutralShot;
import xreliquary.entities.shot.EntitySandShot;
import xreliquary.entities.shot.EntitySeekerShot;
import xreliquary.entities.shot.EntityStormShot;
import xreliquary.handler.ClientEventHandler;
import xreliquary.init.ModFluids;
import xreliquary.init.ModItems;
import xreliquary.reference.Settings;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.potions.PotionEssence;
import xreliquary.util.potions.XRPotionHelper;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void registerJEI(Block block, String name) {
        this.registerJEI(block, name, false);
    }

    @Override
    public void registerJEI(Block block, String name, boolean oneDescription) {
        if (Loader.isModLoaded((String)"JEI")) {
            if (oneDescription) {
                ArrayList<ItemStack> subBlocks = new ArrayList<ItemStack>();
                block.func_149666_a(Item.func_150898_a((Block)block), null, subBlocks);
                JEIDescriptionRegistry.register(subBlocks, name);
            } else {
                JEIDescriptionRegistry.register(Item.func_150898_a((Block)block), name);
            }
        }
    }

    @Override
    public void initSpecialJEIDescriptions() {
        if (!Loader.isModLoaded((String)"JEI")) {
            return;
        }
        ArrayList<ItemStack> subItems = new ArrayList<ItemStack>();
        ModItems.potionEssence.func_150895_a(ModItems.potionEssence, ModItems.potionEssence.func_77640_w(), subItems);
        JEIDescriptionRegistry.register(subItems, "potion_essence");
        JEIDescriptionRegistry.register(Collections.singletonList(new ItemStack((Item)ModItems.potion)), "potion0");
        ArrayList<ItemStack> potions = new ArrayList<ItemStack>();
        ArrayList<ItemStack> splashPotions = new ArrayList<ItemStack>();
        ArrayList<ItemStack> lingeringPotions = new ArrayList<ItemStack>();
        ArrayList<ItemStack> tippedArrows = new ArrayList<ItemStack>();
        ArrayList<ItemStack> potionShots = new ArrayList<ItemStack>();
        ArrayList<ItemStack> potionMagazines = new ArrayList<ItemStack>();
        for (PotionEssence essence : Settings.Potions.uniquePotions) {
            ItemStack potion = new ItemStack((Item)ModItems.potion, 1);
            potion.func_77982_d(essence.writeToNBT());
            NBTHelper.setBoolean("hasPotion", potion, true);
            potions.add(potion);
            ItemStack splashPotion = potion.func_77946_l();
            NBTHelper.setBoolean("splash", splashPotion, true);
            splashPotions.add(splashPotion);
            ItemStack lingeringPotion = potion.func_77946_l();
            NBTHelper.setBoolean("lingering", lingeringPotion, true);
            lingeringPotions.add(lingeringPotion);
            ItemStack tippedArrow = new ItemStack((Item)ModItems.tippedArrow);
            PotionUtils.func_185184_a((ItemStack)tippedArrow, XRPotionHelper.changeDuration(essence.getEffects(), 0.125f));
            tippedArrows.add(tippedArrow);
            ItemStack potionShot = new ItemStack((Item)ModItems.bullet, 1, 1);
            PotionUtils.func_185184_a((ItemStack)potionShot, XRPotionHelper.changeDuration(essence.getEffects(), 0.2f));
            potionShots.add(potionShot);
            ItemStack potionMagazine = new ItemStack((Item)ModItems.magazine, 1, 1);
            PotionUtils.func_185184_a((ItemStack)potionMagazine, XRPotionHelper.changeDuration(essence.getEffects(), 0.2f));
            potionMagazines.add(potionMagazine);
        }
        JEIDescriptionRegistry.register(potions, "potion");
        JEIDescriptionRegistry.register(splashPotions, "potion_splash");
        JEIDescriptionRegistry.register(lingeringPotions, "potion_lingering");
        JEIDescriptionRegistry.register(tippedArrows, "tipped_arrow");
        JEIDescriptionRegistry.register(potionShots, "bullet1_potion");
        JEIDescriptionRegistry.register(potionMagazines, "magazine1_potion");
        ArrayList<ItemStack> mobCharms = new ArrayList<ItemStack>();
        ModItems.mobCharm.func_150895_a(ModItems.mobCharm, Reliquary.CREATIVE_TAB, mobCharms);
        int meta = 0;
        for (ItemStack mobCharm : mobCharms) {
            JEIDescriptionRegistry.register(Collections.singletonList(mobCharm), "mob_charm" + meta);
            ++meta;
        }
    }

    @Override
    public void registerJEI(Item item, String name) {
        if (Loader.isModLoaded((String)"JEI")) {
            JEIDescriptionRegistry.register(item, name);
        }
    }

    @Override
    public void preInit() {
        super.preInit();
        ItemBlockModels.registerItemBlockModels();
        ItemModels.registerItemModels();
        this.registerEntityRenderers();
    }

    private void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityBlazeShot.class, RenderShot::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBusterShot.class, RenderShot::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityConcussiveShot.class, RenderShot::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderShot.class, RenderShot::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityExorcismShot.class, RenderShot::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityNeutralShot.class, RenderShot::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySeekerShot.class, RenderShot::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySandShot.class, RenderShot::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityStormShot.class, RenderShot::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityXRTippedArrow.class, RenderXRTippedArrow::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityGlowingWater.class, renderManager -> new RenderSnowball(renderManager, (Item)ModItems.glowingWater, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityAttractionPotion.class, renderManager -> new RenderSnowball(renderManager, (Item)ModItems.attractionPotion, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityFertilePotion.class, renderManager -> new RenderSnowball(renderManager, (Item)ModItems.fertilePotion, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityHolyHandGrenade.class, renderManager -> new RenderSnowball(renderManager, (Item)ModItems.holyHandGrenade, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityKrakenSlime.class, RenderThrownKrakenSlime::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpecialSnowball.class, renderManager -> new RenderSnowball(renderManager, Items.field_151126_ay, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderStaffProjectile.class, renderManager -> new RenderSnowball(renderManager, Items.field_151079_bi, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityThrownXRPotion.class, renderManager -> new RenderThrownXRPotion(renderManager, Minecraft.func_71410_x().func_175599_af()));
    }

    @Override
    public void init() {
        super.init();
        ModItemColors.init();
        ModBlockColors.init();
        this.RegisterBeltRender();
        FMLCommonHandler.instance().bus().register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ModFluids());
        this.registerRenderers();
    }

    @Override
    public void postInit() {
        super.postInit();
        PedestalClientRegistry.registerItemRenderer(ItemFishingRod.class, RenderPedestalFishHook.class);
    }

    private void RegisterBeltRender() {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        RenderPlayer render = (RenderPlayer)skinMap.get("default");
        render.func_177094_a((LayerRenderer)new MobCharmBeltLayerRenderer());
    }

    private void registerRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMortar.class, (TileEntitySpecialRenderer)new RenderApothecaryMortar());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPedestal.class, (TileEntitySpecialRenderer)new TileEntityPedestalRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPedestalPassive.class, (TileEntitySpecialRenderer)new TileEntityPedestalPassiveRenderer());
    }

    @Override
    public void initColors() {
        LanguageHelper.globals.put("colors.black", "\u00a70");
        LanguageHelper.globals.put("colors.navy", "\u00a71");
        LanguageHelper.globals.put("colors.green", "\u00a72");
        LanguageHelper.globals.put("colors.blue", "\u00a73");
        LanguageHelper.globals.put("colors.red", "\u00a74");
        LanguageHelper.globals.put("colors.purple", "\u00a75");
        LanguageHelper.globals.put("colors.gold", "\u00a76");
        LanguageHelper.globals.put("colors.light_gray", "\u00a77");
        LanguageHelper.globals.put("colors.gray", "\u00a78");
        LanguageHelper.globals.put("colors.dark_purple", "\u00a79");
        LanguageHelper.globals.put("colors.light_green", "\u00a7a");
        LanguageHelper.globals.put("colors.light_blue", "\u00a7b");
        LanguageHelper.globals.put("colors.rose", "\u00a7c");
        LanguageHelper.globals.put("colors.light_purple", "\u00a7d");
        LanguageHelper.globals.put("colors.yellow", "\u00a7e");
        LanguageHelper.globals.put("colors.white", "\u00a7f");
        LanguageHelper.globals.put("colors.reset", TextFormatting.RESET.toString());
    }
}

