/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.jei.cauldron;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import xreliquary.compat.jei.cauldron.CauldronRecipeJEI;
import xreliquary.init.ModBlocks;
import xreliquary.reference.Reference;
import xreliquary.util.LanguageHelper;

public class CauldronRecipeCategory
implements IRecipeCategory {
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int CAULDRON_SLOT = 3;
    private static final int FIRST_ADDITIONAL_SLOT = 4;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final String localizedName;

    public CauldronRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation(Reference.DOMAIN + "textures/gui/jei/cauldron.png"), 0, 0, 107, 51);
        this.localizedName = LanguageHelper.getLocalization("jei.recipe.cauldron");
    }

    @Nonnull
    public String getUid() {
        return Reference.JEI_CATEGORY_CAULDRON;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
    }

    public void drawAnimations(Minecraft minecraft) {
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        recipeLayout.getItemStacks().init(0, true, 0, 33);
        recipeLayout.getItemStacks().init(1, false, 90, 33);
        recipeLayout.getItemStacks().init(3, false, 44, 33);
        if (recipeWrapper instanceof CauldronRecipeJEI) {
            CauldronRecipeJEI cauldronWrapper = (CauldronRecipeJEI)recipeWrapper;
            this.initAdditionalSlots(recipeLayout, cauldronWrapper.getInputs().size());
            recipeLayout.getItemStacks().set(0, (ItemStack)cauldronWrapper.getInputs().get(0));
            recipeLayout.getItemStacks().set(1, (ItemStack)cauldronWrapper.getOutputs().get(0));
            recipeLayout.getItemStacks().set(3, new ItemStack((Block)ModBlocks.apothecaryCauldron, 1));
            this.setAdditionalSlotContents(recipeLayout, cauldronWrapper.getInputs());
        }
    }

    private void setAdditionalSlotContents(IRecipeLayout recipeLayout, List inputs) {
        for (int i = 1; i < inputs.size(); ++i) {
            recipeLayout.getItemStacks().set(i - 1 + 4, (ItemStack)inputs.get(i));
        }
    }

    private void initAdditionalSlots(IRecipeLayout recipeLayout, int inputCount) {
        int left = 44 - (inputCount - 2) * 9;
        for (int i = 0; i < inputCount; ++i) {
            recipeLayout.getItemStacks().init(4 + i, false, left + i * 18, 0);
        }
    }
}

