/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import xreliquary.Reliquary;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;

public class ItemMidasTouchstone
extends ItemToggleable {
    public ItemMidasTouchstone() {
        super("midas_touchstone");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77625_d(1);
        this.canRepair = false;
    }

    @Override
    public void func_77624_a(ItemStack ist, EntityPlayer player, List<String> list, boolean par4) {
        if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
            return;
        }
        this.formatTooltip((ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)Integer.toString(NBTHelper.getInteger("glowstone", ist))), ist, list);
        if (this.isEnabled(ist)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.YELLOW + Items.field_151114_aO.func_77653_i(new ItemStack(Items.field_151114_aO)))), list);
        }
        LanguageHelper.formatTooltip("tooltip.absorb", null, list);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean f) {
        if (world.field_72995_K) {
            return;
        }
        if (!(e instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)e;
        if (this.isEnabled(ist) && NBTHelper.getInteger("glowstone", ist) + this.getGlowStoneWorth() <= this.getGlowstoneLimit() && InventoryHelper.consumeItem(new ItemStack(Items.field_151114_aO), player)) {
            NBTHelper.setInteger("glowstone", ist, NBTHelper.getInteger("glowstone", ist) + this.getGlowStoneWorth());
        }
        if (world.func_72820_D() % 4L == 0L) {
            this.doRepairAndDamageTouchstone(ist, player);
        }
    }

    private void doRepairAndDamageTouchstone(ItemStack ist, EntityPlayer player) {
        int slot;
        List<String> goldItems = Settings.MidasTouchstone.goldItems;
        for (slot = 0; slot < player.field_71071_by.field_70460_b.length; ++slot) {
            ItemArmor armor;
            if (player.field_71071_by.field_70460_b[slot] == null || !(player.field_71071_by.field_70460_b[slot].func_77973_b() instanceof ItemArmor) || (armor = (ItemArmor)player.field_71071_by.field_70460_b[slot].func_77973_b()).func_82812_d() != ItemArmor.ArmorMaterial.GOLD && !goldItems.contains(RegistryHelper.getItemRegistryName((Item)armor)) || player.field_71071_by.field_70460_b[slot].func_77952_i() <= 0 || !this.decrementTouchStoneCharge(ist, player)) continue;
            player.field_71071_by.field_70460_b[slot].func_77964_b(player.field_71071_by.field_70460_b[slot].func_77952_i() - 1);
        }
        for (slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null) continue;
            if (player.field_71071_by.field_70462_a[slot].func_77973_b() instanceof ItemSword) {
                ItemSword sword = (ItemSword)player.field_71071_by.field_70462_a[slot].func_77973_b();
                if (!Item.ToolMaterial.GOLD.name().equals(sword.func_150932_j()) && !goldItems.contains(RegistryHelper.getItemRegistryName((Item)sword)) || player.field_71071_by.field_70462_a[slot].func_77952_i() <= 0 || !this.decrementTouchStoneCharge(ist, player)) continue;
                player.field_71071_by.field_70462_a[slot].func_77964_b(player.field_71071_by.field_70462_a[slot].func_77952_i() - 1);
                continue;
            }
            if (player.field_71071_by.field_70462_a[slot].func_77973_b() instanceof ItemTool) {
                ItemTool tool = (ItemTool)player.field_71071_by.field_70462_a[slot].func_77973_b();
                if (!Item.ToolMaterial.GOLD.name().equals(tool.func_77861_e()) && !goldItems.contains(RegistryHelper.getItemRegistryName((Item)tool)) || player.field_71071_by.field_70462_a[slot].func_77952_i() <= 0 || !this.decrementTouchStoneCharge(ist, player)) continue;
                player.field_71071_by.field_70462_a[slot].func_77964_b(player.field_71071_by.field_70462_a[slot].func_77952_i() - 1);
                continue;
            }
            Item item = player.field_71071_by.field_70462_a[slot].func_77973_b();
            if (!goldItems.contains(RegistryHelper.getItemRegistryName(item)) || player.field_71071_by.field_70462_a[slot].func_77952_i() <= 0 || !item.func_77645_m() || !this.decrementTouchStoneCharge(ist, player)) continue;
            player.field_71071_by.field_70462_a[slot].func_77964_b(player.field_71071_by.field_70462_a[slot].func_77952_i() - 1);
        }
    }

    private boolean decrementTouchStoneCharge(ItemStack ist, EntityPlayer player) {
        if (NBTHelper.getInteger("glowstone", ist) - this.getGlowStoneCost() >= 0 || player.field_71075_bZ.field_75098_d) {
            if (!player.field_71075_bZ.field_75098_d) {
                NBTHelper.setInteger("glowstone", ist, NBTHelper.getInteger("glowstone", ist) - this.getGlowStoneCost());
            }
            return true;
        }
        return false;
    }

    private int getGlowStoneCost() {
        return Settings.MidasTouchstone.glowstoneCost;
    }

    private int getGlowStoneWorth() {
        return Settings.MidasTouchstone.glowstoneWorth;
    }

    private int getGlowstoneLimit() {
        return Settings.MidasTouchstone.glowstoneLimit;
    }
}

