/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModItems;
import xreliquary.items.ItemToggleable;
import xreliquary.items.util.FilteredItemStackHandler;
import xreliquary.items.util.VoidTearItemStackHandler;
import xreliquary.network.PacketHandler;
import xreliquary.network.PacketItemHandlerSync;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.StackHelper;

public class ItemVoidTear
extends ItemToggleable {
    public ItemVoidTear() {
        super("void_tear");
        this.func_77625_d(1);
        this.canRepair = false;
        this.func_77637_a(null);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            VoidTearItemStackHandler itemHandler = new VoidTearItemStackHandler();

            public NBTTagCompound serializeNBT() {
                return this.itemHandler.serializeNBT();
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                this.itemHandler.deserializeNBT(nbt);
            }

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return (T)this.itemHandler;
                }
                return null;
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean par4) {
        this.formatTooltip(null, stack, list);
        ItemStack contents = this.getContainedItem(stack);
        if (contents == null) {
            return;
        }
        if (this.isEnabled(stack)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.YELLOW + contents.func_82833_r())), list);
            list.add(LanguageHelper.getLocalization("tooltip.absorb_tear"));
        }
        LanguageHelper.formatTooltip("tooltip.tear_quantity", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)contents.func_82833_r(), (Object)"amount", (Object)Integer.toString(this.getItemQuantity(stack))), list);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack ist, World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            if (this.getItemQuantity(ist) == 0) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)ModItems.emptyVoidTear, 1, 0));
            }
            RayTraceResult movingObjectPosition = this.func_77621_a(world, player, false);
            if (movingObjectPosition != null && movingObjectPosition.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175625_s(movingObjectPosition.func_178782_a()) instanceof IInventory && player.func_70093_af()) {
                return new ActionResult(EnumActionResult.PASS, (Object)ist);
            }
            if (player.func_70093_af()) {
                return super.func_77659_a(ist, world, player, hand);
            }
            if (this.attemptToEmptyIntoInventory(ist, player, (IInventory)player.field_71071_by)) {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187607_bg, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
                NBTHelper.resetTag(ist);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)ModItems.emptyVoidTear, 1, 0));
            }
        }
        player.field_71069_bz.func_75142_b();
        return new ActionResult(EnumActionResult.PASS, (Object)ist);
    }

    public void func_77663_a(ItemStack voidTear, World world, Entity entity, int slotNumber, boolean isSelected) {
        if (voidTear.func_77978_p().func_74764_b("item")) {
            this.setItemStack(voidTear, ItemStack.func_77949_a((NBTTagCompound)NBTHelper.getTagCompound("item", voidTear)));
            this.setItemQuantity(voidTear, NBTHelper.getInteger("itemQuantity", voidTear));
            voidTear.func_77978_p().func_82580_o("item");
            voidTear.func_77978_p().func_82580_o("itemQuantity");
        }
        if (!world.field_72995_K) {
            ItemStack contents;
            if (!(entity instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entity;
            boolean quantityUpdated = false;
            if (this.isEnabled(voidTear) && (contents = this.getContainedItem(voidTear)) != null) {
                int itemQuantity = InventoryHelper.getItemQuantity(contents, (IInventory)player.field_71071_by);
                if (this.getItemQuantity(voidTear) < Settings.VoidTear.itemLimit && itemQuantity > contents.func_77976_d() && InventoryHelper.consumeItem(contents, player, contents.func_77976_d(), itemQuantity - contents.func_77976_d()) && !player.field_71075_bZ.field_75098_d) {
                    this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) + itemQuantity - contents.func_77976_d());
                    quantityUpdated = true;
                }
                if (this.attemptToReplenishSingleStack(player, voidTear)) {
                    quantityUpdated = true;
                }
            }
            if (player.field_71071_by.func_70301_a(slotNumber) != null && player.field_71071_by.func_70301_a(slotNumber).func_77973_b() == ModItems.filledVoidTear && (isSelected || quantityUpdated)) {
                PacketHandler.networkWrapper.sendTo((IMessage)new PacketItemHandlerSync(slotNumber, this.getItemHandlerNBT(voidTear)), (EntityPlayerMP)player);
            } else if (player.field_71071_by.field_184439_c[0] != null && player.field_71071_by.field_184439_c[0].func_77973_b() == ModItems.filledVoidTear) {
                PacketHandler.networkWrapper.sendTo((IMessage)new PacketItemHandlerSync(EnumHand.OFF_HAND, this.getItemHandlerNBT(voidTear)), (EntityPlayerMP)player);
            }
        }
    }

    private NBTTagCompound getItemHandlerNBT(ItemStack ist) {
        IItemHandler itemHandler = (IItemHandler)ist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return null;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        return filteredHandler.serializeNBT();
    }

    public boolean attemptToReplenishSingleStack(EntityPlayer player, ItemStack voidTear) {
        int preferredSlot = -1;
        int stackCount = 0;
        InventoryPlayer inventory = player.field_71071_by;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stackFound = inventory.func_70301_a(slot);
            if (stackFound == null || !StackHelper.isItemAndNbtEqual(stackFound, this.getContainedItem(voidTear))) continue;
            if (preferredSlot == -1) {
                preferredSlot = slot;
            }
            ++stackCount;
        }
        if (preferredSlot == -1 && (preferredSlot = player.field_71071_by.func_70447_i()) > -1) {
            stackCount = 1;
        }
        if (stackCount == 1 && preferredSlot != -1 && this.getItemQuantity(voidTear) > 1) {
            ItemStack stackToIncrease = player.field_71071_by.func_70301_a(preferredSlot);
            if (stackToIncrease == null) {
                int quantityToDecrease;
                ItemStack newStack = this.getContainedItem(voidTear).func_77946_l();
                newStack.field_77994_a = quantityToDecrease = Math.min(newStack.func_77976_d(), this.getItemQuantity(voidTear) - 1);
                player.field_71071_by.func_70299_a(preferredSlot, newStack);
                this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - quantityToDecrease);
                return true;
            }
            if (stackToIncrease.field_77994_a < stackToIncrease.func_77976_d()) {
                int quantityToDecrease = Math.min(stackToIncrease.func_77976_d() - stackToIncrease.field_77994_a, this.getItemQuantity(voidTear) - 1);
                stackToIncrease.field_77994_a += quantityToDecrease;
                this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - quantityToDecrease);
                return true;
            }
        }
        return false;
    }

    public EnumActionResult onItemUseFirst(ItemStack ist, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.func_180495_p(pos).func_177230_c() == ModBlocks.pedestal) {
            return EnumActionResult.PASS;
        }
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof IInventory) {
            IInventory inventory = (IInventory)world.func_175625_s(pos);
            if (inventory instanceof TileEntityChest && world.func_180495_p(pos).func_177230_c() instanceof BlockChest) {
                inventory = ((BlockChest)world.func_180495_p(pos).func_177230_c()).func_180676_d(world, pos);
            }
            if (this.isEnabled(ist)) {
                this.drainInventory(ist, player, inventory);
            } else {
                this.attemptToEmptyIntoInventory(ist, player, inventory);
                if (!player.func_70093_af() && this.getItemQuantity(ist) <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack((Item)ModItems.emptyVoidTear, 1, 0));
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    protected boolean attemptToEmptyIntoInventory(ItemStack ist, EntityPlayer player, IInventory inventory) {
        ItemStack contents = this.getContainedItem(ist);
        contents.field_77994_a = 1;
        int quantity = this.getItemQuantity(ist);
        int maxNumberToEmpty = player.func_70093_af() ? quantity : Math.min(contents.func_77976_d(), quantity);
        this.setItemQuantity(ist, quantity -= InventoryHelper.tryToAddToInventory(contents, inventory, maxNumberToEmpty));
        if (quantity == 0) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187607_bg, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            return true;
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187607_bg, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
        return false;
    }

    protected void drainInventory(ItemStack ist, EntityPlayer player, IInventory inventory) {
        int quantity;
        ItemStack contents = this.getContainedItem(ist);
        int quantityDrained = InventoryHelper.tryToRemoveFromInventory(contents, inventory, Settings.VoidTear.itemLimit - (quantity = this.getItemQuantity(ist)));
        if (quantityDrained <= 0) {
            return;
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187607_bg, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.2f));
        this.setItemQuantity(ist, quantity + quantityDrained);
    }

    public ItemStack getContainedItem(ItemStack voidTear) {
        IItemHandler itemHandler = (IItemHandler)voidTear.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return null;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        ItemStack stackToReturn = null;
        if (filteredHandler.getStackInParentSlot(0) != null) {
            stackToReturn = filteredHandler.getStackInParentSlot(0).func_77946_l();
            stackToReturn.field_77994_a = filteredHandler.getTotalAmount(0);
        }
        return stackToReturn;
    }

    public void setItemStack(ItemStack voidTear, ItemStack stack) {
        IItemHandler itemHandler = (IItemHandler)voidTear.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        filteredHandler.setParentSlotStack(0, stack);
    }

    public void setItemQuantity(ItemStack voidTear, int quantity) {
        IItemHandler itemHandler = (IItemHandler)voidTear.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        filteredHandler.setTotalAmount(0, quantity);
    }

    private int getItemQuantity(ItemStack voidTear) {
        IItemHandler itemHandler = (IItemHandler)voidTear.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(itemHandler instanceof FilteredItemStackHandler)) {
            return 0;
        }
        FilteredItemStackHandler filteredHandler = (FilteredItemStackHandler)itemHandler;
        return filteredHandler.getTotalAmount(0);
    }
}

