/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xreliquary.util.RegistryHelper;
import xreliquary.util.StackHelper;

public class InventoryHelper {
    public static void spawnItemStack(World worldIn, double x, double y, double z, ItemStack stack) {
        Random rnd = new Random();
        float f = rnd.nextFloat() * 0.8f + 0.1f;
        float f1 = rnd.nextFloat() * 0.8f + 0.1f;
        float f2 = rnd.nextFloat() * 0.8f + 0.1f;
        while (stack.field_77994_a > 0) {
            int i = rnd.nextInt(21) + 10;
            if (i > stack.field_77994_a) {
                i = stack.field_77994_a;
            }
            stack.field_77994_a -= i;
            ItemStack stackToDrop = stack.func_77946_l();
            stackToDrop.field_77994_a = i;
            EntityItem entityitem = new EntityItem(worldIn, x + (double)f, y + (double)f1, z + (double)f2, stackToDrop);
            float f3 = 0.05f;
            entityitem.field_70159_w = rnd.nextGaussian() * (double)f3;
            entityitem.field_70181_x = rnd.nextGaussian() * (double)f3 + (double)0.2f;
            entityitem.field_70179_y = rnd.nextGaussian() * (double)f3;
            worldIn.func_72838_d((Entity)entityitem);
        }
    }

    public static ItemStack getTargetItem(ItemStack self, IInventory inventory, boolean disposeOfItem) {
        ItemStack targetItem = null;
        int itemQuantity = 0;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (stack == null || StackHelper.isItemAndNbtEqual(self, stack) || stack.func_77976_d() == 1 || InventoryHelper.getItemQuantity(stack, inventory) <= itemQuantity) continue;
            itemQuantity = InventoryHelper.getItemQuantity(stack, inventory);
            targetItem = stack.func_77946_l();
            if (!disposeOfItem) continue;
            inventory.func_70298_a(slot, 1);
        }
        inventory.func_70296_d();
        return targetItem;
    }

    public static int getItemQuantity(ItemStack stack, IInventory inventory) {
        return InventoryHelper.getItemQuantity(stack, inventory, 0);
    }

    private static int getItemQuantity(ItemStack stack, IInventory inventory, int limit) {
        int itemQuantity = 0;
        for (int slot = 0; slot < Math.min(inventory.func_70302_i_(), limit > 0 ? limit : inventory.func_70302_i_()); ++slot) {
            ItemStack newStack = inventory.func_70301_a(slot);
            if (newStack == null || !StackHelper.isItemAndNbtEqual(stack, newStack)) continue;
            itemQuantity += newStack.field_77994_a;
        }
        return itemQuantity;
    }

    public static boolean consumeItem(Object item, EntityPlayer player) {
        return InventoryHelper.consumeItem(new Object[]{item}, player, 0, 1);
    }

    public static boolean consumeItem(Object item, EntityPlayer player, int minCount) {
        return InventoryHelper.consumeItem(new Object[]{item}, player, minCount, 1);
    }

    public static boolean consumeItem(Object item, EntityPlayer player, int minCount, int amountDecreased) {
        return InventoryHelper.consumeItem(new Object[]{item}, player, minCount, amountDecreased);
    }

    public static boolean consumeItem(Object[] itemList, EntityPlayer player, int minCount, int amountDecreased) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (itemList.length == 0 || !(itemList[0] instanceof ItemStack) && !(itemList[0] instanceof Item) && !(itemList[0] instanceof Block)) {
            return false;
        }
        ArrayList<Integer> suggestedSlots = new ArrayList<Integer>();
        int itemCount = 0;
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.length; ++slot) {
            if (player.field_71071_by.field_70462_a[slot] == null) continue;
            ItemStack slotStack = player.field_71071_by.field_70462_a[slot];
            for (Object stack : itemList) {
                if (!(stack instanceof ItemStack && StackHelper.isItemAndNbtEqual(slotStack, (ItemStack)stack) || stack instanceof Block && RegistryHelper.itemsEqual(Item.func_150898_a((Block)((Block)stack)), slotStack.func_77973_b())) && (!(stack instanceof Item) || !RegistryHelper.itemsEqual((Item)stack, slotStack.func_77973_b()))) continue;
                itemCount += player.field_71071_by.field_70462_a[slot].field_77994_a;
                suggestedSlots.add(slot);
            }
        }
        int count = amountDecreased;
        if (suggestedSlots.size() > 0 && itemCount >= minCount + amountDecreased) {
            Iterator iterator = suggestedSlots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                int stackSize = player.field_71071_by.func_70301_a((int)slot).field_77994_a;
                if (stackSize >= count) {
                    player.field_71071_by.func_70298_a(slot, count);
                    return true;
                }
                player.field_71071_by.func_70298_a(slot, stackSize);
                count -= stackSize;
            }
        }
        return false;
    }

    public static int tryToRemoveFromInventory(ItemStack contents, IInventory inventory, int maxToRemove) {
        int numberRemoved = 0;
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (inventory.func_70301_a(slot) == null) continue;
            while (inventory.func_70301_a(slot) != null && StackHelper.isItemAndNbtEqual(inventory.func_70301_a(slot), contents) && maxToRemove > numberRemoved) {
                numberRemoved += Math.min(maxToRemove - numberRemoved, inventory.func_70301_a((int)slot).field_77994_a);
                inventory.func_70298_a(slot, Math.min(maxToRemove, inventory.func_70301_a((int)slot).field_77994_a));
            }
            if (numberRemoved < maxToRemove) continue;
            return numberRemoved;
        }
        return numberRemoved;
    }

    public static int tryToAddToInventory(ItemStack contents, IInventory inventory, int maxToAdd) {
        return InventoryHelper.tryToAddToInventory(contents, inventory, maxToAdd, EnumFacing.UP);
    }

    public static int tryToAddToInventory(ItemStack contents, IInventory inventory, int maxToAdd, EnumFacing insertDirection) {
        int numberAdded = 0;
        if (inventory instanceof ISidedInventory) {
            int[] slotsForFace;
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            for (int slot : slotsForFace = sidedInventory.func_180463_a(insertDirection)) {
                if (sidedInventory.func_70301_a(slot) == null && sidedInventory.func_180462_a(slot, contents, insertDirection)) {
                    numberAdded += InventoryHelper.insertIntoEmptySlot(contents, sidedInventory, slot, maxToAdd);
                } else if (StackHelper.isItemAndNbtEqual(inventory.func_70301_a(slot), contents)) {
                    if (inventory.func_70301_a((int)slot).field_77994_a == Math.min(inventory.func_70301_a(slot).func_77976_d(), inventory.func_70297_j_())) continue;
                    int stackAddition = InventoryHelper.addToNonEmptySlot(inventory, maxToAdd, numberAdded, slot);
                    numberAdded += stackAddition;
                }
                if (numberAdded < maxToAdd) {
                    continue;
                }
                break;
            }
        } else {
            for (int slot = 0; slot < Math.min(inventory.func_70302_i_(), inventory.func_70302_i_()); ++slot) {
                if (inventory.func_70301_a(slot) == null && inventory.func_94041_b(slot, contents)) {
                    numberAdded += InventoryHelper.insertIntoEmptySlot(contents, inventory, slot, maxToAdd);
                } else if (StackHelper.isItemAndNbtEqual(inventory.func_70301_a(slot), contents)) {
                    if (inventory.func_70301_a((int)slot).field_77994_a == Math.min(inventory.func_70301_a(slot).func_77976_d(), inventory.func_70297_j_())) continue;
                    int stackAddition = InventoryHelper.addToNonEmptySlot(inventory, maxToAdd, numberAdded, slot);
                    numberAdded += stackAddition;
                }
                if (numberAdded < maxToAdd) {
                    continue;
                }
                break;
            }
        }
        if (numberAdded > 0) {
            inventory.func_70296_d();
        }
        return numberAdded;
    }

    private static int addToNonEmptySlot(IInventory inventory, int maxToAdd, int numberAdded, int slot) {
        ItemStack slotStack = inventory.func_70301_a(slot);
        int stackAddition = Math.min(Math.min(slotStack.func_77976_d(), inventory.func_70297_j_()) - slotStack.field_77994_a, maxToAdd - numberAdded);
        slotStack.field_77994_a += stackAddition;
        return stackAddition;
    }

    private static int insertIntoEmptySlot(ItemStack contents, IInventory inventory, int slot, int maxToAdd) {
        int numberAdded;
        int stackAddition;
        for (numberAdded = 0; inventory.func_70301_a(slot) == null && maxToAdd > numberAdded; numberAdded += stackAddition) {
            stackAddition = Math.min(Math.min(contents.func_77976_d(), inventory.func_70297_j_()), maxToAdd - numberAdded);
            ItemStack newContents = contents.func_77946_l();
            newContents.field_77994_a = stackAddition;
            inventory.func_70299_a(slot, newContents);
        }
        return numberAdded;
    }

    private static int insertIntoEmptySlot(ItemStack contents, ISidedInventory inventory, int slot, int maxToAdd) {
        int numberAdded;
        int stackAddition;
        ItemStack stackInSlot = inventory.func_70301_a(slot);
        for (numberAdded = 0; (stackInSlot == null || stackInSlot.field_77994_a > stackInSlot.func_77976_d()) && maxToAdd > numberAdded; numberAdded += stackAddition) {
            int maxSlotAddition = stackInSlot == null ? contents.func_77976_d() : stackInSlot.func_77976_d() - stackInSlot.field_77994_a;
            stackAddition = Math.min(maxSlotAddition, maxToAdd - numberAdded);
            ItemStack newContents = contents.func_77946_l();
            newContents.field_77994_a = stackAddition;
            inventory.func_70299_a(slot, newContents);
            stackInSlot = inventory.func_70301_a(slot);
        }
        return numberAdded;
    }

    public static void tryRemovingLastStack(IInventory inventory, World worldObj, BlockPos pos) {
        for (int i = inventory.func_70302_i_() - 1; i >= 0; --i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            inventory.func_70299_a(i, null);
            if (worldObj.field_72995_K) {
                return;
            }
            inventory.func_70296_d();
            EntityItem itemEntity = new EntityItem(worldObj, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, stack);
            worldObj.func_72838_d((Entity)itemEntity);
            break;
        }
    }

    public static boolean tryAddingPlayerCurrentItem(EntityPlayer player, IInventory inventory, EnumHand hand) {
        if (inventory.func_70301_a(0) != null) {
            return false;
        }
        inventory.func_70299_a(0, player.func_184586_b(hand).func_77946_l());
        --player.func_184586_b((EnumHand)hand).field_77994_a;
        if (player.func_184586_b((EnumHand)hand).field_77994_a == 0) {
            player.func_184611_a(hand, null);
        }
        player.field_71071_by.func_70296_d();
        return true;
    }
}

