/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.util.pedestal;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import xreliquary.api.IPedestal;
import xreliquary.api.IPedestalActionItemWrapper;
import xreliquary.entities.EntityXRFakePlayer;
import xreliquary.network.PacketHandler;
import xreliquary.network.PacketPedestalFishHook;
import xreliquary.reference.Settings;

public class PedestalFishingRodWrapper
implements IPedestalActionItemWrapper {
    private static final int PACKET_RANGE = 50;
    private static final int RANGE = 4;
    private static final int NO_WATER_COOLDOWN = 100;
    private static final int BAD_THROW_TIMEOUT = 60;
    private static final int ABSOLUTE_TIMEOUT = 1200;
    private static Random rand = new Random();
    private EntityXRFakePlayer fakePlayer;
    private boolean badThrowChecked;
    private int ticksSinceLastThrow;
    private boolean retractFail = false;

    @Override
    public void update(ItemStack stack, IPedestal pedestal) {
        ++this.ticksSinceLastThrow;
        if (this.fakePlayer != null && this.fakePlayer.field_71104_cf != null) {
            this.handleHookStates(stack, pedestal);
            this.syncHookData(pedestal);
        } else {
            this.setupFakePlayer(pedestal.getTheWorld(), pedestal.getBlockPos());
            BlockPos pos = this.getBestWaterBlock(pedestal);
            if (pos != null) {
                this.updateHeldItem(stack);
                this.setPitchYaw(pos);
                this.spawnFishHook(pedestal);
                this.badThrowChecked = false;
                this.ticksSinceLastThrow = 0;
            } else {
                pedestal.setActionCoolDown(100);
            }
        }
    }

    private void handleHookStates(ItemStack stack, IPedestal pedestal) {
        if (this.retractFail) {
            if (this.getTicksCatchable(this.fakePlayer.field_71104_cf) == 0) {
                this.retractHook(pedestal, stack);
                this.retractFail = false;
            }
        } else if (!this.badThrowChecked && this.ticksSinceLastThrow > 60) {
            if (!this.fakePlayer.field_71104_cf.func_70090_H()) {
                this.retractHook(pedestal, stack);
            } else {
                this.badThrowChecked = true;
            }
        } else if (this.ticksSinceLastThrow > 1200) {
            this.retractHook(pedestal, stack);
        } else if (this.getTicksCatchable(this.fakePlayer.field_71104_cf) > 0 || this.fakePlayer.field_71104_cf.field_146043_c != null) {
            if (rand.nextInt(100) <= Settings.Pedestal.fishingWrapperSuccessRate) {
                this.retractHook(pedestal, stack);
            } else {
                this.retractFail = true;
            }
        }
    }

    private void updateHeldItem(ItemStack fishingRod) {
        ItemStack heldItem = this.fakePlayer.func_184614_ca();
        if (heldItem == null) {
            this.fakePlayer.func_184611_a(EnumHand.MAIN_HAND, fishingRod);
            return;
        }
        if (!heldItem.func_185136_b(fishingRod)) {
            this.fakePlayer.func_184611_a(EnumHand.MAIN_HAND, fishingRod);
        }
    }

    private void retractHook(IPedestal pedestal, ItemStack stack) {
        int i = this.fakePlayer.field_71104_cf.func_146034_e();
        stack.func_77972_a(i, (EntityLivingBase)this.fakePlayer);
        if (stack.field_77994_a == 0) {
            pedestal.destroyCurrentItem();
        }
        pedestal.setActionCoolDown(Settings.Pedestal.fishingWrapperRetractDelay * 20);
    }

    private BlockPos getBestWaterBlock(IPedestal pedestal) {
        ArrayList<List<BlockPos>> connectedGroups = new ArrayList<List<BlockPos>>();
        ArrayList<BlockPos> visitedBlocks = new ArrayList<BlockPos>();
        BlockPos pos = pedestal.getBlockPos();
        int pedestalX = pos.func_177958_n();
        int pedestalY = pos.func_177956_o();
        int pedestalZ = pos.func_177952_p();
        for (int y = pedestalY - 4; y < pedestalY; ++y) {
            for (int r = 1; r <= 4; ++r) {
                int x;
                int z = pedestalZ - r;
                for (x = pedestalX - r; x <= pedestalX + r; ++x) {
                    this.checkForAndAddWaterBlocks(pedestal, visitedBlocks, connectedGroups, pedestalX, pedestalY, pedestalZ, x, y, z);
                }
                --x;
                while (z <= pedestalZ + r) {
                    this.checkForAndAddWaterBlocks(pedestal, visitedBlocks, connectedGroups, pedestalX, pedestalY, pedestalZ, x, y, z);
                    ++z;
                }
                --z;
                while (x >= pedestalX - r) {
                    this.checkForAndAddWaterBlocks(pedestal, visitedBlocks, connectedGroups, pedestalX, pedestalY, pedestalZ, x, y, z);
                    --x;
                }
                ++x;
                while (z >= pedestalZ - r) {
                    this.checkForAndAddWaterBlocks(pedestal, visitedBlocks, connectedGroups, pedestalX, pedestalY, pedestalZ, x, y, z);
                    --z;
                }
            }
        }
        BlockPos closestBlockInLargestGroup = null;
        int closestSqDistance = Integer.MAX_VALUE;
        int mostBlocks = 0;
        for (List list : connectedGroups) {
            if (list.size() <= mostBlocks) continue;
            mostBlocks = list.size();
            for (BlockPos waterPos : list) {
                int zDiff;
                int yDiff;
                int xDiff = waterPos.func_177958_n() - pedestalX;
                int sqDistance = xDiff * xDiff + (yDiff = waterPos.func_177956_o() - pedestalY) * yDiff + (zDiff = waterPos.func_177952_p() - pedestalZ) * zDiff;
                if (sqDistance >= closestSqDistance) continue;
                closestSqDistance = sqDistance;
                closestBlockInLargestGroup = waterPos;
            }
        }
        return closestBlockInLargestGroup;
    }

    private void checkForAndAddWaterBlocks(IPedestal pedestal, List<BlockPos> visitedBlocks, List<List<BlockPos>> connectedGroups, double pedestalX, double pedestalY, double pedestalZ, int x, int y, int z) {
        BlockPos blockPos = new BlockPos(x, y, z);
        if (!visitedBlocks.contains(blockPos)) {
            ArrayList<BlockPos> group = new ArrayList<BlockPos>();
            this.checkForWaterAndSearchNeighbors(pedestal, visitedBlocks, pedestalX, pedestalY, pedestalZ, blockPos, group);
            if (group.size() > 0) {
                connectedGroups.add(group);
            }
        }
    }

    private void checkForWaterAndSearchNeighbors(IPedestal pedestal, List<BlockPos> visitedBlocks, double pedestalX, double pedestalY, double pedestalZ, BlockPos blockPos, List<BlockPos> group) {
        visitedBlocks.add(blockPos);
        IBlockState blockState = pedestal.getTheWorld().func_180495_p(blockPos);
        if (blockState.func_177230_c() == Blocks.field_150355_j) {
            int x = blockPos.func_177958_n();
            int y = blockPos.func_177956_o();
            int z = blockPos.func_177952_p();
            double startX = this.fakePlayer.field_70165_t;
            double startY = this.fakePlayer.field_70163_u;
            double startZ = this.fakePlayer.field_70161_v;
            RayTraceResult raytraceresult = pedestal.getTheWorld().func_147447_a(new Vec3d(startX, startY, startZ), new Vec3d((double)x + 0.5, (double)y + 0.99, (double)z + 0.5), true, false, false);
            if (raytraceresult != null && raytraceresult.func_178782_a().equals((Object)blockPos)) {
                group.add(blockPos);
                for (EnumFacing facing : EnumFacing.field_176754_o) {
                    BlockPos neighborPos = blockPos.func_177972_a(facing);
                    if (!((double)neighborPos.func_177958_n() <= pedestalX + 4.0) || !((double)neighborPos.func_177958_n() >= pedestalX - 4.0) || !((double)neighborPos.func_177956_o() <= pedestalY + 4.0) || !((double)neighborPos.func_177956_o() >= pedestalY - 4.0)) continue;
                    this.addNeighboringWater(pedestal, visitedBlocks, group, pedestalX, pedestalY, pedestalZ, neighborPos.func_177958_n(), neighborPos.func_177956_o(), neighborPos.func_177952_p(), neighborPos);
                }
            }
        }
    }

    private void addNeighboringWater(IPedestal pedestal, List<BlockPos> visitedBlocks, List<BlockPos> group, double pedestalX, double pedestalY, double pedestalZ, int x, int y, int z, BlockPos blockPos) {
        if (!visitedBlocks.contains(blockPos)) {
            this.checkForWaterAndSearchNeighbors(pedestal, visitedBlocks, pedestalX, pedestalY, pedestalZ, blockPos, group);
        }
    }

    private void spawnFishHook(IPedestal pedestal) {
        World world = pedestal.getTheWorld();
        world.func_184133_a(null, pedestal.getBlockPos(), SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, 0.4f / (rand.nextFloat() * 0.4f + 0.8f));
        world.func_72838_d((Entity)new EntityFishHook(world, (EntityPlayer)this.fakePlayer));
    }

    private void syncHookData(IPedestal pedestal) {
        EntityFishHook hook = this.fakePlayer.field_71104_cf;
        BlockPos pedestalPos = pedestal.getBlockPos();
        if (hook == null) {
            PacketHandler.networkWrapper.sendToAllAround((IMessage)new PacketPedestalFishHook(pedestal.getBlockPos(), pedestal.getCurrentItemIndex(), -1.0, -1.0, -1.0), new NetworkRegistry.TargetPoint(pedestal.getTheWorld().field_73011_w.getDimension(), (double)pedestalPos.func_177958_n(), (double)pedestalPos.func_177956_o(), (double)pedestalPos.func_177952_p(), 50.0));
        } else {
            PacketHandler.networkWrapper.sendToAllAround((IMessage)new PacketPedestalFishHook(pedestal.getBlockPos(), pedestal.getCurrentItemIndex(), hook.field_70165_t, hook.field_70163_u, hook.field_70161_v), new NetworkRegistry.TargetPoint(pedestal.getTheWorld().field_73011_w.getDimension(), (double)pedestalPos.func_177958_n(), (double)pedestalPos.func_177956_o(), (double)pedestalPos.func_177952_p(), 50.0));
        }
    }

    @Override
    public void onRemoved(ItemStack stack, IPedestal pedestal) {
        if (this.fakePlayer != null && this.fakePlayer.field_71104_cf != null) {
            this.fakePlayer.field_71104_cf.func_70106_y();
        }
    }

    @Override
    public void stop(ItemStack stack, IPedestal pedestal) {
        if (this.fakePlayer != null && this.fakePlayer.field_71104_cf != null) {
            this.fakePlayer.field_71104_cf.func_70106_y();
            this.syncHookData(pedestal);
        }
    }

    private void setupFakePlayer(World world, BlockPos pos) {
        if (this.fakePlayer == null) {
            this.fakePlayer = new EntityXRFakePlayer((WorldServer)world);
            this.fakePlayer.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5);
        }
    }

    private int getTicksCatchable(EntityFishHook hook) {
        return (Integer)ReflectionHelper.getPrivateValue(EntityFishHook.class, (Object)hook, (String[])new String[]{"ticksCatchable", "field_146045_ax"});
    }

    private void setPitchYaw(BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        double degree = 57.29577951308232;
        double dx = this.fakePlayer.field_70165_t - ((double)x + 0.5);
        double dy = this.fakePlayer.field_70163_u - (double)y;
        double dz = this.fakePlayer.field_70161_v - ((double)z + 0.5);
        this.fakePlayer.field_70177_z = (float)(-(Math.atan2(dx, dz) * degree + 180.0));
        this.fakePlayer.field_70125_A = (float)(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)) * degree);
    }
}

