/*
 * Decompiled with CFR 0.152.
 */
package reauth;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reauth.GuiHandler;
import reauth.Secure;

@Mod(modid="ReAuth", version="3.2", guiFactory="reauth.GuiFactory", canBeDeactivated=true, clientSideOnly=true, acceptedMinecraftVersions="[1.9,1.10.2]", certificateFingerprint="35787b2f97a740b13a05638ab0d20d2107e3a79e")
public class Main {
    protected static final Logger log = LogManager.getLogger((String)"ReAuth");
    protected static Configuration config;
    protected static boolean OfflineModeEnabled;
    @Mod.Instance(value="ReAuth")
    protected static Main main;
    @Mod.Metadata
    protected static ModMetadata meta;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        config = new Configuration(evt.getSuggestedConfigurationFile());
        Main.loadConfig();
        Secure.init();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
        if (evt.getModID().equals("ReAuth")) {
            Main.loadConfig();
        }
    }

    private static void loadConfig() {
        Property pu = config.get("general", "username", "", "Your Username");
        Secure.username = pu.getString();
        Property pp = config.get("general", "password", "", "Your Password in plaintext if chosen to save to disk");
        Secure.password = pp.getString();
        Property po = config.get("general", "offlineModeEnabled", false, "Controls wheter a play-offline button is visble in the Re-Login screen");
        OfflineModeEnabled = po.getBoolean();
        Property ve = config.get("general", "validatorEnabled", true, "Disables the Session Validator");
        GuiHandler.enabled = ve.getBoolean();
        Property vb = config.get("general", "validatorBold", true, "If the Session-Validator look weird disable this");
        GuiHandler.bold = vb.getBoolean();
        config.save();
    }

    @Mod.EventHandler
    public void securityError(FMLFingerprintViolationEvent event) {
        boolean dev = false;
        if (!dev) {
            throw new SecurityException("The Version of ReAuth is not signed! It is a modified version!");
        }
        log.fatal("+-----------------------------------------------------------------------------------+");
        log.fatal("|The Version of ReAuth is not signed! It was modified! Ignoring because of Dev-Mode!|");
        log.fatal("+-----------------------------------------------------------------------------------+");
    }
}

