/*
 * Decompiled with CFR 0.152.
 */
package reauth;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import com.mojang.util.UUIDTypeAdapter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Session;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import reauth.Main;
import reauth.VersionChecker;

class Secure {
    protected static String username = "";
    protected static String password = "";
    private static final YggdrasilAuthenticationService yas = new YggdrasilAuthenticationService(Minecraft.func_71410_x().func_110437_J(), UUID.randomUUID().toString());
    private static final YggdrasilUserAuthentication yua = (YggdrasilUserAuthentication)yas.createUserAuthentication(Agent.MINECRAFT);
    private static final YggdrasilMinecraftSessionService ymss = (YggdrasilMinecraftSessionService)yas.createMinecraftSessionService();

    Secure() {
    }

    protected static void init() {
        String base = "reauth.";
        ImmutableList classes = ImmutableList.of((Object)(base + "ConfigGUI"), (Object)(base + "GuiFactory"), (Object)(base + "GuiHandler"), (Object)(base + "GuiLogin"), (Object)(base + "GuiPasswordField"), (Object)(base + "Main"), (Object)(base + "Secure"), (Object)(base + "VersionChecker"));
        try {
            ImmutableSet set = ClassPath.from((ClassLoader)Secure.class.getClassLoader()).getTopLevelClassesRecursive("reauth");
            for (ClassPath.ClassInfo info : set) {
                if (classes.contains(info.getName())) continue;
                throw new RuntimeException("Detected unauthorized class trying to access reauth-data! Offender: " + info.url().getPath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Classnames could not be fetched!");
        }
        VersionChecker.update();
    }

    protected static void login(String user, String pw, boolean savePassToConfig) throws AuthenticationException, IllegalArgumentException, IllegalAccessException {
        if (!VersionChecker.isVersionAllowed()) {
            throw new AuthenticationException("ReAuth has a critical update!");
        }
        yua.setUsername(user);
        yua.setPassword(pw);
        yua.logIn();
        Main.log.info("Login successfull!");
        String username = yua.getSelectedProfile().getName();
        String uuid = UUIDTypeAdapter.fromUUID((UUID)yua.getSelectedProfile().getId());
        String access = yua.getAuthenticatedToken();
        String type = yua.getUserType().getName();
        Sessionutil.set(new Session(username, uuid, access, type));
        yua.logOut();
        Secure.username = user;
        Main.config.get("general", "username", "", "Your Username").set(Secure.username);
        if (savePassToConfig) {
            password = pw;
            Main.config.get("general", "password", "", "Your Password in plaintext if chosen to save to disk").set(password);
        }
        Main.config.save();
    }

    protected static void offlineMode(String username) throws IllegalArgumentException, IllegalAccessException {
        UUID uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(Charsets.UTF_8));
        Sessionutil.set(new Session(username, uuid.toString(), null, "legacy"));
        Main.log.info("Username set! you can only pay on offline-mode servers now!");
        Secure.username = username;
    }

    protected static boolean SessionValid() {
        try {
            GameProfile gp = Sessionutil.get().func_148256_e();
            String token = Sessionutil.get().func_148254_d();
            String id = UUID.randomUUID().toString();
            ymss.joinServer(gp, token, id);
            if (ymss.hasJoinedServer(gp, id).isComplete()) {
                Main.log.info("Session validation successfull");
                return true;
            }
        }
        catch (Exception e) {
            Main.log.info("Session validation failed: " + e.getMessage());
            return false;
        }
        Main.log.info("Session validation failed!");
        return false;
    }

    protected static class Sessionutil {
        private static Field sessionField = ReflectionHelper.findField(Minecraft.class, (String[])new String[]{"session", "S", "field_71449_j"});

        protected Sessionutil() {
        }

        protected static Session get() throws IllegalArgumentException, IllegalAccessException {
            return Minecraft.func_71410_x().func_110432_I();
        }

        protected static void set(Session s) throws IllegalArgumentException, IllegalAccessException {
            sessionField.set(Minecraft.func_71410_x(), s);
        }
    }
}

