/*
 * Decompiled with CFR 0.152.
 */
package reauth;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.common.versioning.VersionRange;
import org.apache.commons.io.IOUtils;
import reauth.Main;

class VersionChecker
implements Runnable {
    private static final String url = "https://raw.githubusercontent.com/TechnicianLP/ReAuth/master/version";
    private static boolean isLatestVersion = true;
    private static String[] versionInfo = new String[]{"", ""};
    private static boolean isVersionAllowed = true;
    private static long run = 0L;

    VersionChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Main.log.info("Looking for Updates");
        InputStream in = null;
        try {
            in = new URL(url).openStream();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            versionInfo = ((String)IOUtils.readLines((InputStream)in).get(0)).split(";");
            ComparableVersion local = new ComparableVersion(Main.meta.version);
            ComparableVersion recommended = new ComparableVersion(versionInfo[0]);
            VersionRange allowed = VersionParser.parseRange((String)versionInfo[1]);
            isLatestVersion = local.compareTo(recommended) >= 0;
            isVersionAllowed = allowed.containsVersion((ArtifactVersion)new DefaultArtifactVersion(Main.meta.version));
            run = System.currentTimeMillis();
            Main.log.info("Looking for Updates - Finished");
            return;
        }
        catch (IOException e) {
            Main.log.error("Looking for Updates - Failed");
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        run = System.currentTimeMillis() - 2700000L;
    }

    public static boolean isLatestVersion() {
        return isLatestVersion;
    }

    public static String getLatestVersion() {
        return versionInfo[0];
    }

    public static boolean isVersionAllowed() {
        return isVersionAllowed;
    }

    public static boolean shouldRun() {
        return System.currentTimeMillis() - run > 3600000L;
    }

    public static void update() {
        Thread t = new Thread((Runnable)new VersionChecker(), "ReAuth-VersinChecker");
        t.setDaemon(true);
        t.start();
    }
}

