/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.moreBees.Genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpeciesBuilder;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeBranchDefinition;
import forestry.apiculture.genetics.BeeVariation;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.core.genetics.IBranchDefinition;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.awt.Color;
import java.util.Arrays;
import java.util.Locale;
import lach_01298.moreBees.Genetics.BeeBranches;
import lach_01298.moreBees.Register;
import lach_01298.moreBees.item.MoreBeesItems;
import lach_01298.moreBees.util.LoadMods;
import lach_01298.moreBees.util.OreDicPreferences;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.text.WordUtils;

public enum BeeSpecies implements IBeeDefinition
{
    ROCK(BeeBranches.ROCK, "Rock", true, new Color(0x6D6D6D), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeOre);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    HARDENED(BeeBranches.ROCK, "Hardened", true, new Color(0x464646), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.35f)).setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RockBee, CultivatedBee, this.getTemplate(), 10);
        }
    }
    ,
    OBSIDIAN(BeeBranches.ROCK, "Obsidian", false, new Color(2367025), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.4f)).addProduct(new ItemStack(Blocks.field_150343_Z), Float.valueOf(0.1f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(HardenedBee, SteadfastBee, this.getTemplate(), 10);
        }
    }
    ,
    LAPIS(BeeBranches.ROCK, "Lapis", false, new Color(2246556), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_151100_aR, 1, 4), Float.valueOf(0.1f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(ObsidianBee, ImperialBee, this.getTemplate(), 8);
        }
    }
    ,
    DIRT(BeeBranches.EARTH, "Dirt", true, new Color(7951674), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombDirt), Float.valueOf(0.4f)).setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        }

        @Override
        protected void registerMutations() {
            for (int i = 0; i < hiveBees.length; ++i) {
                BeeManager.beeMutationFactory.createMutation(RockBee, hiveBees[i], this.getTemplate(), 15);
            }
        }
    }
    ,
    CLAY(BeeBranches.EARTH, "Clay", true, new Color(0xA7ABBB), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombDirt), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_151119_aD), Float.valueOf(1.0f)).addProduct(new ItemStack(Items.field_151119_aD), Float.valueOf(0.5f)).addProduct(new ItemStack(Items.field_151119_aD), Float.valueOf(0.5f)).addProduct(new ItemStack(Items.field_151119_aD), Float.valueOf(0.5f)).setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(DirtBee, hiveBees[1], this.getTemplate(), 15);
        }
    }
    ,
    REDSAND(BeeBranches.EARTH, "RedSand", false, new Color(10966560), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombDirt), Float.valueOf(0.3f)).addProduct(new ItemStack((Block)Blocks.field_150354_m), Float.valueOf(0.4f)).addProduct(new ItemStack((Block)Blocks.field_150354_m, 1, 1), Float.valueOf(0.7f)).addProduct(new ItemStack((Block)Blocks.field_150354_m, 2, 1), Float.valueOf(0.3f)).addProduct(new ItemStack((Block)Blocks.field_150354_m, 1, 1), Float.valueOf(0.2f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(DirtBee, hiveBees[3], this.getTemplate(), 15);
        }
    }
    ,
    REDSTONE(BeeBranches.CRYSTAL, "Redstone", false, new Color(0xAA0404), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_151137_ax), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_151137_ax), Float.valueOf(0.2f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeRedstone);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(ObsidianBee, SteadfastBee, this.getTemplate(), 8);
        }
    }
    ,
    EMERALD(BeeBranches.CRYSTAL, "Emerald", false, new Color(4906099), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(new ItemStack((Item)MoreBeesItems.EmeraldFrag), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeEmerald);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RedstoneBee, ImperialBee, this.getTemplate(), 5);
        }
    }
    ,
    DIAMOND(BeeBranches.CRYSTAL, "Diamond", false, new Color(6155509), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(new ItemStack((Item)MoreBeesItems.DiamondFrag), Float.valueOf(0.15f)).setHasEffect().setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeDiamond);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(EmeraldBee, LapisBee, this.getTemplate(), 2);
        }
    }
    ,
    RUBY(BeeBranches.CRYSTAL, "Ruby", false, new Color(0xFF0000), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableRuby) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("gemRuby", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RedstoneBee, ImperialBee, this.getTemplate(), 7);
        }
    }
    ,
    SAPPHIRE(BeeBranches.CRYSTAL, "Sapphire", false, new Color(22776), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableSapphire) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("gemSapphire", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RedstoneBee, ImperialBee, this.getTemplate(), 7);
        }
    }
    ,
    Metallic(BeeBranches.METAL, "Metallic", true, new Color(0x999999), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustIron", 1), Float.valueOf(0.05f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(ObsidianBee, FiendishBee, this.getTemplate(), 10);
        }
    }
    ,
    IRON(BeeBranches.METAL, "Iron", false, new Color(0xD9D9D9), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustIron", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(MetallicBee, IndustriousBee, this.getTemplate(), 10);
        }
    }
    ,
    COPPER(BeeBranches.METAL, "Copper", false, new Color(10970160), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustCopper", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(MetallicBee, IndustriousBee, this.getTemplate(), 10);
        }
    }
    ,
    TIN(BeeBranches.METAL, "Tin", false, new Color(0xE8E8E8), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustTin", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(MetallicBee, IndustriousBee, this.getTemplate(), 10);
        }
    }
    ,
    ALUMINIUM(BeeBranches.METAL, "Aluminium", false, new Color(0xF6F6F6), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableAluminium) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustAluminum", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(MetallicBee, IndustriousBee, this.getTemplate(), 10);
        }
    }
    ,
    GOLD(BeeBranches.METAL, "Gold", false, new Color(15652925), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustGold", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(MetallicBee, ImperialBee, this.getTemplate(), 8);
        }
    }
    ,
    SILVER(BeeBranches.METAL, "Silver", false, new Color(0xF4F6F6), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableSilver) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustSilver", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(GoldBee, TinBee, this.getTemplate(), 8);
        }
    }
    ,
    LEAD(BeeBranches.METAL, "Lead", false, new Color(14014905), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableLead) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustLead", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(MetallicBee, ObsidianBee, this.getTemplate(), 8);
        }
    }
    ,
    COBALT(BeeBranches.METAL, "Cobalt", false, new Color(1925816), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableTinkers) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("nuggetCobalt", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(DemonicBee, TinBee, this.getTemplate(), 8);
        }
    }
    ,
    ARDITE(BeeBranches.METAL, "Ardite", false, new Color(11019543), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableTinkers) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("nuggetArdite", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(DemonicBee, CopperBee, this.getTemplate(), 8);
        }
    }
    ,
    RADIOACTIVE(BeeBranches.RADIOACTIVE, "Radioactive", true, new Color(4092428), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableUranium) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("oreUranium", 1), Float.valueOf(0.1f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeUranium);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(LeadBee, AustereBee, this.getTemplate(), 8);
        }
    }
    ,
    URANIUM(BeeBranches.RADIOACTIVE, "Uranium", false, new Color(6995987), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableIC2) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("crushedUranium", 1), Float.valueOf(0.15f)).setHasEffect().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RadioactiveBee, ApocalypticBee, this.getTemplate(), 5).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    }
    ,
    PRISMARINE(BeeBranches.AQUATIC, "Prismarine", true, new Color(6531997), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.items.beeComb.get(EnumHoneyComb.HONEY, 1), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_179563_cD, 2), Float.valueOf(0.2f)).addProduct(new ItemStack(Items.field_179562_cC, 2), Float.valueOf(0.2f)).setHasEffect().setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(ObsidianBee, ClayBee, this.getTemplate(), 15).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.WET});
        }
    }
    ,
    APOCALYPTIC(BeeBranches.APOCALYTIC, "Apocalyptic", true, new Color(13332996), new Color(8588557)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.items.beeComb.get(EnumHoneyComb.SIMMERING, 1), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_151065_br), Float.valueOf(0.2f)).addProduct(new ItemStack(Items.field_151016_H), Float.valueOf(0.2f)).addProduct(new ItemStack(Items.field_151073_bk), Float.valueOf(0.05f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_3);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectCreeper);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeTNT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(AustereBee, DemonicBee, this.getTemplate(), 5).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    }
    ,
    WITHER(BeeBranches.WITHER, "Withering", false, new Color(0xC1C1C1), new Color(0x3C3C3C)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombWither), Float.valueOf(0.3f)).addSpecialty(new ItemStack(Items.field_151144_bL, 1, 1), Float.valueOf(0.02f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_3);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(ApocalypticBee, DemonicBee, this.getTemplate(), 5).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    }
    ,
    NETHERSTAR(BeeBranches.WITHER, "wither", false, new Color(0xC1C1C1), new Color(0x3C3C3C)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombWither), Float.valueOf(0.35f)).addSpecialty(new ItemStack((Item)MoreBeesItems.NetherFrag), Float.valueOf(0.05f)).setHasEffect().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_3);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(WitherBee, EnderBee, this.getTemplate(), 5).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    }
    ,
    SLIMEY(BeeBranches.Slime, "Slimey", true, new Color(8243315), new Color(8243315)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombSlime), Float.valueOf(0.7f)).setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeSlime);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)Register.effectSlimey);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RockBee, BoggyBee, this.getTemplate(), 30);
        }
    }
    ,
    BLUESLIMEY(BeeBranches.Slime, "BlueSlimey", true, new Color(8243315), new Color(7653575)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableTinkers) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombSlime), Float.valueOf(0.55f)).addProduct(OreDicPreferences.get("slimeballBlue", 1), Float.valueOf(0.55f)).setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.DAMP);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(SlimeyBee, PrismarineBee, this.getTemplate(), 30);
        }
    }
    ,
    PURPLESLIMEY(BeeBranches.Slime, "PurpleSlimey", false, new Color(8243315), new Color(12278527)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableTinkers) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombSlime), Float.valueOf(0.55f)).addProduct(OreDicPreferences.get("slimeballPurple", 1), Float.valueOf(0.55f)).setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.DAMP);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            System.out.println(BlueSlimeyBee);
            BeeManager.beeMutationFactory.createMutation(BlueSlimeyBee, RedstoneBee, this.getTemplate(), 8);
        }
    }
    ,
    MAGMASLIMEY(BeeBranches.Slime, "MagmaSlimey", false, new Color(8243315), new Color(16755529)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableTinkers) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombSlime), Float.valueOf(0.55f)).addProduct(OreDicPreferences.get("slimeballMagma", 1), Float.valueOf(0.55f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(SlimeyBee, FiendishBee, this.getTemplate(), 10);
        }
    }
    ,
    STRINGY((IBranchDefinition)BeeBranchDefinition.TROPICAL, "Stringy", false, new Color(0x6D6D6D), new Color(0xE5E5E5)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.items.beeComb.get(EnumHoneyComb.SILKY, 1), Float.valueOf(0.3f)).addProduct(PluginApiculture.items.beeComb.get(EnumHoneyComb.STRINGY, 1), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_151007_F, 1), Float.valueOf(0.7f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(TropicalBee, DiligentBee, this.getTemplate(), 10);
        }
    };

    private static final IAlleleBeeSpecies[] hiveBees;
    private static IAlleleBeeSpecies SteadfastBee;
    private static IAlleleBeeSpecies CultivatedBee;
    private static IAlleleBeeSpecies FiendishBee;
    private static IAlleleBeeSpecies IndustriousBee;
    private static IAlleleBeeSpecies ImperialBee;
    private static IAlleleBeeSpecies AustereBee;
    private static IAlleleBeeSpecies DemonicBee;
    private static IAlleleBeeSpecies EnderBee;
    private static IAlleleBeeSpecies BoggyBee;
    private static IAlleleBeeSpecies DiligentBee;
    private static IAlleleBeeSpecies TropicalBee;
    private static IAlleleBeeSpecies RockBee;
    private static IAlleleBeeSpecies HardenedBee;
    private static IAlleleBeeSpecies ObsidianBee;
    private static IAlleleBeeSpecies LapisBee;
    private static IAlleleBeeSpecies RedstoneBee;
    private static IAlleleBeeSpecies EmeraldBee;
    private static IAlleleBeeSpecies DirtBee;
    private static IAlleleBeeSpecies ClayBee;
    private static IAlleleBeeSpecies MetallicBee;
    private static IAlleleBeeSpecies LeadBee;
    private static IAlleleBeeSpecies GoldBee;
    private static IAlleleBeeSpecies TinBee;
    private static IAlleleBeeSpecies RadioactiveBee;
    private static IAlleleBeeSpecies UraniumBee;
    private static IAlleleBeeSpecies ApocalypticBee;
    private static IAlleleBeeSpecies WitherBee;
    private static IAlleleBeeSpecies SlimeyBee;
    private static IAlleleBeeSpecies BlueSlimeyBee;
    private static IAlleleBeeSpecies PrismarineBee;
    private static IAlleleBeeSpecies CopperBee;
    private final IBranchDefinition branch;
    private final IAlleleBeeSpecies species;
    private IAllele[] template;
    private IBeeGenome genome;

    private BeeSpecies(IBranchDefinition branch, String binomial, boolean dominant, Color primary, Color secondary) {
        String lowercaseName = this.toString().toLowerCase(Locale.ENGLISH);
        String species = "species" + WordUtils.capitalize((String)lowercaseName);
        String ID = "morebees." + species;
        String description = "for.description." + species;
        String name = "for.bees.species." + lowercaseName;
        this.branch = branch;
        IAlleleBeeSpeciesBuilder speciesBuilder = BeeManager.beeFactory.createSpecies(ID, dominant, "Lach_01298", name, description, branch.getBranch(), binomial, primary.getRGB(), secondary.getRGB());
        if (this.isSecret()) {
            speciesBuilder.setIsSecret();
        }
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
    }

    protected abstract void setSpeciesProperties(IAlleleBeeSpeciesBuilder var1);

    protected abstract void setAlleles(IAllele[] var1);

    protected abstract void registerMutations();

    protected boolean isSecret() {
        return false;
    }

    public static void initBees() {
        block28: for (BeeSpecies bee : BeeSpecies.values()) {
            switch (bee) {
                case LEAD: {
                    if (!LoadMods.enableLead) continue block28;
                    bee.init();
                    continue block28;
                }
                case SILVER: {
                    if (!LoadMods.enableSilver) continue block28;
                    bee.init();
                    continue block28;
                }
                case RADIOACTIVE: {
                    if (!LoadMods.enableUranium) continue block28;
                    bee.init();
                    continue block28;
                }
                case URANIUM: {
                    if (!LoadMods.enableIC2) continue block28;
                    bee.init();
                    continue block28;
                }
                case ALUMINIUM: {
                    if (!LoadMods.enableAluminium) continue block28;
                    bee.init();
                    continue block28;
                }
                case RUBY: {
                    if (!LoadMods.enableRuby) continue block28;
                    bee.init();
                    continue block28;
                }
                case SAPPHIRE: {
                    if (!LoadMods.enableSapphire) continue block28;
                    bee.init();
                    continue block28;
                }
                case COBALT: {
                    if (!LoadMods.enableTinkers) continue block28;
                    bee.init();
                    continue block28;
                }
                case ARDITE: {
                    if (!LoadMods.enableTinkers) continue block28;
                    bee.init();
                    continue block28;
                }
                case BLUESLIMEY: {
                    if (!LoadMods.enableTinkers) continue block28;
                    bee.init();
                    continue block28;
                }
                case MAGMASLIMEY: {
                    if (!LoadMods.enableTinkers) continue block28;
                    bee.init();
                    continue block28;
                }
                case PURPLESLIMEY: {
                    if (!LoadMods.enableTinkers) continue block28;
                    bee.init();
                    continue block28;
                }
                default: {
                    bee.init();
                }
            }
        }
        block29: for (BeeSpecies bee : BeeSpecies.values()) {
            switch (bee) {
                case LEAD: {
                    if (!LoadMods.enableLead) continue block29;
                    bee.registerMutations();
                    continue block29;
                }
                case SILVER: {
                    if (!LoadMods.enableSilver) continue block29;
                    bee.registerMutations();
                    continue block29;
                }
                case RADIOACTIVE: {
                    if (!LoadMods.enableUranium) continue block29;
                    bee.registerMutations();
                    continue block29;
                }
                case URANIUM: {
                    if (!LoadMods.enableIC2) continue block29;
                    bee.registerMutations();
                    continue block29;
                }
                case ALUMINIUM: {
                    if (!LoadMods.enableAluminium) continue block29;
                    bee.registerMutations();
                    continue block29;
                }
                case RUBY: {
                    if (!LoadMods.enableRuby) continue block29;
                    bee.registerMutations();
                    continue block29;
                }
                case SAPPHIRE: {
                    if (!LoadMods.enableSapphire) continue block29;
                    bee.registerMutations();
                    continue block29;
                }
                case COBALT: {
                    if (!LoadMods.enableTinkers) continue block29;
                    bee.registerMutations();
                    continue block29;
                }
                case ARDITE: {
                    if (!LoadMods.enableTinkers) continue block29;
                    bee.registerMutations();
                    continue block29;
                }
                case BLUESLIMEY: {
                    if (!LoadMods.enableTinkers) continue block29;
                    bee.registerMutations();
                    continue block29;
                }
                case MAGMASLIMEY: {
                    if (!LoadMods.enableTinkers) continue block29;
                    bee.registerMutations();
                    continue block29;
                }
                case PURPLESLIMEY: {
                    if (!LoadMods.enableTinkers) continue block29;
                    bee.registerMutations();
                    continue block29;
                }
                default: {
                    bee.registerMutations();
                }
            }
        }
    }

    public static void preInit() {
    }

    private void init() {
        this.template = this.branch.getTemplate();
        AlleleHelper.instance.set(this.template, (Enum)EnumBeeChromosome.SPECIES, (IAllele)this.species);
        this.setAlleles(this.template);
        this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
        BeeManager.beeRoot.registerTemplate(this.template);
    }

    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    public final IBeeGenome getGenome() {
        return this.genome;
    }

    public final IBee getIndividual() {
        return new Bee(this.genome);
    }

    public final ItemStack getMemberStack(EnumBeeType beeType) {
        IBee bee = this.getIndividual();
        return BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)beeType);
    }

    public final IBeeDefinition getRainResist() {
        return new BeeVariation.RainResist((IBeeDefinition)this);
    }

    static {
        hiveBees = new IAlleleBeeSpecies[]{(IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesForest"), (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesMarshy"), (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesMeadows"), (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesModest"), (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesTropical"), (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesWintry")};
        SteadfastBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesSteadfast");
        CultivatedBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesCultivated");
        FiendishBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesFiendish");
        IndustriousBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesIndustrious");
        ImperialBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesImperial");
        AustereBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesAustere");
        DemonicBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesDemonic");
        EnderBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesEnded");
        BoggyBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesBoggy");
        DiligentBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesDiligent");
        TropicalBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesTropical");
        RockBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesRock");
        HardenedBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesHardened");
        ObsidianBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesObsidian");
        LapisBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesLapis");
        RedstoneBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesRedstone");
        EmeraldBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesEmerald");
        DirtBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesDirt");
        ClayBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesClay");
        MetallicBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesMetallic");
        LeadBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesLead");
        GoldBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesGold");
        TinBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesTin");
        RadioactiveBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesRadioactive");
        UraniumBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesUranium");
        ApocalypticBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesApocalyptic");
        WitherBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesWither");
        SlimeyBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesSlimey");
        BlueSlimeyBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesBlueslimey");
        PrismarineBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesPrismarine");
        CopperBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesCopper");
    }
}

