/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic;

import WayofTime.bloodmagic.ConfigHandler;
import WayofTime.bloodmagic.annot.Handler;
import WayofTime.bloodmagic.api.util.helper.LogHelper;
import WayofTime.bloodmagic.client.gui.GuiHandler;
import WayofTime.bloodmagic.command.CommandBloodMagic;
import WayofTime.bloodmagic.compat.ICompatibility;
import WayofTime.bloodmagic.compat.minecraft.ICrossVersionProxy;
import WayofTime.bloodmagic.meteor.MeteorConfigHandler;
import WayofTime.bloodmagic.network.BloodMagicPacketHandler;
import WayofTime.bloodmagic.proxy.CommonProxy;
import WayofTime.bloodmagic.registry.ModArmourTrackers;
import WayofTime.bloodmagic.registry.ModBlocks;
import WayofTime.bloodmagic.registry.ModCompatibility;
import WayofTime.bloodmagic.registry.ModEntities;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.registry.ModPotions;
import WayofTime.bloodmagic.registry.ModRecipes;
import WayofTime.bloodmagic.registry.ModRituals;
import WayofTime.bloodmagic.registry.ModTranquilityHandlers;
import WayofTime.bloodmagic.structures.ModDungeons;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.handler.IMCHandler;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="BloodMagic", name="Blood Magic: Alchemical Wizardry", version="1.9.4-2.1.0-63", dependencies="required-after:Forge@[12.16.0.1840,);after:JEI@[2.23.0,);required-after:guideapi;", guiFactory="WayofTime.bloodmagic.client.gui.config.ConfigGuiFactory", acceptedMinecraftVersions="[1.9.4]")
public class BloodMagic {
    @SidedProxy(serverSide="WayofTime.bloodmagic.proxy.CommonProxy", clientSide="WayofTime.bloodmagic.proxy.ClientProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="BloodMagic")
    public static BloodMagic instance;
    public static CreativeTabs tabBloodMagic;
    public static CreativeTabs tabUpgradeTome;
    private static boolean isDev;
    private static ICrossVersionProxy crossVersionProxy;
    private static final Map<String, String> PROXY_MAP;
    private LogHelper logger = new LogHelper("BloodMagic");
    private File configDir;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configDir = new File(event.getModConfigurationDirectory(), "BloodMagic");
        ConfigHandler.init(new File(this.getConfigDir(), "BloodMagic.cfg"));
        ModBlocks.init();
        ModItems.init();
        ModPotions.init();
        ModEntities.init();
        ModCompatibility.registerModCompat();
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.PRE_INIT);
        ModTranquilityHandlers.init();
        ModDungeons.init();
        Utils.registerHandlers(event.getAsmData().getAll(Handler.class.getCanonicalName()));
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        BloodMagicPacketHandler.init();
        ModRecipes.init();
        ModRituals.initRituals();
        ModRituals.initImperfectRituals();
        MeteorConfigHandler.init(new File(this.configDir, "meteors"));
        ModArmourTrackers.init();
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.INIT);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModRecipes.addCompressionHandlers();
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.POST_INIT);
        proxy.postInit();
    }

    @Mod.EventHandler
    public void modMapping(FMLModIdMappingEvent event) {
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.MAPPING);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBloodMagic());
    }

    @Mod.EventHandler
    public void onIMCRecieved(FMLInterModComms.IMCEvent event) {
        IMCHandler.handleIMC(event);
    }

    public LogHelper getLogger() {
        return this.logger;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public static boolean isDev() {
        return isDev;
    }

    public static ICrossVersionProxy getCrossVersionProxy() {
        return crossVersionProxy;
    }

    static {
        tabBloodMagic = new CreativeTabs("BloodMagic.creativeTab"){

            public Item func_78016_d() {
                return ModItems.BLOOD_ORB;
            }
        };
        tabUpgradeTome = new CreativeTabs("BloodMagic.creativeTabTome"){

            public Item func_78016_d() {
                return ModItems.UPGRADE_TOME;
            }
        };
        isDev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        PROXY_MAP = ImmutableMap.of((Object)"1.9.4", (Object)"WayofTime.bloodmagic.compat.minecraft.CrossVersionProxy19", (Object)"1.10", (Object)"WayofTime.bloodmagic.compat.minecraft.CrossVersionProxy110", (Object)"1.10.2", (Object)"WayofTime.bloodmagic.compat.minecraft.CrossVersionProxy110");
        try {
            String mcVersion = (String)Loader.class.getDeclaredField("MC_VERSION").get(null);
            if (!PROXY_MAP.containsKey(mcVersion)) {
                throw new IllegalStateException("Blood Magic couldn't find a cross version proxy!");
            }
            Class<?> proxyClass = Class.forName(PROXY_MAP.get(mcVersion));
            crossVersionProxy = (ICrossVersionProxy)proxyClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Blood Magic could not find a cross version proxy!", e);
        }
        FluidRegistry.enableUniversalBucket();
    }
}

