/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.altar;

import WayofTime.bloodmagic.api.BlockStack;
import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.altar.AltarComponent;
import WayofTime.bloodmagic.api.altar.AltarUpgrade;
import WayofTime.bloodmagic.api.altar.EnumAltarComponent;
import WayofTime.bloodmagic.api.altar.EnumAltarTier;
import WayofTime.bloodmagic.api.altar.IAltarComponent;
import WayofTime.bloodmagic.api.event.AltarCraftedEvent;
import WayofTime.bloodmagic.api.orb.IBloodOrb;
import WayofTime.bloodmagic.api.registry.AltarRecipeRegistry;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.block.BlockBloodRune;
import WayofTime.bloodmagic.block.BlockLifeEssence;
import WayofTime.bloodmagic.tile.TileAltar;
import WayofTime.bloodmagic.util.Utils;
import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class BloodAltar
implements IFluidHandler {
    private TileAltar tileAltar;
    private int internalCounter = 0;
    public boolean isActive;
    protected FluidStack fluidOutput = new FluidStack(BlockLifeEssence.getLifeEssence(), 0);
    protected FluidStack fluidInput = new FluidStack(BlockLifeEssence.getLifeEssence(), 0);
    private EnumAltarTier altarTier = EnumAltarTier.ONE;
    private AltarUpgrade upgrade;
    private int capacity = 10000;
    private FluidStack fluid = new FluidStack(BloodMagicAPI.getLifeEssence(), 0);
    private int liquidRequired;
    private boolean canBeFilled;
    private int consumptionRate;
    private int drainRate;
    private float consumptionMultiplier;
    private float efficiencyMultiplier;
    private float sacrificeEfficiencyMultiplier;
    private float selfSacrificeEfficiencyMultiplier;
    private float capacityMultiplier = 1.0f;
    private float orbCapacityMultiplier;
    private float dislocationMultiplier;
    private int accelerationUpgrades;
    private boolean isUpgraded;
    private boolean isResultBlock;
    private int bufferCapacity = 1000;
    private int progress;
    private int lockdownDuration;
    private int demonBloodDuration;
    private int totalCharge = 0;
    private int chargingRate = 0;
    private int chargingFrequency = 0;
    private int maxCharge = 0;
    private int cooldownAfterCrafting = 60;
    private AltarRecipeRegistry.AltarRecipe recipe;
    private ItemStack result;
    private EnumAltarTier currentTierDisplayed = EnumAltarTier.ONE;

    public BloodAltar(TileAltar tileAltar) {
        this.tileAltar = tileAltar;
    }

    public static EnumAltarTier getAltarTier(World world, BlockPos pos) {
        for (int i = EnumAltarTier.MAXTIERS - 1; i >= 1; --i) {
            if (!BloodAltar.checkAltarIsValid(world, pos, i)) continue;
            return EnumAltarTier.values()[i];
        }
        return EnumAltarTier.ONE;
    }

    public static boolean checkAltarIsValid(World world, BlockPos worldPos, int altarTier) {
        for (AltarComponent altarComponent : EnumAltarTier.values()[altarTier].getAltarComponents()) {
            EnumAltarComponent component;
            BlockPos componentPos = worldPos.func_177971_a((Vec3i)altarComponent.getOffset());
            BlockStack worldBlock = new BlockStack(world.func_180495_p(componentPos).func_177230_c(), world.func_180495_p(componentPos).func_177230_c().func_176201_c(world.func_180495_p(componentPos)));
            if (!(altarComponent.getComponent() != EnumAltarComponent.NOTAIR ? (worldBlock.getBlock() instanceof IAltarComponent ? (component = ((IAltarComponent)worldBlock.getBlock()).getType(world, worldBlock.getState(), componentPos)) == null || component != altarComponent.getComponent() : worldBlock.getBlock() != Utils.getBlockForComponent(altarComponent.getComponent())) : world.func_175623_d(componentPos))) continue;
            return false;
        }
        return true;
    }

    public static Pair<BlockPos, EnumAltarComponent> getAltarMissingBlock(World world, BlockPos worldPos, int altarTier) {
        if (altarTier >= EnumAltarTier.MAXTIERS) {
            return null;
        }
        for (AltarComponent altarComponent : EnumAltarTier.values()[altarTier].getAltarComponents()) {
            BlockPos componentPos = worldPos.func_177971_a((Vec3i)altarComponent.getOffset());
            BlockStack worldBlock = new BlockStack(world.func_180495_p(componentPos).func_177230_c(), world.func_180495_p(componentPos).func_177230_c().func_176201_c(world.func_180495_p(componentPos)));
            if (altarComponent.getComponent() != EnumAltarComponent.NOTAIR) {
                if (worldBlock.getBlock() instanceof IAltarComponent) {
                    EnumAltarComponent component = ((IAltarComponent)worldBlock.getBlock()).getType(world, worldBlock.getState(), componentPos);
                    if (component != null && component == altarComponent.getComponent()) continue;
                    return Pair.of((Object)componentPos, (Object)((Object)altarComponent.getComponent()));
                }
                if (worldBlock.getBlock() == Utils.getBlockForComponent(altarComponent.getComponent())) continue;
                return new ImmutablePair((Object)componentPos, (Object)altarComponent.getComponent());
            }
            if (!world.func_175623_d(componentPos)) continue;
            return Pair.of((Object)componentPos, (Object)((Object)altarComponent.getComponent()));
        }
        return null;
    }

    public static AltarUpgrade getUpgrades(World world, BlockPos pos, EnumAltarTier altarTier) {
        if (world.field_72995_K) {
            return null;
        }
        AltarUpgrade upgrades = new AltarUpgrade();
        ArrayList<AltarComponent> list = altarTier.getAltarComponents();
        for (AltarComponent altarComponent : list) {
            BlockStack worldBlock;
            BlockPos componentPos = pos.func_177971_a((Vec3i)altarComponent.getOffset());
            if (!altarComponent.isUpgradeSlot() || !((worldBlock = new BlockStack(world.func_180495_p(componentPos).func_177230_c(), world.func_180495_p(componentPos).func_177230_c().func_176201_c(world.func_180495_p(componentPos)))).getBlock() instanceof BlockBloodRune)) continue;
            switch (((BlockBloodRune)worldBlock.getBlock()).getRuneEffect(worldBlock.getMeta())) {
                case 1: {
                    upgrades.addSpeed();
                    break;
                }
                case 2: {
                    upgrades.addEfficiency();
                    break;
                }
                case 3: {
                    upgrades.addSacrifice();
                    break;
                }
                case 4: {
                    upgrades.addSelfSacrifice();
                    break;
                }
                case 5: {
                    upgrades.addDisplacement();
                    break;
                }
                case 6: {
                    upgrades.addCapacity();
                    break;
                }
                case 7: {
                    upgrades.addBetterCapacity();
                    break;
                }
                case 8: {
                    upgrades.addOrbCapacity();
                    break;
                }
                case 9: {
                    upgrades.addAcceleration();
                    break;
                }
                case 10: {
                    upgrades.addCharging();
                }
            }
        }
        return upgrades;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (!tagCompound.func_74764_b("Empty")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound);
            if (fluid != null) {
                this.setMainFluid(fluid);
            }
            FluidStack fluidOut = new FluidStack(BloodMagicAPI.getLifeEssence(), tagCompound.func_74762_e("outputAmount"));
            this.setOutputFluid(fluidOut);
            FluidStack fluidIn = new FluidStack(BloodMagicAPI.getLifeEssence(), tagCompound.func_74762_e("inputAmount"));
            this.setInputFluid(fluidIn);
        }
        this.internalCounter = tagCompound.func_74762_e("internalCounter");
        this.altarTier = (EnumAltarTier)((Object)Enums.getIfPresent(EnumAltarTier.class, (String)tagCompound.func_74779_i("upgradeLevel")).or((Object)EnumAltarTier.ONE));
        this.isActive = tagCompound.func_74767_n("isActive");
        this.liquidRequired = tagCompound.func_74762_e("liquidRequired");
        this.canBeFilled = tagCompound.func_74767_n("fillable");
        this.isUpgraded = tagCompound.func_74767_n("isUpgraded");
        this.consumptionRate = tagCompound.func_74762_e("consumptionRate");
        this.drainRate = tagCompound.func_74762_e("drainRate");
        this.consumptionMultiplier = tagCompound.func_74760_g("consumptionMultiplier");
        this.efficiencyMultiplier = tagCompound.func_74760_g("efficiencyMultiplier");
        this.selfSacrificeEfficiencyMultiplier = tagCompound.func_74760_g("selfSacrificeMultiplier");
        this.sacrificeEfficiencyMultiplier = tagCompound.func_74760_g("sacrificeMultiplier");
        this.capacityMultiplier = tagCompound.func_74760_g("capacityMultiplier");
        this.orbCapacityMultiplier = tagCompound.func_74760_g("orbCapacityMultiplier");
        this.dislocationMultiplier = tagCompound.func_74760_g("dislocationMultiplier");
        this.capacity = tagCompound.func_74762_e("capacity");
        this.bufferCapacity = tagCompound.func_74762_e("bufferCapacity");
        this.progress = tagCompound.func_74762_e("progress");
        this.isResultBlock = tagCompound.func_74767_n("isResultBlock");
        this.lockdownDuration = tagCompound.func_74762_e("lockdownDuration");
        this.accelerationUpgrades = tagCompound.func_74762_e("accelerationUpgrades");
        this.demonBloodDuration = tagCompound.func_74762_e("demonBloodDuration");
        this.cooldownAfterCrafting = tagCompound.func_74762_e("cooldownAfterCrafting");
        this.chargingRate = tagCompound.func_74762_e("chargeRate");
        this.chargingFrequency = tagCompound.func_74762_e("chargeFrequency");
        this.totalCharge = tagCompound.func_74762_e("totalCharge");
        this.maxCharge = tagCompound.func_74762_e("maxCharge");
        this.currentTierDisplayed = (EnumAltarTier)((Object)Enums.getIfPresent(EnumAltarTier.class, (String)tagCompound.func_74779_i("currentTierDisplayed")).or((Object)EnumAltarTier.ONE));
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        if (this.fluid != null) {
            this.fluid.writeToNBT(tagCompound);
        } else {
            tagCompound.func_74778_a("Empty", "");
        }
        if (this.fluidOutput != null) {
            tagCompound.func_74768_a("outputAmount", this.fluidOutput.amount);
        }
        if (this.fluidInput != null) {
            tagCompound.func_74768_a("inputAmount", this.fluidInput.amount);
        }
        tagCompound.func_74768_a("internalCounter", this.internalCounter);
        tagCompound.func_74778_a("upgradeLevel", this.altarTier.name());
        tagCompound.func_74757_a("isActive", this.isActive);
        tagCompound.func_74768_a("liquidRequired", this.liquidRequired);
        tagCompound.func_74757_a("fillable", this.canBeFilled);
        tagCompound.func_74757_a("isUpgraded", this.isUpgraded);
        tagCompound.func_74768_a("consumptionRate", this.consumptionRate);
        tagCompound.func_74768_a("drainRate", this.drainRate);
        tagCompound.func_74776_a("consumptionMultiplier", this.consumptionMultiplier);
        tagCompound.func_74776_a("efficiencyMultiplier", this.efficiencyMultiplier);
        tagCompound.func_74776_a("sacrificeMultiplier", this.sacrificeEfficiencyMultiplier);
        tagCompound.func_74776_a("selfSacrificeMultiplier", this.selfSacrificeEfficiencyMultiplier);
        tagCompound.func_74757_a("isResultBlock", this.isResultBlock);
        tagCompound.func_74776_a("capacityMultiplier", this.capacityMultiplier);
        tagCompound.func_74776_a("orbCapacityMultiplier", this.orbCapacityMultiplier);
        tagCompound.func_74776_a("dislocationMultiplier", this.dislocationMultiplier);
        tagCompound.func_74768_a("capacity", this.capacity);
        tagCompound.func_74768_a("progress", this.progress);
        tagCompound.func_74768_a("bufferCapacity", this.bufferCapacity);
        tagCompound.func_74768_a("lockdownDuration", this.lockdownDuration);
        tagCompound.func_74768_a("accelerationUpgrades", this.accelerationUpgrades);
        tagCompound.func_74768_a("demonBloodDuration", this.demonBloodDuration);
        tagCompound.func_74768_a("cooldownAfterCrafting", this.cooldownAfterCrafting);
        tagCompound.func_74768_a("chargeRate", this.chargingRate);
        tagCompound.func_74768_a("chargeFrequency", this.chargingFrequency);
        tagCompound.func_74768_a("totalCharge", this.totalCharge);
        tagCompound.func_74768_a("maxCharge", this.maxCharge);
        tagCompound.func_74778_a("currentTierDisplayed", this.currentTierDisplayed.name());
    }

    public void startCycle() {
        AltarRecipeRegistry.AltarRecipe recipe;
        if (this.tileAltar.func_145831_w() != null) {
            this.tileAltar.func_145831_w().func_184138_a(this.tileAltar.func_174877_v(), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), 3);
        }
        this.checkTier();
        if ((this.fluid == null || this.fluid.amount <= 0) && this.totalCharge <= 0) {
            return;
        }
        if (!this.isActive) {
            this.progress = 0;
        }
        if (this.tileAltar.func_70301_a(0) != null && (recipe = AltarRecipeRegistry.getRecipeForInput(this.tileAltar.func_70301_a(0))) != null && recipe.doesRequiredItemMatch(this.tileAltar.func_70301_a(0), this.altarTier)) {
            this.isActive = true;
            this.recipe = recipe;
            this.result = recipe.getOutput() == null ? null : new ItemStack(recipe.getOutput().func_77973_b(), 1, recipe.getOutput().func_77960_j());
            this.liquidRequired = recipe.getSyphon();
            this.canBeFilled = recipe.isFillable();
            this.consumptionRate = recipe.getConsumeRate();
            this.drainRate = recipe.getDrainRate();
            return;
        }
        this.isActive = false;
    }

    public void update() {
        World world = this.tileAltar.func_145831_w();
        BlockPos pos = this.tileAltar.func_174877_v();
        if (world.field_72995_K) {
            return;
        }
        ++this.internalCounter;
        if (this.lockdownDuration > 0) {
            --this.lockdownDuration;
        }
        if (this.internalCounter % 20 == 0) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos newPos = pos.func_177972_a(facing);
                IBlockState block = world.func_180495_p(newPos);
                block.func_177230_c().func_189540_a(block, world, newPos, block.func_177230_c());
            }
        }
        if (this.internalCounter % Math.max(20 - this.accelerationUpgrades, 1) == 0) {
            int syphonMax = (int)(20.0f * this.dislocationMultiplier);
            int fluidInputted = Math.min(syphonMax, -this.fluid.amount + this.capacity);
            fluidInputted = Math.min(this.fluidInput.amount, fluidInputted);
            this.fluid.amount += fluidInputted;
            this.fluidInput.amount -= fluidInputted;
            int fluidOutputted = Math.min(syphonMax, this.bufferCapacity - this.fluidOutput.amount);
            fluidOutputted = Math.min(this.fluid.amount, fluidOutputted);
            this.fluidOutput.amount += fluidOutputted;
            this.fluid.amount -= fluidOutputted;
            this.tileAltar.func_145831_w().func_184138_a(this.tileAltar.func_174877_v(), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), 3);
        }
        if (this.internalCounter % this.getChargingFrequency() == 0 && !this.isActive) {
            int chargeInputted = Math.min(this.chargingRate, this.fluid.amount);
            chargeInputted = Math.min(chargeInputted, this.maxCharge - this.totalCharge);
            this.totalCharge += chargeInputted;
            this.fluid.amount -= chargeInputted;
            this.tileAltar.func_145831_w().func_184138_a(this.tileAltar.func_174877_v(), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), 3);
        }
        if (this.internalCounter % 100 == 0 && (this.isActive || this.cooldownAfterCrafting <= 0)) {
            this.startCycle();
        }
        this.updateAltar();
    }

    private void updateAltar() {
        if (!this.isActive) {
            if (this.cooldownAfterCrafting > 0) {
                --this.cooldownAfterCrafting;
            }
            return;
        }
        if (this.tileAltar.func_70301_a(0) == null) {
            return;
        }
        World world = this.tileAltar.func_145831_w();
        BlockPos pos = this.tileAltar.func_174877_v();
        if (world.field_72995_K) {
            return;
        }
        if (!this.canBeFilled) {
            WorldServer server;
            boolean hasOperated = false;
            int stackSize = this.tileAltar.func_70301_a((int)0).field_77994_a;
            if (this.totalCharge > 0) {
                int chargeDrained = Math.min(this.liquidRequired * stackSize - this.progress, this.totalCharge);
                this.totalCharge -= chargeDrained;
                this.progress += chargeDrained;
                hasOperated = true;
            }
            if (this.fluid != null && this.fluid.amount >= 1) {
                int liquidDrained = Math.min((int)(this.altarTier.ordinal() >= 2 ? (float)this.consumptionRate * (1.0f + this.consumptionMultiplier) : (float)this.consumptionRate), this.fluid.amount);
                if (liquidDrained > this.liquidRequired * stackSize - this.progress) {
                    liquidDrained = this.liquidRequired * stackSize - this.progress;
                }
                this.fluid.amount -= liquidDrained;
                this.progress += liquidDrained;
                hasOperated = true;
                if (this.internalCounter % 4 == 0 && world instanceof WorldServer) {
                    server = (WorldServer)world;
                    server.func_175739_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 1, 0.2, 0.0, 0.2, 0.0, new int[0]);
                }
            } else if (!hasOperated && this.progress > 0) {
                this.progress -= (int)(this.efficiencyMultiplier * (float)this.drainRate);
                if (this.internalCounter % 2 == 0 && world instanceof WorldServer) {
                    WorldServer server2 = (WorldServer)world;
                    server2.func_175739_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 1, 0.1, 0.0, 0.1, 0.0, new int[0]);
                }
            }
            if (hasOperated && this.progress >= this.liquidRequired * stackSize) {
                ItemStack result = this.result;
                if (result != null) {
                    result.field_77994_a *= stackSize;
                }
                MinecraftForge.EVENT_BUS.post((Event)new AltarCraftedEvent(this.recipe, result));
                this.tileAltar.func_70299_a(0, result);
                this.progress = 0;
                if (world instanceof WorldServer) {
                    server = (WorldServer)world;
                    server.func_175739_a(EnumParticleTypes.REDSTONE, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 40, 0.3, 0.0, 0.3, 0.0, new int[0]);
                }
                this.cooldownAfterCrafting = 30;
                this.isActive = false;
            }
        } else {
            ItemStack returnedItem = this.tileAltar.func_70301_a(0);
            if (!(returnedItem.func_77973_b() instanceof IBloodOrb)) {
                return;
            }
            IBloodOrb item = (IBloodOrb)returnedItem.func_77973_b();
            NBTTagCompound itemTag = returnedItem.func_77978_p();
            if (itemTag == null) {
                return;
            }
            String ownerUUID = itemTag.func_74779_i("ownerUUID");
            if (Strings.isNullOrEmpty((String)ownerUUID)) {
                return;
            }
            if (this.fluid != null && this.fluid.amount >= 1) {
                int liquidDrained = Math.min((int)(this.altarTier.ordinal() >= 2 ? (float)this.consumptionRate * (1.0f + this.consumptionMultiplier) : (float)this.consumptionRate), this.fluid.amount);
                int drain = NetworkHelper.getSoulNetwork(ownerUUID).add(liquidDrained, (int)((float)item.getMaxEssence(returnedItem.func_77960_j()) * this.orbCapacityMultiplier));
                this.fluid.amount -= drain;
                if (drain > 0 && this.internalCounter % 4 == 0 && world instanceof WorldServer) {
                    WorldServer server = (WorldServer)world;
                    server.func_175739_a(EnumParticleTypes.SPELL_WITCH, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.001, new int[0]);
                }
            }
        }
        this.tileAltar.func_145831_w().func_184138_a(this.tileAltar.func_174877_v(), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), 3);
    }

    public void checkTier() {
        EnumAltarTier tier;
        this.altarTier = tier = BloodAltar.getAltarTier(this.tileAltar.func_145831_w(), this.tileAltar.func_174877_v());
        this.upgrade = BloodAltar.getUpgrades(this.tileAltar.func_145831_w(), this.tileAltar.func_174877_v(), tier);
        if (tier.equals((Object)this.currentTierDisplayed)) {
            this.currentTierDisplayed = EnumAltarTier.ONE;
        }
        if (tier.equals((Object)EnumAltarTier.ONE)) {
            this.upgrade = null;
            this.isUpgraded = false;
            this.consumptionMultiplier = 0.0f;
            this.efficiencyMultiplier = 1.0f;
            this.sacrificeEfficiencyMultiplier = 0.0f;
            this.selfSacrificeEfficiencyMultiplier = 0.0f;
            this.capacityMultiplier = 1.0f;
            this.orbCapacityMultiplier = 1.0f;
            this.dislocationMultiplier = 1.0f;
            this.accelerationUpgrades = 0;
            this.chargingFrequency = 20;
            this.chargingRate = 0;
            this.maxCharge = 0;
            this.totalCharge = 0;
            return;
        }
        if (!tier.equals((Object)EnumAltarTier.ONE) && this.upgrade != null) {
            this.isUpgraded = true;
            this.consumptionMultiplier = (float)(0.2 * (double)this.upgrade.getSpeedCount());
            this.efficiencyMultiplier = (float)Math.pow(0.85, this.upgrade.getEfficiencyCount());
            this.sacrificeEfficiencyMultiplier = (float)(0.1 * (double)this.upgrade.getSacrificeCount());
            this.selfSacrificeEfficiencyMultiplier = (float)(0.1 * (double)this.upgrade.getSelfSacrificeCount());
            this.capacityMultiplier = (float)(1.0 * Math.pow(1.1, this.upgrade.getBetterCapacityCount()) + 0.2 * (double)this.upgrade.getCapacityCount());
            this.dislocationMultiplier = (float)Math.pow(1.2, this.upgrade.getDisplacementCount());
            this.orbCapacityMultiplier = (float)(1.0 + 0.02 * (double)this.upgrade.getOrbCapacityCount());
            this.accelerationUpgrades = this.upgrade.getAccelerationCount();
            this.chargingFrequency = Math.max(20 - this.upgrade.getAccelerationCount(), 1);
            this.chargingRate = 100 * this.upgrade.getChargingCount();
            this.maxCharge = (int)(1000.0 * Math.max(0.5 * (double)this.capacityMultiplier, 1.0) * (double)this.upgrade.getChargingCount());
        }
        this.capacity = (int)(10000.0f * this.capacityMultiplier);
        this.bufferCapacity = (int)(1000.0f * this.capacityMultiplier);
        if (this.fluid.amount > this.capacity) {
            this.fluid.amount = this.capacity;
        }
        if (this.fluidOutput.amount > this.bufferCapacity) {
            this.fluidOutput.amount = this.bufferCapacity;
        }
        if (this.fluidInput.amount > this.bufferCapacity) {
            this.fluidInput.amount = this.bufferCapacity;
        }
        if (this.totalCharge > this.maxCharge) {
            this.totalCharge = this.maxCharge;
        }
        this.tileAltar.func_145831_w().func_184138_a(this.tileAltar.func_174877_v(), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), this.tileAltar.func_145831_w().func_180495_p(this.tileAltar.func_174877_v()), 3);
    }

    public int fillMainTank(int amount) {
        int filledAmount = Math.min(this.capacity - this.fluid.amount, amount);
        this.fluid.amount += filledAmount;
        return filledAmount;
    }

    public void sacrificialDaggerCall(int amount, boolean isSacrifice) {
        if (this.lockdownDuration > 0) {
            int amt = (int)Math.min((float)(this.bufferCapacity - this.fluidInput.amount), (isSacrifice ? 1.0f + this.sacrificeEfficiencyMultiplier : 1.0f + this.selfSacrificeEfficiencyMultiplier) * (float)amount);
            this.fluidInput.amount += amt;
        } else {
            this.fluid.amount = (int)((float)this.fluid.amount + Math.min((float)(this.capacity - this.fluid.amount), (isSacrifice ? 1.0f + this.sacrificeEfficiencyMultiplier : 1.0f + this.selfSacrificeEfficiencyMultiplier) * (float)amount));
        }
    }

    public void setMainFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public void setOutputFluid(FluidStack fluid) {
        this.fluidOutput = fluid;
    }

    public void setInputFluid(FluidStack fluid) {
        this.fluidInput = fluid;
    }

    public AltarUpgrade getUpgrade() {
        return this.upgrade;
    }

    public void setUpgrade(AltarUpgrade upgrade) {
        this.upgrade = upgrade;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluid.amount;
    }

    public int getCurrentBlood() {
        return this.getFluidAmount();
    }

    public EnumAltarTier getTier() {
        return this.altarTier;
    }

    public void setTier(EnumAltarTier tier) {
        this.altarTier = tier;
    }

    public int getProgress() {
        return this.progress;
    }

    public float getSacrificeMultiplier() {
        return this.sacrificeEfficiencyMultiplier;
    }

    public float getSelfSacrificeMultiplier() {
        return this.selfSacrificeEfficiencyMultiplier;
    }

    public float getOrbMultiplier() {
        return this.orbCapacityMultiplier;
    }

    public float getDislocationMultiplier() {
        return this.dislocationMultiplier;
    }

    public float getConsumptionMultiplier() {
        return this.consumptionMultiplier;
    }

    public float getConsumptionRate() {
        return this.consumptionRate;
    }

    public int getLiquidRequired() {
        return this.liquidRequired;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public boolean setCurrentTierDisplayed(EnumAltarTier altarTier) {
        if (this.currentTierDisplayed == altarTier) {
            return false;
        }
        this.currentTierDisplayed = altarTier;
        return true;
    }

    public void addToDemonBloodDuration(int dur) {
        this.demonBloodDuration += dur;
    }

    public boolean hasDemonBlood() {
        return this.demonBloodDuration > 0;
    }

    public void decrementDemonBlood() {
        this.demonBloodDuration = Math.max(0, this.demonBloodDuration - 1);
    }

    public void setActive() {
        if (this.tileAltar.func_70301_a(0) == null) {
            this.isActive = false;
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void requestPauseAfterCrafting(int amount) {
        if (this.isActive) {
            this.cooldownAfterCrafting = amount;
        }
    }

    public int getChargingRate() {
        return this.chargingRate;
    }

    public int getTotalCharge() {
        return this.totalCharge;
    }

    public int getChargingFrequency() {
        return this.chargingFrequency == 0 ? 1 : this.chargingFrequency;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() != BlockLifeEssence.getLifeEssence()) {
            return 0;
        }
        if (!doFill) {
            if (this.fluidInput == null) {
                return Math.min(this.bufferCapacity, resource.amount);
            }
            if (!this.fluidInput.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.bufferCapacity - this.fluidInput.amount, resource.amount);
        }
        if (this.fluidInput == null) {
            this.fluidInput = new FluidStack(resource, Math.min(this.bufferCapacity, resource.amount));
            return this.fluidInput.amount;
        }
        if (!this.fluidInput.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.bufferCapacity - this.fluidInput.amount;
        if (resource.amount < filled) {
            this.fluidInput.amount += resource.amount;
            filled = resource.amount;
        } else {
            this.fluidInput.amount = this.bufferCapacity;
        }
        return filled;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.fluidOutput)) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.fluidOutput == null) {
            return null;
        }
        int drained = maxDrain;
        if (this.fluidOutput.amount < drained) {
            drained = this.fluidOutput.amount;
        }
        FluidStack stack = new FluidStack(this.fluidOutput, drained);
        if (doDrain) {
            this.fluidOutput.amount -= drained;
        }
        return stack;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return fluid == BlockLifeEssence.getLifeEssence();
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return fluid == BlockLifeEssence.getLifeEssence();
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo(this.fluid, this.capacity)};
    }

    public EnumAltarTier getCurrentTierDisplayed() {
        return this.currentTierDisplayed;
    }

    static {
        EnumAltarTier.ONE.buildComponents();
        EnumAltarTier.TWO.buildComponents();
        EnumAltarTier.THREE.buildComponents();
        EnumAltarTier.FOUR.buildComponents();
        EnumAltarTier.FIVE.buildComponents();
        EnumAltarTier.SIX.buildComponents();
    }
}

