/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.compress;

import WayofTime.bloodmagic.api.compress.CompressionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class CompressionRegistry {
    public static List<CompressionHandler> compressionRegistry = new ArrayList<CompressionHandler>();
    public static Map<ItemStack, Integer> thresholdMap = new HashMap<ItemStack, Integer>();

    public static void registerHandler(CompressionHandler handler) {
        compressionRegistry.add(handler);
    }

    public static void registerItemThreshold(ItemStack stack, int threshold) {
        thresholdMap.put(stack, threshold);
    }

    public static ItemStack compressInventory(ItemStack[] inv, World world) {
        for (CompressionHandler handler : compressionRegistry) {
            ItemStack stack = handler.compressInventory(inv, world);
            if (stack == null) continue;
            return stack;
        }
        return null;
    }

    public static int getItemThreshold(ItemStack stack) {
        for (Map.Entry<ItemStack, Integer> entry : thresholdMap.entrySet()) {
            if (!CompressionRegistry.areItemStacksEqual(entry.getKey(), stack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public static boolean areItemStacksEqual(ItemStack stack, ItemStack compressedStack) {
        return stack.func_77969_a(compressedStack) && (stack.func_77978_p() == null ? compressedStack.func_77978_p() == null : stack.func_77978_p().equals((Object)compressedStack.func_77978_p()));
    }
}

