/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.livingArmour;

import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class LivingArmourHandler {
    public static List<Class<? extends StatTracker>> trackers = new ArrayList<Class<? extends StatTracker>>();
    public static HashMap<String, Class<? extends LivingArmourUpgrade>> upgradeMap = new HashMap();
    public static HashMap<String, Constructor<? extends LivingArmourUpgrade>> upgradeConstructorMap = new HashMap();
    public static HashMap<String, Integer> upgradeMaxLevelMap = new HashMap();

    public static void registerStatTracker(Class<? extends StatTracker> tracker) {
        trackers.add(tracker);
    }

    public static void registerArmourUpgrade(LivingArmourUpgrade upgrade) {
        Class<?> clazz = upgrade.getClass();
        upgradeMap.put(upgrade.getUniqueIdentifier(), clazz);
        upgradeMaxLevelMap.put(upgrade.getUniqueIdentifier(), upgrade.getMaxTier());
        try {
            Constructor<?> ctor = clazz.getConstructor(Integer.TYPE);
            if (ctor == null) {
                BloodMagicAPI.getLogger().error("Error adding living armour upgrade {} as it doesn't have a valid constructor.", upgrade.getUniqueIdentifier());
            } else {
                upgradeConstructorMap.put(upgrade.getUniqueIdentifier(), ctor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LivingArmourUpgrade generateUpgradeFromKey(String key, int level) {
        return LivingArmourHandler.generateUpgradeFromKey(key, level, null);
    }

    public static LivingArmourUpgrade generateUpgradeFromKey(String key, int level, NBTTagCompound tag) {
        Constructor<? extends LivingArmourUpgrade> ctor = upgradeConstructorMap.get(key);
        if (ctor != null) {
            try {
                LivingArmourUpgrade upgrade = ctor.newInstance(level);
                if (upgrade != null && tag != null) {
                    upgrade.readFromNBT(tag);
                }
                return upgrade;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

