/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.registry;

import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.ritual.Ritual;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RitualRegistry {
    public static final Map<Ritual, Boolean> enabledRituals = new HashMap<Ritual, Boolean>();
    private static final BiMap<String, Ritual> registry = HashBiMap.create();
    private static final ArrayList<String> orderedIdList = new ArrayList();

    public static void registerRitual(Ritual ritual, String id, boolean enabled) {
        if (ritual != null) {
            if (registry.containsKey((Object)id)) {
                BloodMagicAPI.getLogger().error("Duplicate ritual id: %s", id);
            } else {
                registry.put((Object)id, (Object)ritual);
                enabledRituals.put(ritual, enabled);
                orderedIdList.add(id);
            }
        }
    }

    public static void registerRitual(Ritual ritual, boolean enabled) {
        RitualRegistry.registerRitual(ritual, ritual.getName(), enabled);
    }

    public static void registerRitual(Ritual ritual, String id) {
        RitualRegistry.registerRitual(ritual, id, true);
    }

    public static void registerRitual(Ritual ritual) {
        RitualRegistry.registerRitual(ritual, ritual.getName());
    }

    public static Ritual getRitualForId(String id) {
        Ritual ritual = (Ritual)registry.get((Object)id);
        return ritual != null ? ritual.getNewCopy() : null;
    }

    public static String getIdForRitual(Ritual ritual) {
        return (String)registry.inverse().get((Object)ritual);
    }

    public static boolean isMapEmpty() {
        return registry.isEmpty();
    }

    public static int getMapSize() {
        return registry.size();
    }

    public static boolean ritualEnabled(Ritual ritual) {
        try {
            return enabledRituals.get(ritual);
        }
        catch (NullPointerException e) {
            BloodMagicAPI.getLogger().error("Invalid Ritual was called", new Object[0]);
            return false;
        }
    }

    public static boolean ritualEnabled(String id) {
        return RitualRegistry.ritualEnabled(RitualRegistry.getRitualForId(id));
    }

    public static BiMap<String, Ritual> getRegistry() {
        return HashBiMap.create(registry);
    }

    public static Map<Ritual, Boolean> getEnabledMap() {
        return new HashMap<Ritual, Boolean>(enabledRituals);
    }

    public static ArrayList<String> getIds() {
        return new ArrayList<String>(registry.keySet());
    }

    public static ArrayList<String> getOrderedIds() {
        return orderedIdList;
    }

    public static ArrayList<Ritual> getRituals() {
        return new ArrayList<Ritual>(registry.values());
    }
}

