/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.saving;

import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.event.AddToNetworkEvent;
import WayofTime.bloodmagic.api.event.SoulNetworkEvent;
import WayofTime.bloodmagic.api.saving.BMWorldSavedData;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import com.google.common.base.Strings;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SoulNetwork
implements INBTSerializable<NBTTagCompound> {
    private BMWorldSavedData parent;
    private EntityPlayer cachedPlayer;
    private UUID playerId;
    private int currentEssence;
    private int orbTier;

    private SoulNetwork() {
    }

    public int add(int toAdd, int maximum) {
        AddToNetworkEvent event = new AddToNetworkEvent(this.playerId.toString(), toAdd, maximum);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return 0;
        }
        if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return 0;
        }
        int currEss = this.getCurrentEssence();
        if (currEss >= event.maximum) {
            return 0;
        }
        int newEss = Math.min(event.maximum, currEss + event.addedAmount);
        if (event.getResult() != Event.Result.DENY) {
            this.setCurrentEssence(newEss);
        }
        return newEss - currEss;
    }

    @Deprecated
    public int addLifeEssence(int toAdd, int maximum) {
        return this.add(toAdd, maximum);
    }

    public int syphon(int syphon) {
        if (this.getCurrentEssence() >= syphon) {
            this.setCurrentEssence(this.getCurrentEssence() - syphon);
            return syphon;
        }
        return 0;
    }

    public boolean syphonAndDamage(EntityPlayer user, int toSyphon) {
        if (user != null) {
            if (user.field_70170_p.field_72995_K) {
                return false;
            }
            if (!Strings.isNullOrEmpty((String)this.playerId.toString())) {
                SoulNetworkEvent.ItemDrainNetworkEvent event = new SoulNetworkEvent.ItemDrainNetworkEvent(user, this.playerId.toString(), null, toSyphon);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return false;
                }
                int drainAmount = this.syphon(event.syphon);
                if (drainAmount <= 0 || event.shouldDamage) {
                    this.hurtPlayer(user, event.syphon);
                }
                return event.getResult() != Event.Result.DENY;
            }
            int amount = this.syphon(toSyphon);
            this.hurtPlayer(user, toSyphon - amount);
            return true;
        }
        return false;
    }

    public void causeNausea() {
        if (this.getPlayer() != null) {
            this.getPlayer().func_70690_d(new PotionEffect(MobEffects.field_76431_k, 99));
        }
    }

    @Deprecated
    public void causeNauseaToPlayer() {
        this.causeNausea();
    }

    public void hurtPlayer(EntityPlayer user, float syphon) {
        if (user != null) {
            if (syphon < 100.0f && syphon > 0.0f) {
                if (!user.field_71075_bZ.field_75098_d) {
                    user.field_70172_ad = 0;
                    user.func_70097_a(BloodMagicAPI.getDamageSource(), 1.0f);
                }
            } else if (syphon >= 100.0f && !user.field_71075_bZ.field_75098_d) {
                int i = 0;
                while ((float)i < (syphon + 99.0f) / 100.0f) {
                    user.field_70172_ad = 0;
                    user.func_70097_a(BloodMagicAPI.getDamageSource(), 1.0f);
                    ++i;
                }
            }
        }
    }

    private void markDirty() {
        if (this.getParent() != null) {
            this.getParent().func_76185_a();
        } else {
            BloodMagicAPI.getLogger().error("A SoulNetwork was created, but a parent was not set to allow saving.", new Object[0]);
        }
    }

    @Nullable
    public EntityPlayer getPlayer() {
        if (this.cachedPlayer == null) {
            this.cachedPlayer = PlayerHelper.getPlayerFromUUID(this.playerId);
        }
        return this.cachedPlayer;
    }

    public SoulNetwork setCurrentEssence(int currentEssence) {
        this.currentEssence = currentEssence;
        this.markDirty();
        return this;
    }

    public SoulNetwork setOrbTier(int orbTier) {
        this.orbTier = orbTier;
        this.markDirty();
        return this;
    }

    public SoulNetwork setParent(BMWorldSavedData parent) {
        this.parent = parent;
        this.markDirty();
        return this;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("playerId", this.getPlayerId().toString());
        tagCompound.func_74768_a("currentEssence", this.getCurrentEssence());
        tagCompound.func_74768_a("orbTier", this.getOrbTier());
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.playerId = UUID.fromString(nbt.func_74779_i("playerId"));
        this.currentEssence = nbt.func_74762_e("currentEssence");
        this.orbTier = nbt.func_74762_e("orbTier");
    }

    public static SoulNetwork fromNBT(NBTTagCompound tagCompound) {
        SoulNetwork soulNetwork = new SoulNetwork();
        soulNetwork.deserializeNBT(tagCompound);
        return soulNetwork;
    }

    public static SoulNetwork newEmpty(UUID uuid) {
        SoulNetwork network = new SoulNetwork();
        network.playerId = uuid;
        return network;
    }

    public BMWorldSavedData getParent() {
        return this.parent;
    }

    public EntityPlayer getCachedPlayer() {
        return this.cachedPlayer;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public int getCurrentEssence() {
        return this.currentEssence;
    }

    public int getOrbTier() {
        return this.orbTier;
    }
}

