/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.soul;

import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.api.soul.IDemonWill;
import WayofTime.bloodmagic.api.soul.IDemonWillGem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PlayerDemonWillHandler {
    public static double getTotalDemonWill(EnumDemonWillType type, EntityPlayer player) {
        ItemStack[] inventory = player.field_71071_by.field_70462_a;
        double souls = 0.0;
        for (ItemStack stack : inventory) {
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof IDemonWill) {
                souls += ((IDemonWill)stack.func_77973_b()).getWill(stack);
                continue;
            }
            if (!(stack.func_77973_b() instanceof IDemonWillGem)) continue;
            souls += ((IDemonWillGem)stack.func_77973_b()).getWill(type, stack);
        }
        return souls;
    }

    public static EnumDemonWillType getLargestWillType(EntityPlayer player) {
        EnumDemonWillType type = EnumDemonWillType.DEFAULT;
        double max = PlayerDemonWillHandler.getTotalDemonWill(type, player);
        for (EnumDemonWillType testType : EnumDemonWillType.values()) {
            double value = PlayerDemonWillHandler.getTotalDemonWill(testType, player);
            if (!(value > max)) continue;
            type = testType;
        }
        return type;
    }

    public static boolean isDemonWillFull(EnumDemonWillType type, EntityPlayer player) {
        ItemStack[] inventory = player.field_71071_by.field_70462_a;
        boolean hasGem = false;
        for (ItemStack stack : inventory) {
            if (stack == null || !(stack.func_77973_b() instanceof IDemonWillGem)) continue;
            hasGem = true;
            if (!(((IDemonWillGem)stack.func_77973_b()).getWill(type, stack) < (double)((IDemonWillGem)stack.func_77973_b()).getMaxWill(type, stack))) continue;
            return false;
        }
        return hasGem;
    }

    public static double consumeDemonWill(EnumDemonWillType type, EntityPlayer player, double amount) {
        double consumed = 0.0;
        ItemStack[] inventory = player.field_71071_by.field_70462_a;
        for (int i = 0; i < inventory.length; ++i) {
            if (consumed >= amount) {
                return consumed;
            }
            ItemStack stack = inventory[i];
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof IDemonWill) {
                consumed += ((IDemonWill)stack.func_77973_b()).drainWill(stack, amount - consumed);
                if (!(((IDemonWill)stack.func_77973_b()).getWill(stack) <= 0.0)) continue;
                inventory[i] = null;
                continue;
            }
            if (!(stack.func_77973_b() instanceof IDemonWillGem)) continue;
            consumed += ((IDemonWillGem)stack.func_77973_b()).drainWill(type, stack, amount - consumed, true);
        }
        return consumed;
    }

    public static ItemStack addDemonWill(EntityPlayer player, ItemStack willStack) {
        ItemStack[] inventory;
        if (willStack == null) {
            return null;
        }
        for (ItemStack stack : inventory = player.field_71071_by.field_70462_a) {
            ItemStack newStack;
            if (stack == null || !(stack.func_77973_b() instanceof IDemonWillGem) || (newStack = ((IDemonWillGem)stack.func_77973_b()).fillDemonWillGem(stack, willStack)) != null) continue;
            return null;
        }
        return willStack;
    }

    public static double addDemonWill(EnumDemonWillType type, EntityPlayer player, double amount) {
        ItemStack stack;
        ItemStack[] inventory = player.field_71071_by.field_70462_a;
        double remaining = amount;
        ItemStack[] itemStackArray = inventory;
        int n = itemStackArray.length;
        for (int i = 0; !(i >= n || (stack = itemStackArray[i]) != null && stack.func_77973_b() instanceof IDemonWillGem && (remaining -= ((IDemonWillGem)stack.func_77973_b()).fillWill(type, stack, remaining, true)) <= 0.0); ++i) {
        }
        return amount - remaining;
    }

    public static double addDemonWill(EnumDemonWillType type, EntityPlayer player, double amount, ItemStack ignored) {
        ItemStack stack;
        ItemStack[] inventory = player.field_71071_by.field_70462_a;
        double remaining = amount;
        ItemStack[] itemStackArray = inventory;
        int n = itemStackArray.length;
        for (int i = 0; !(i >= n || (stack = itemStackArray[i]) != null && !stack.equals(ignored) && stack.func_77973_b() instanceof IDemonWillGem && (remaining -= ((IDemonWillGem)stack.func_77973_b()).fillWill(type, stack, remaining, true)) <= 0.0); ++i) {
        }
        return amount - remaining;
    }
}

