/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.api.util.helper;

import WayofTime.bloodmagic.api.event.SoulNetworkEvent;
import WayofTime.bloodmagic.api.orb.IBloodOrb;
import WayofTime.bloodmagic.api.registry.OrbRegistry;
import WayofTime.bloodmagic.api.saving.BMWorldSavedData;
import WayofTime.bloodmagic.api.saving.SoulNetwork;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import com.google.common.base.Strings;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class NetworkHelper {
    public static SoulNetwork getSoulNetwork(String uuid) {
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world == null || world.func_175693_T() == null) {
            return new BMWorldSavedData().getNetwork(UUID.fromString(uuid));
        }
        BMWorldSavedData saveData = (BMWorldSavedData)world.func_175693_T().func_75742_a(BMWorldSavedData.class, "BloodMagic-SoulNetworks");
        if (saveData == null) {
            saveData = new BMWorldSavedData();
            world.func_175693_T().func_75745_a("BloodMagic-SoulNetworks", (WorldSavedData)saveData);
        }
        return saveData.getNetwork(UUID.fromString(uuid));
    }

    public static SoulNetwork getSoulNetwork(UUID uuid) {
        return NetworkHelper.getSoulNetwork(uuid.toString());
    }

    public static SoulNetwork getSoulNetwork(EntityPlayer player) {
        return NetworkHelper.getSoulNetwork(PlayerHelper.getUUIDFromPlayer(player));
    }

    public static int getCurrentMaxOrb(SoulNetwork soulNetwork) {
        return soulNetwork.getOrbTier();
    }

    public static int getMaximumForTier(int tier) {
        int ret = 0;
        if (tier > OrbRegistry.getTierMap().size() || tier < 0) {
            return ret;
        }
        for (ItemStack orbStack : OrbRegistry.getOrbsForTier(tier)) {
            if (((IBloodOrb)orbStack.func_77973_b()).getMaxEssence(orbStack.func_77952_i()) <= ret) continue;
            ret = ((IBloodOrb)orbStack.func_77973_b()).getMaxEssence(orbStack.func_77952_i());
        }
        return ret;
    }

    public static boolean syphonAndDamage(SoulNetwork soulNetwork, EntityPlayer user, int toSyphon) {
        return soulNetwork.syphonAndDamage(user, toSyphon);
    }

    public static boolean syphonFromContainer(ItemStack stack, int toSyphon) {
        String ownerName = (stack = NBTHelper.checkNBT(stack)).func_77978_p().func_74779_i("ownerUUID");
        if (Strings.isNullOrEmpty((String)ownerName)) {
            return false;
        }
        SoulNetwork network = NetworkHelper.getSoulNetwork(ownerName);
        SoulNetworkEvent.ItemDrainInContainerEvent event = new SoulNetworkEvent.ItemDrainInContainerEvent(stack, ownerName, toSyphon);
        return !MinecraftForge.EVENT_BUS.post((Event)event) && event.getResult() != Event.Result.DENY && network.syphon(event.syphon) >= toSyphon;
    }

    public static boolean canSyphonFromContainer(ItemStack stack, int toSyphon) {
        String ownerName = (stack = NBTHelper.checkNBT(stack)).func_77978_p().func_74779_i("ownerUUID");
        if (Strings.isNullOrEmpty((String)ownerName)) {
            return false;
        }
        SoulNetwork network = NetworkHelper.getSoulNetwork(ownerName);
        return network.getCurrentEssence() >= toSyphon;
    }

    public static void setMaxOrb(SoulNetwork soulNetwork, int maxOrb) {
        soulNetwork.setOrbTier(Math.max(maxOrb, soulNetwork.getOrbTier()));
    }
}

