/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.tile.TileBloodTank;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockBloodTank
extends BlockContainer {
    public BlockBloodTank() {
        super(Material.field_151573_f);
        this.func_149663_c("BloodMagic.bloodTank");
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a(BloodMagic.tabBloodMagic);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileBloodTank();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileBloodTank fluidHandler = (TileBloodTank)world.func_175625_s(blockPos);
        if (Utils.fillHandlerWithContainer(world, fluidHandler, player)) {
            world.func_184138_a(blockPos, state, state, 3);
            return true;
        }
        if (Utils.fillContainerFromHandler(world, fluidHandler, player, fluidHandler.tank.getFluid())) {
            world.func_184138_a(blockPos, state, state, 3);
            return true;
        }
        if (FluidContainerRegistry.isContainer((ItemStack)heldItem)) {
            world.func_184138_a(blockPos, state, state, 3);
            return true;
        }
        return super.func_180639_a(world, blockPos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_176226_b(worldIn, pos, state, 0);
        super.func_176208_a(worldIn, pos, state, player);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos blockPos, IBlockState blockState, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (world.func_175625_s(blockPos) instanceof TileBloodTank) {
            TileBloodTank bloodTank = (TileBloodTank)world.func_175625_s(blockPos);
            ItemStack drop = new ItemStack((Block)this);
            NBTTagCompound tag = new NBTTagCompound();
            bloodTank.func_189515_b(tag);
            drop.func_77982_d(tag);
            list.add(drop);
        }
        return list;
    }

    public void func_180633_a(World world, BlockPos blockPos, IBlockState blockState, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound tag;
        if (world.func_175625_s(blockPos) != null && world.func_175625_s(blockPos) instanceof TileBloodTank && (tag = stack.func_77978_p()) != null) {
            world.func_175625_s(blockPos).func_145839_a(tag);
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBloodTank) {
            TileBloodTank tank = (TileBloodTank)tile;
            FluidStack fluid = tank.tank.getFluid();
            if (fluid != null) {
                return fluid.getFluid().getLuminosity(fluid);
            }
        }
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getDrops((IBlockAccess)world, pos, world.func_180495_p(pos), 0).get(0);
    }
}

