/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.BlockStack;
import WayofTime.bloodmagic.api.registry.ImperfectRitualRegistry;
import WayofTime.bloodmagic.api.registry.RitualRegistry;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.imperfect.ImperfectRitual;
import WayofTime.bloodmagic.api.util.helper.RitualHelper;
import WayofTime.bloodmagic.block.base.BlockStringContainer;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.tile.TileImperfectRitualStone;
import WayofTime.bloodmagic.tile.TileMasterRitualStone;
import WayofTime.bloodmagic.util.ChatUtil;
import amerifrance.guideapi.api.IGuideLinked;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@Optional.Interface(modid="guideapi", iface="amerifrance.guideapi.api.IGuideLinked")
public class BlockRitualController
extends BlockStringContainer
implements IVariantProvider,
IGuideLinked {
    public static final String[] names = new String[]{"master", "imperfect"};

    public BlockRitualController() {
        super(Material.field_151576_e, names);
        this.func_149663_c("BloodMagic.stone.ritual.");
        this.func_149647_a(BloodMagic.tabBloodMagic);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (this.func_176201_c(state) == 0 && tile instanceof TileMasterRitualStone) {
            if (heldItem != null && heldItem.func_77973_b() == ModItems.ACTIVATION_CRYSTAL) {
                String key = RitualHelper.getValidRitual(world, pos);
                EnumFacing direction = RitualHelper.getDirectionOfRitual(world, pos, key);
                if (!key.isEmpty() && direction != null && RitualHelper.checkValidRitual(world, pos, key, direction)) {
                    if (((TileMasterRitualStone)tile).activateRitual(heldItem, player, RitualRegistry.getRitualForId(key))) {
                        ((TileMasterRitualStone)tile).setDirection(direction);
                    }
                } else {
                    ChatUtil.sendNoSpamUnloc(player, "chat.BloodMagic.ritual.notValid");
                }
            }
        } else if (this.func_176201_c(state) == 1 && tile instanceof TileImperfectRitualStone) {
            IBlockState determinerState = world.func_180495_p(pos.func_177984_a());
            BlockStack determiner = new BlockStack(determinerState.func_177230_c(), determinerState.func_177230_c().func_176201_c(determinerState));
            return ((TileImperfectRitualStone)tile).performRitual(world, pos, ImperfectRitualRegistry.getRitualForBlock(determiner), player);
        }
        return false;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (this.func_176201_c(state) == 0 && tile instanceof TileMasterRitualStone) {
            ((TileMasterRitualStone)tile).stopRitual(Ritual.BreakType.BREAK_MRS);
        }
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMasterRitualStone) {
            ((TileMasterRitualStone)tile).stopRitual(Ritual.BreakType.EXPLOSION);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return meta == 0 ? new TileMasterRitualStone() : new TileImperfectRitualStone();
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        for (int i = 0; i < names.length; ++i) {
            ret.add((Pair<Integer, String>)new ImmutablePair((Object)i, (Object)("type=" + names[i])));
        }
        return ret;
    }

    @Nullable
    public ResourceLocation getLinkedEntry(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        ImperfectRitual imperfectRitual;
        IBlockState state = world.func_180495_p(pos);
        if (((String)((Object)state.func_177229_b((IProperty)this.getStringProp()))).equals(names[0])) {
            TileMasterRitualStone mrs = (TileMasterRitualStone)world.func_175625_s(pos);
            if (mrs == null || mrs.getCurrentRitual() == null) {
                return null;
            }
            return new ResourceLocation("bloodmagic", "ritual_" + mrs.getCurrentRitual().getName());
        }
        if (((String)((Object)state.func_177229_b((IProperty)this.getStringProp()))).equals(names[1]) && (imperfectRitual = ImperfectRitualRegistry.getRitualForBlock(BlockStack.getStackFromPos(world, pos.func_177984_a()))) != null) {
            return new ResourceLocation("bloodmagic", "ritual_" + imperfectRitual.getName());
        }
        return null;
    }
}

