/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.block.base;

import WayofTime.bloodmagic.block.property.UnlistedPropertyInteger;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInteger
extends Block {
    private final int maxMeta;
    private final PropertyInteger metaProp;
    private final IUnlistedProperty unlistedMetaProp;
    private final BlockStateContainer realBlockState;

    public BlockInteger(Material material, int maxMeta, String propName) {
        super(material);
        this.maxMeta = maxMeta;
        this.metaProp = PropertyInteger.func_177719_a((String)propName, (int)0, (int)maxMeta);
        this.unlistedMetaProp = new UnlistedPropertyInteger(maxMeta, propName);
        this.realBlockState = this.createRealBlockState();
        this.setupStates();
    }

    public BlockInteger(Material material, int maxMeta) {
        this(material, maxMeta, "meta");
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.metaProp, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.metaProp);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public BlockStateContainer func_176194_O() {
        return this.realBlockState;
    }

    public BlockStateContainer func_180661_e() {
        return Blocks.field_150350_a.func_176194_O();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        for (int i = 0; i < this.maxMeta + 1; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    private void setupStates() {
        this.func_180632_j(this.getExtendedBlockState().withProperty(this.unlistedMetaProp, (Object)0).func_177226_a((IProperty)this.metaProp, (Comparable)Integer.valueOf(0)));
    }

    public ExtendedBlockState getBaseExtendedState() {
        return (ExtendedBlockState)this.func_176194_O();
    }

    public IExtendedBlockState getExtendedBlockState() {
        return (IExtendedBlockState)this.getBaseExtendedState().func_177621_b();
    }

    private BlockStateContainer createRealBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{this.metaProp}, new IUnlistedProperty[]{this.unlistedMetaProp});
    }

    public int getMaxMeta() {
        return this.maxMeta;
    }

    public PropertyInteger getMetaProp() {
        return this.metaProp;
    }

    public IUnlistedProperty getUnlistedMetaProp() {
        return this.unlistedMetaProp;
    }

    public BlockStateContainer getRealBlockState() {
        return this.realBlockState;
    }
}

